/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.i18n;

import com.zimbra.cs.taglib.tag.i18n.I18nUtil;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class ParseNumberTag
extends BodyTagSupport {
    protected String value;
    protected String type = "number";
    protected String pattern;
    protected Locale parseLocale;
    protected Boolean integerOnly;
    protected String var;
    protected int scope = 1;

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setParseLocale(Locale locale) {
        this.parseLocale = locale;
    }

    public void setIntegerOnly(boolean integerOnly) {
        this.integerOnly = integerOnly;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = I18nUtil.getScope(scope);
    }

    public int doStartTag() throws JspException {
        return this.value == null ? 2 : 0;
    }

    public int doAfterBody() throws JspException {
        this.value = this.getBodyContent().getString().trim();
        return 0;
    }

    public int doEndTag() throws JspException {
        NumberFormat parser;
        PageContext pageContext = this.pageContext;
        String value = this.value;
        Locale locale = this.parseLocale;
        if (locale == null) {
            locale = I18nUtil.findLocale(pageContext);
        }
        if (this.pattern != null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            parser = new DecimalFormat(this.pattern, symbols);
        } else {
            String type;
            String string = type = this.type != null ? this.type : "number";
            parser = "number".equals(type) ? NumberFormat.getNumberInstance(locale) : ("currency".equals(type) ? NumberFormat.getCurrencyInstance(locale) : NumberFormat.getPercentInstance(locale));
            if (this.integerOnly != null) {
                parser.setParseIntegerOnly(this.integerOnly);
            }
        }
        Number number = null;
        try {
            number = parser.parse(value);
        }
        catch (ParseException e) {
            throw new JspException((Throwable)e);
        }
        if (this.var == null) {
            try {
                pageContext.getOut().print((Object)number);
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        } else {
            pageContext.setAttribute(this.var, (Object)number, this.scope);
        }
        this.value = null;
        this.type = "number";
        this.pattern = null;
        this.parseLocale = null;
        this.integerOnly = null;
        this.var = null;
        this.scope = 1;
        return 6;
    }
}

