/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.i18n;

import com.zimbra.cs.taglib.tag.i18n.I18nUtil;
import com.zimbra.cs.taglib.tag.i18n.TimeZoneTag;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;

public class ParseDateTag
extends BodyTagSupport {
    protected String value;
    protected String type;
    protected String dateStyle;
    protected String timeStyle;
    protected String pattern;
    protected TimeZone timeZone;
    protected Locale locale;
    protected String var;
    protected int scope = 1;

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDateStyle(String style) {
        this.dateStyle = style;
    }

    public void setTimeStyle(String style) {
        this.timeStyle = style;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setTimeZone(Object timeZone) {
        this.timeZone = timeZone instanceof TimeZone ? (TimeZone)timeZone : TimeZone.getTimeZone(String.valueOf(timeZone));
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLocale(String locale) {
        this.locale = I18nUtil.getLocale(locale);
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = I18nUtil.getScope(scope);
    }

    public int doStartTag() throws JspException {
        return this.value == null ? 2 : 0;
    }

    public int doAfterBody() throws JspException {
        this.value = this.getBodyContent().getString().trim();
        return 0;
    }

    public int doEndTag() throws JspException {
        TimeZone timeZone;
        DateFormat parser;
        PageContext pageContext = this.pageContext;
        String value = this.value;
        Locale locale = this.locale;
        if (locale == null) {
            locale = I18nUtil.findLocale(pageContext);
        }
        SimpleDateFormat simpleDateFormat = parser = this.pattern != null ? new SimpleDateFormat(this.pattern, locale) : null;
        if (parser == null) {
            int dateStyle = I18nUtil.getStyle(this.dateStyle);
            int timeStyle = I18nUtil.getStyle(this.timeStyle);
            parser = "date".equalsIgnoreCase(this.type) ? DateFormat.getDateInstance(dateStyle, locale) : ("time".equalsIgnoreCase(this.type) ? DateFormat.getTimeInstance(timeStyle, locale) : DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale));
        }
        if ((timeZone = this.timeZone) == null) {
            TimeZoneTag timeZoneTag = (TimeZoneTag)ParseDateTag.findAncestorWithClass((Tag)this, TimeZoneTag.class);
            if (timeZoneTag != null) {
                timeZone = timeZoneTag.getTimeZone();
            }
            if (timeZone == null) {
                timeZone = I18nUtil.findTimeZone(pageContext);
            }
        }
        parser.setTimeZone(timeZone);
        Date date = null;
        try {
            date = parser.parse(value);
        }
        catch (ParseException e) {
            throw new JspException((Throwable)e);
        }
        if (this.var == null) {
            try {
                pageContext.getOut().print((Object)date);
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        } else {
            pageContext.setAttribute(this.var, (Object)date, this.scope);
        }
        this.value = null;
        this.type = null;
        this.dateStyle = null;
        this.timeStyle = null;
        this.pattern = null;
        this.timeZone = null;
        this.locale = null;
        this.var = null;
        this.scope = 1;
        return 6;
    }
}

