/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.i18n;

import com.zimbra.cs.taglib.tag.i18n.BundleTag;
import com.zimbra.cs.taglib.tag.i18n.I18nUtil;
import com.zimbra.cs.taglib.tag.i18n.TimeZoneTag;
import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;

public class MessageTag
extends BodyTagSupport {
    protected String pattern;
    protected ResourceBundle bundle;
    protected String key;
    protected String var;
    protected int scope = 1;
    protected List<Object> params;

    public void addParam(Object value) {
        this.params.add(value);
    }

    public Object[] getParams() {
        return this.params.toArray(new Object[0]);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = I18nUtil.getScope(scope);
    }

    public int doStartTag() throws JspException {
        this.params = new LinkedList<Object>();
        return 2;
    }

    public int doEndTag() throws JspException {
        String pattern = this.pattern;
        ResourceBundle bundle = null;
        if (pattern == null) {
            BundleTag bundleTag;
            String prefix = null;
            bundle = this.bundle;
            if (bundle == null && (bundleTag = (BundleTag)MessageTag.findAncestorWithClass((Tag)this, BundleTag.class)) != null) {
                bundle = bundleTag.getBundle();
                prefix = bundleTag.getPrefix();
            }
            if (bundle == null) {
                bundle = I18nUtil.findBundle(this.pageContext);
            }
            try {
                pattern = bundle.getString(prefix != null ? prefix + this.key : this.key);
            }
            catch (Exception e) {
                pattern = "???" + this.key + "???";
            }
        }
        String message = pattern;
        if ((this.pattern != null || bundle != null) && this.params.size() != 0) {
            TimeZone timeZone = null;
            TimeZoneTag timeZoneTag = (TimeZoneTag)MessageTag.findAncestorWithClass((Tag)this, TimeZoneTag.class);
            if (timeZoneTag != null) {
                timeZone = timeZoneTag.getTimeZone();
            }
            if (timeZone == null) {
                timeZone = I18nUtil.findTimeZone(this.pageContext);
            }
            MessageFormat formatter = new MessageFormat(pattern, I18nUtil.findLocale(this.pageContext));
            for (Format format : formatter.getFormatsByArgumentIndex()) {
                if (format == null || !(format instanceof DateFormat)) continue;
                ((DateFormat)format).setTimeZone(timeZone);
            }
            message = formatter.format(this.getParams());
        }
        if (this.var == null) {
            try {
                this.pageContext.getOut().print(message);
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        } else {
            this.pageContext.setAttribute(this.var, (Object)message, this.scope);
        }
        this.pattern = null;
        this.bundle = null;
        this.key = null;
        this.var = null;
        this.scope = 1;
        return 6;
    }
}

