/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.i18n;

import com.zimbra.client.ZMailbox;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.taglib.ZJspSession;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;

public class I18nUtil {
    public static final String PAGE = "page";
    public static final String REQUEST = "request";
    public static final String SESSION = "session";
    public static final String APPLICATION = "application";
    public static final String STYLE_SHORT = "short";
    public static final String STYLE_MEDIUM = "medium";
    public static final String STYLE_LONG = "long";
    public static final String STYLE_FULL = "full";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_TIME = "time";
    public static final String TYPE_BOTH = "both";
    public static final String TYPE_NUMBER = "number";
    public static final String TYPE_CURRENCY = "currency";
    public static final String TYPE_PERCENTAGE = "percent";
    public static final String DEFAULT_SCOPE_NAME = "page";
    public static final int DEFAULT_SCOPE_VALUE = 1;
    public static final String DEFAULT_STYLE_NAME = "medium";
    public static final int DEFAULT_STYLE_VALUE = 2;
    public static final String DEFAULT_DATE_TYPE_NAME = "date";
    public static final String DEFAULT_NUMBER_TYPE_NAME = "number";
    private static final String PACKAGE = I18nUtil.class.getPackage().getName();
    public static final String DEFAULT_LOCALE_VAR = PACKAGE + ".locale";
    public static final String DEFAULT_TIMEZONE_VAR = PACKAGE + ".timezone";
    public static final String DEFAULT_BUNDLE_VAR = PACKAGE + ".bundle";
    public static final String DEFAULT_BUNDLE_KEY = PACKAGE + ".key";
    private static final String A_SKIN = "skin";

    public static String getLocalizedMessage(PageContext pageContext, String key) {
        return I18nUtil.getLocalizedMessage(pageContext, key, null, DEFAULT_BUNDLE_VAR, 1, null);
    }

    public static String getLocalizedMessage(PageContext pageContext, String key, Object[] args) {
        return I18nUtil.getLocalizedMessage(pageContext, key, args, DEFAULT_BUNDLE_VAR, 1, null);
    }

    public static String getLocalizedMessage(PageContext pageContext, String key, String basename) {
        return I18nUtil.getLocalizedMessage(pageContext, key, null, null, -1, basename);
    }

    public static String getLocalizedMessage(PageContext pageContext, String key, Object[] args, String basename) {
        return I18nUtil.getLocalizedMessage(pageContext, key, args, null, -1, basename);
    }

    private static String getLocalizedMessage(PageContext pageContext, String key, Object[] args, String var, int scope, String basename) {
        String pattern;
        try {
            ResourceBundle bundle = I18nUtil.findBundle(pageContext, var, scope, basename);
            pattern = bundle.getString(key);
        }
        catch (Exception e) {
            pattern = "???" + key + "???";
        }
        String message = pattern;
        if (args != null && args.length > 0) {
            Locale locale = I18nUtil.findLocale(pageContext);
            TimeZone timeZone = I18nUtil.findTimeZone(pageContext);
            MessageFormat formatter = new MessageFormat(pattern, locale);
            for (Format format : formatter.getFormatsByArgumentIndex()) {
                if (format == null || !(format instanceof DateFormat)) continue;
                ((DateFormat)format).setTimeZone(timeZone);
            }
            message = formatter.format(args);
        }
        return message;
    }

    public static Object evaluate(PageContext pageContext, String expression, Class type) throws JspException {
        if (expression == null || expression.trim().length() == 0) {
            return null;
        }
        ExpressionEvaluator evaluator = pageContext.getExpressionEvaluator();
        VariableResolver resolver = pageContext.getVariableResolver();
        FunctionMapper mapper = null;
        try {
            return evaluator.evaluate(expression, type, resolver, mapper);
        }
        catch (ELException e) {
            throw new JspException((Throwable)e);
        }
    }

    public static int getScope(String scope) {
        if ("page".equalsIgnoreCase(scope)) {
            return 1;
        }
        if (REQUEST.equalsIgnoreCase(scope)) {
            return 2;
        }
        if (SESSION.equalsIgnoreCase(scope)) {
            return 3;
        }
        if (APPLICATION.equalsIgnoreCase(scope)) {
            return 4;
        }
        return 1;
    }

    public static String getScope(int scope) {
        switch (scope) {
            case 1: {
                return "page";
            }
            case 2: {
                return REQUEST;
            }
            case 3: {
                return SESSION;
            }
            case 4: {
                return APPLICATION;
            }
        }
        return "page";
    }

    public static int getStyle(String style) {
        if (STYLE_SHORT.equalsIgnoreCase(style)) {
            return 3;
        }
        if ("medium".equalsIgnoreCase(style)) {
            return 2;
        }
        if (STYLE_LONG.equalsIgnoreCase(style)) {
            return 1;
        }
        if (STYLE_FULL.equalsIgnoreCase(style)) {
            return 0;
        }
        return 2;
    }

    public static Object findObject(PageContext pageContext, String var) {
        return I18nUtil.findObject(pageContext, var, 1);
    }

    public static Object findObject(PageContext pageContext, String var, int scope) {
        for (int i = scope; i <= 4; ++i) {
            try {
                Object object = pageContext.getAttribute(var, i);
                if (object == null) continue;
                return object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Locale getLocale(String id) {
        String country;
        if ("nb-NO".equals(id)) {
            return new Locale("no", "NO", "NY");
        }
        StringTokenizer tokenizer = new StringTokenizer(id, "_-");
        String language = tokenizer.nextToken();
        String string = country = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
        if (country != null) {
            String variant;
            String string2 = variant = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            if (variant != null) {
                return new Locale(language, country, variant);
            }
            return new Locale(language, country);
        }
        return new Locale(language);
    }

    public static Locale findLocale(PageContext pageContext) {
        return I18nUtil.findLocale(pageContext, DEFAULT_LOCALE_VAR, 1);
    }

    public static Locale findLocale(PageContext pageContext, String var) {
        return I18nUtil.findLocale(pageContext, var, 1);
    }

    public static Locale findLocale(PageContext pageContext, String var, int scope) {
        Locale locale = (Locale)I18nUtil.findObject(pageContext, var, scope);
        if (locale == null) {
            locale = pageContext.getRequest().getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static TimeZone findTimeZone(PageContext pageContext) {
        return I18nUtil.findTimeZone(pageContext, DEFAULT_TIMEZONE_VAR, 1);
    }

    public static TimeZone findTimeZone(PageContext pageContext, String var) {
        return I18nUtil.findTimeZone(pageContext, var, 1);
    }

    public static TimeZone findTimeZone(PageContext pageContext, String var, int scope) {
        TimeZone tz = (TimeZone)I18nUtil.findObject(pageContext, var, scope);
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        return tz;
    }

    public static String makeBasename(PageContext pageContext, String basename) {
        String skin = (String)I18nUtil.findObject(pageContext, A_SKIN);
        return skin != null ? "/skins/" + skin + basename : basename;
    }

    public static String makeBundleKey(PageContext pageContext, String basename) {
        return I18nUtil.makeBundleKey(pageContext, basename, I18nUtil.findLocale(pageContext));
    }

    public static String makeBundleKey(PageContext pageContext, String basename, Locale locale) {
        String skin = (String)I18nUtil.findObject(pageContext, A_SKIN);
        if (skin == null) {
            skin = "[unknown]";
        }
        return skin + ":" + basename + ":" + locale + ":" + DEFAULT_BUNDLE_KEY;
    }

    public static ResourceBundle findBundle(PageContext pageContext) {
        return I18nUtil.findBundle(pageContext, DEFAULT_BUNDLE_VAR, 1, null);
    }

    public static ResourceBundle findBundle(PageContext pageContext, String var) {
        return I18nUtil.findBundle(pageContext, var, 1, null);
    }

    public static ResourceBundle findBundle(PageContext pageContext, String var, int scope) {
        return I18nUtil.findBundle(pageContext, var, scope, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle findBundle(PageContext pageContext, String var, int scope, String basename) {
        ResourceBundle bundle = null;
        if (basename != null) {
            String bundleKey = I18nUtil.makeBundleKey(pageContext, basename);
            bundle = (ResourceBundle)pageContext.getAttribute(bundleKey, 4);
            if (bundle == null) {
                ClassLoader oLoader;
                Locale locale = I18nUtil.findLocale(pageContext);
                Thread thread = Thread.currentThread();
                ClassLoader nLoader = oLoader = thread.getContextClassLoader();
                try {
                    nLoader = new ResourceLoader(oLoader, pageContext);
                    thread.setContextClassLoader(nLoader);
                }
                catch (Exception e) {
                    ZimbraLog.webclient.debug((Object)("FindBundle:error in overriding the class loader" + e));
                    e.printStackTrace();
                }
                try {
                    bundle = ResourceBundle.getBundle(basename, locale, nLoader);
                    pageContext.setAttribute(bundleKey, (Object)bundle, 4);
                }
                catch (MissingResourceException e) {
                    ZimbraLog.webclient.debug((Object)("MissingResourceException:" + e));
                    e.printStackTrace();
                }
                catch (Exception e) {
                    ZimbraLog.webclient.debug((Object)("FindBundle:error in fetching the bundle resource" + e));
                    e.printStackTrace();
                }
                finally {
                    thread.setContextClassLoader(oLoader);
                }
            }
        } else if (var != null) {
            bundle = (ResourceBundle)I18nUtil.findObject(pageContext, var, scope);
        }
        if (bundle != null && var != null) {
            pageContext.setAttribute(var, (Object)bundle, scope);
        }
        return bundle;
    }

    public static void clearBundle(PageContext pageContext, String var, int scope, String basename) {
        if (basename != null) {
            String bundleKey = I18nUtil.makeBundleKey(pageContext, basename);
            pageContext.removeAttribute(bundleKey, 4);
        }
        if (var != null) {
            for (int i = scope; i >= 1; --i) {
                pageContext.removeAttribute(var, i);
            }
        }
    }

    private I18nUtil() {
    }

    static class ResourceLoader
    extends ClassLoader {
        private PageContext pageContext;
        public static final String P_SKIN = "skin";
        public static final String P_DEFAULT_SKIN = "zimbraDefaultSkin";
        public static final String A_SKIN = "skin";
        protected static final String MANIFEST = "manifest.xml";

        public ResourceLoader(ClassLoader parent, PageContext pageContext) {
            super(parent);
            this.pageContext = pageContext;
        }

        String setSkin(ServletRequest request, ServletResponse response) {
            File manifest;
            String skin;
            block8: {
                PageContext context;
                HttpSession hsession;
                skin = (String)request.getAttribute("skin");
                if (skin == null) {
                    skin = request.getParameter("skin");
                }
                if (skin == null && (hsession = ((HttpServletRequest)request).getSession(false)) != null) {
                    skin = (String)hsession.getAttribute("skin");
                }
                ZMailbox mailbox = null;
                if (skin == null && ZJspSession.hasSession(context = this.pageContext)) {
                    try {
                        ZJspSession zsession = ZJspSession.getSession(context);
                        if (zsession != null) {
                            mailbox = ZJspSession.getZMailbox(context);
                            skin = mailbox.getPrefs().getSkin();
                        }
                    }
                    catch (Exception e) {
                        if (!ZimbraLog.webclient.isDebugEnabled()) break block8;
                        ZimbraLog.webclient.debug((Object)"no zimbra session");
                    }
                }
            }
            if (skin != null && !(manifest = new File(this.pageContext.getServletContext().getRealPath("/skins/" + skin + "/" + MANIFEST))).exists()) {
                ZimbraLog.webclient.debug((Object)("selected skin (" + skin + ") doesn't exist"));
                skin = null;
            }
            if (skin == null) {
                skin = this.pageContext.getServletContext().getInitParameter(P_DEFAULT_SKIN);
            }
            this.pageContext.setAttribute("skin", (Object)skin);
            return skin;
        }

        @Override
        public InputStream getResourceAsStream(String filename) {
            String basename;
            boolean isMsgOrKey;
            if (ZimbraLog.webclient.isDebugEnabled()) {
                ZimbraLog.webclient.debug((Object)("getResourceAsStream: filename=" + filename));
            }
            boolean bl = isMsgOrKey = (basename = filename.replaceAll("^/skins/[^/]+", "")).startsWith("/messages/") || basename.startsWith("/keys/");
            if (!isMsgOrKey) {
                return super.getResourceAsStream(filename);
            }
            InputStream stream = super.getResourceAsStream(basename);
            String skin = (String)this.pageContext.getAttribute("skin");
            if (skin == null) {
                skin = this.setSkin(this.pageContext.getRequest(), this.pageContext.getResponse());
            }
            ZimbraLog.webclient.debug((Object)("omega:" + this.pageContext.getServletContext().getRealPath("/skins/" + skin + basename)));
            File file = new File(this.pageContext.getServletContext().getRealPath("/skins/" + skin + basename));
            if (file.exists()) {
                if (ZimbraLog.webclient.isDebugEnabled()) {
                    ZimbraLog.webclient.debug((Object)("  found message overrides for skin=" + skin));
                }
                try {
                    FileInputStream skinStream = new FileInputStream(file);
                    ByteArrayInputStream newlineStream = new ByteArrayInputStream("\n".getBytes());
                    stream = stream != null ? new SequenceInputStream(stream, new SequenceInputStream(newlineStream, skinStream)) : skinStream;
                }
                catch (FileNotFoundException e) {
                    ZimbraLog.webclient.debug((Object)("FileNotFoundException:" + e));
                }
            }
            return stream;
        }
    }
}

