/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.i18n;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.cs.taglib.ZJspSession;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class GetValidLocaleTag
extends ZimbraSimpleTag {
    private String mVar;
    private String mLocale;
    private ZAuthToken mAuthToken;
    private String mCsrfToken;

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setLocale(String locale) {
        this.mLocale = locale;
    }

    public void setAuthtoken(ZAuthToken authToken) {
        this.mAuthToken = authToken;
    }

    public void setCsrftoken(String csrfToken) {
        this.mCsrfToken = csrfToken;
    }

    public void doTag() throws JspException, IOException {
        JspContext ctxt = this.getJspContext();
        if (this.mLocale == null) {
            ctxt.setAttribute(this.mVar, (Object)false, 2);
            return;
        }
        SoapHttpTransport transport = null;
        try {
            String soapUri = ZJspSession.getSoapURL((PageContext)ctxt);
            transport = new SoapHttpTransport(soapUri);
            transport.setAuthToken(this.mAuthToken);
            transport.setCsrfToken(this.mCsrfToken);
            Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_AVAILABLE_LOCALES_REQUEST);
            Element resp = transport.invokeWithoutSession((Element)req);
            ArrayList<String> locales = new ArrayList<String>();
            for (Element locale : resp.listElements("locale")) {
                String id = locale.getAttribute("id", null);
                if (id == null) continue;
                locales.add(id);
            }
            Collections.sort(locales);
            boolean isValid = false;
            for (String s : locales) {
                if (!this.mLocale.toLowerCase().startsWith(s.toLowerCase())) continue;
                isValid = true;
                break;
            }
            ctxt.setAttribute(this.mVar, (Object)isValid, 2);
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (transport != null) {
                transport.shutdown();
            }
        }
    }
}

