/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.i18n;

import com.zimbra.cs.taglib.tag.i18n.I18nUtil;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class FormatNumberTag
extends BodyTagSupport {
    protected Number value;
    protected String type = "number";
    protected String pattern;
    protected String currencyCode;
    protected String currencySymbol;
    protected Boolean groupingUsed;
    protected int maxIntegerDigits = -1;
    protected int minIntegerDigits = -1;
    protected int maxFractionDigits = -1;
    protected int minFractionDigits = -1;
    protected String var;
    protected int scope = 1;

    public void setValue(String value) {
        try {
            this.value = Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            this.value = Long.valueOf(value);
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setCurrencyCode(String code) {
        this.currencyCode = code;
    }

    public void setCurrencySymbol(String symbol) {
        this.currencySymbol = symbol;
    }

    public void setGroupingUsed(boolean used) {
        this.groupingUsed = used;
    }

    public void setMaxIntegerDigits(int digits) {
        this.maxIntegerDigits = digits;
    }

    public void setMinIntegerDigits(int digits) {
        this.minIntegerDigits = digits;
    }

    public void setMaxFractionDigits(int digits) {
        this.maxFractionDigits = digits;
    }

    public void setMinFractionDigits(int digits) {
        this.minFractionDigits = digits;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = I18nUtil.getScope(scope);
    }

    public int doStartTag() throws JspException {
        return this.value == null ? 2 : 0;
    }

    public int doAfterBody() throws JspException {
        String text = this.getBodyContent().getString().trim();
        this.setValue(text);
        return 0;
    }

    public int doEndTag() throws JspException {
        String message;
        NumberFormat formatter;
        PageContext pageContext = this.pageContext;
        Locale locale = I18nUtil.findLocale(pageContext);
        if (this.pattern != null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            formatter = new DecimalFormat(this.pattern, symbols);
        } else {
            String type;
            String string = type = this.type != null ? this.type : "number";
            if ("number".equals(type)) {
                formatter = NumberFormat.getNumberInstance(locale);
            } else if ("currency".equals(type)) {
                formatter = NumberFormat.getCurrencyInstance(locale);
                if (this.currencyCode != null) {
                    try {
                        Currency currency = Currency.getInstance(this.currencyCode);
                        formatter.setCurrency(currency);
                    }
                    catch (Exception e) {
                        throw new JspException("invalid currency", (Throwable)e);
                    }
                }
                if (this.currencySymbol != null) {
                    DecimalFormat decimalFormatter = (DecimalFormat)formatter;
                    DecimalFormatSymbols symbols = decimalFormatter.getDecimalFormatSymbols();
                    symbols.setCurrencySymbol(this.currencySymbol);
                    decimalFormatter.setDecimalFormatSymbols(symbols);
                }
            } else {
                formatter = NumberFormat.getPercentInstance(locale);
            }
            if (this.groupingUsed != null) {
                formatter.setGroupingUsed(this.groupingUsed);
            }
            if (this.maxIntegerDigits != -1) {
                formatter.setMaximumIntegerDigits(this.maxIntegerDigits);
            }
            if (this.minIntegerDigits != -1) {
                formatter.setMinimumIntegerDigits(this.minIntegerDigits);
            }
            if (this.maxFractionDigits != -1) {
                formatter.setMaximumFractionDigits(this.maxFractionDigits);
            }
            if (this.minFractionDigits != -1) {
                formatter.setMinimumFractionDigits(this.minFractionDigits);
            }
        }
        String string = message = this.value instanceof Double || this.value instanceof Float ? formatter.format(this.value.doubleValue()) : formatter.format(this.value.longValue());
        if (this.var == null) {
            try {
                pageContext.getOut().print(message);
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        } else {
            pageContext.setAttribute(this.var, (Object)message, this.scope);
        }
        this.value = null;
        this.type = "number";
        this.pattern = null;
        this.currencyCode = null;
        this.currencySymbol = null;
        this.groupingUsed = null;
        this.maxIntegerDigits = -1;
        this.minIntegerDigits = -1;
        this.maxFractionDigits = -1;
        this.minFractionDigits = -1;
        this.var = null;
        this.scope = 1;
        return 6;
    }
}

