/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.i18n;

import com.zimbra.cs.taglib.tag.i18n.I18nUtil;
import com.zimbra.cs.taglib.tag.i18n.TimeZoneTag;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class FormatDateTag
extends SimpleTagSupport {
    protected Date value;
    protected String type = "date";
    protected String dateStyle;
    protected String timeStyle;
    protected String pattern;
    protected TimeZone timeZone;
    protected String var;
    protected int scope = 1;

    public void setValue(Date value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDateStyle(String style) {
        this.dateStyle = style;
    }

    public void setTimeStyle(String style) {
        this.timeStyle = style;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setTimeZone(Object timeZone) {
        this.timeZone = timeZone instanceof TimeZone ? (TimeZone)timeZone : TimeZone.getTimeZone(String.valueOf(timeZone));
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = I18nUtil.getScope(scope);
    }

    public void doTag() throws JspException, IOException {
        TimeZone tz;
        DateFormat formatter;
        PageContext pageContext = (PageContext)this.getJspContext();
        Locale locale = I18nUtil.findLocale(pageContext);
        SimpleDateFormat simpleDateFormat = formatter = this.pattern != null ? new SimpleDateFormat(this.pattern, locale) : null;
        if (formatter == null) {
            int dateStyle = I18nUtil.getStyle(this.dateStyle);
            int timeStyle = I18nUtil.getStyle(this.timeStyle);
            formatter = "date".equalsIgnoreCase(this.type) ? DateFormat.getDateInstance(dateStyle, locale) : ("time".equalsIgnoreCase(this.type) ? DateFormat.getTimeInstance(timeStyle, locale) : DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale));
        }
        if ((tz = this.timeZone) == null) {
            TimeZoneTag timeZoneTag = (TimeZoneTag)FormatDateTag.findAncestorWithClass((JspTag)this, TimeZoneTag.class);
            if (timeZoneTag != null) {
                tz = timeZoneTag.getTimeZone();
            }
            if (tz == null) {
                tz = I18nUtil.findTimeZone(pageContext);
            }
        }
        formatter.setTimeZone(tz);
        String message = formatter.format(this.value);
        if (this.var == null) {
            pageContext.getOut().print(message);
        } else {
            pageContext.setAttribute(this.var, (Object)message, this.scope);
        }
        this.value = null;
        this.type = "date";
        this.dateStyle = null;
        this.timeStyle = null;
        this.pattern = null;
        this.timeZone = null;
        this.var = null;
        this.scope = 1;
    }
}

