/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.folder;

import com.zimbra.client.ZEmailAddress;
import com.zimbra.client.ZGrant;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZGrantBean;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import com.zimbra.cs.taglib.tag.i18n.I18nUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class UpdateFolderGrantTag
extends ZimbraSimpleTag {
    private String mFolderId;
    private String mFolderName;
    private String mGrantorId;
    private String mGrantorName;
    private String mUpdateGrantString;
    private String mRevokeGrantString;
    private String mVar;

    public void setFolderId(String id) {
        this.mFolderId = id;
    }

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setUpdateGrantString(String grantString) {
        this.mUpdateGrantString = grantString;
    }

    public void setRevokeGrantString(String grantString) {
        this.mRevokeGrantString = grantString;
    }

    public void setFolderName(String folderName) {
        this.mFolderName = folderName;
    }

    public void setGrantorId(String grantorId) {
        this.mGrantorId = grantorId;
    }

    public void setGrantorName(String grantorName) {
        this.mGrantorName = grantorName;
    }

    public void doTag() throws JspException, IOException {
        try {
            ZMailbox mbox = this.getMailbox();
            ArrayList<ZGrantBean> updateGrants = this.getGrantsFromString(this.mUpdateGrantString);
            ArrayList<String> failures = new ArrayList<String>();
            for (ZGrantBean grant : updateGrants) {
                try {
                    ZMailbox.ZActionResult zActionResult = mbox.modifyFolderGrant(this.mFolderId, grant.getGranteeType(), grant.getGranteeId(), grant.getPermissions(), null);
                }
                catch (ServiceException e) {
                    failures.add(grant.getGranteeId());
                }
                try {
                    if (grant.getArgs().equalsIgnoreCase("true")) {
                        this.sendGrantShareMail(mbox, grant.getGranteeId());
                    }
                }
                catch (ServiceException serviceException) {
                }
                catch (JspException jspException) {
                    // empty catch block
                }
                this.getJspContext().setAttribute(this.mVar, failures, 2);
            }
            for (String shareId : this.mRevokeGrantString.split(";")) {
                if (shareId.length() <= 0) continue;
                ZMailbox.ZActionResult zActionResult = mbox.modifyFolderRevokeGrant(this.mFolderId, shareId.equals("pub") ? "99999999-9999-9999-9999-999999999999" : shareId);
            }
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    public ZMailbox.ZSendMessageResponse sendGrantShareMail(ZMailbox mbox, String granteeId) throws ServiceException, JspException {
        return this.sendMail(mbox, granteeId, "calendarAddShareMailSubject", "calendarAddShareMailBody");
    }

    public ZMailbox.ZSendMessageResponse sendRevokeShareMail(ZMailbox mbox, String granteeId) throws ServiceException, JspException {
        return this.sendMail(mbox, granteeId, "calendarRevokeShareMailSubject", "calendarRevokeShareMailBody");
    }

    private ZMailbox.ZSendMessageResponse sendMail(ZMailbox mbox, String granteeId, String subjectKey, String bodyKey) throws ServiceException, JspException {
        String subject = I18nUtil.getLocalizedMessage((PageContext)this.getJspContext(), subjectKey, this.mGrantorName);
        String acceptShareLink = "/zimbra/y/mcalendars?action=acceptShare&oc=" + this.mFolderName + "&oe=" + mbox.getAccountInfo(false).getName() + "&od=" + this.mFolderId;
        Object[] bodyArgs = new String[]{this.mGrantorName, this.mFolderName, acceptShareLink};
        String body = I18nUtil.getLocalizedMessage((PageContext)this.getJspContext(), bodyKey, bodyArgs);
        ZMailbox.ZOutgoingMessage m = this.getOutgoingMessage(granteeId, subject, body);
        ZMailbox.ZSendMessageResponse response = mbox.sendMessage(m, null, true);
        return response;
    }

    private ZMailbox.ZOutgoingMessage getOutgoingMessage(String granteeId, String subject, String body) throws ServiceException, JspException {
        ArrayList addrs = new ArrayList();
        List messages = null;
        List attachments = null;
        ZMailbox.ZOutgoingMessage m = new ZMailbox.ZOutgoingMessage();
        if (granteeId != null && granteeId.length() > 0) {
            addrs.addAll(ZEmailAddress.parseAddresses((String)granteeId, (String)"t"));
        }
        m.setAddresses(addrs);
        m.setSubject(subject);
        m.setMessagePart(new ZMailbox.ZOutgoingMessage.MessagePart("text/html", body));
        m.setMessageIdsToAttach(messages);
        m.setMessagePartsToAttach(attachments);
        return m;
    }

    private ArrayList<ZGrantBean> getGrantsFromString(String grantsString) throws ServiceException {
        ArrayList<ZGrantBean> grants = new ArrayList<ZGrantBean>();
        if (grantsString.length() < 1) {
            return grants;
        }
        String[] strGrants = grantsString.split(";");
        for (int x = strGrants.length - 1; x > -1; --x) {
            String[] grantArgs = strGrants[x].split(",");
            ZGrantBean grant = new ZGrantBean();
            grant.setGranteeId(grantArgs[0].equals("pub") ? "99999999-9999-9999-9999-999999999999" : grantArgs[0]);
            grant.setGranteeType(ZGrant.GranteeType.valueOf((String)grantArgs[1]));
            grant.setPermissions(grantArgs[2]);
            grant.setArgs(grantArgs[3]);
            grants.add(grant);
        }
        return grants;
    }
}

