/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.filter;

import com.zimbra.client.ZFilterRule;
import com.zimbra.client.ZFilterRules;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.taglib.bean.ZTagLibException;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;

public class MoveFilterRuleTag
extends ZimbraSimpleTag {
    private String mName;
    private boolean mUp;

    public void setName(String name) {
        this.mName = name;
    }

    public void setDirection(String direction) throws JspTagException {
        boolean up = direction.equalsIgnoreCase("up");
        boolean down = direction.equalsIgnoreCase("down");
        if (!up && !down) {
            throw new JspTagException("moveFilterRule direction must be up or down", null);
        }
        this.mUp = up;
    }

    public void doTag() throws JspException, IOException {
        try {
            ZMailbox mbox = this.getMailbox();
            ZFilterRules zrules = mbox.getIncomingFilterRules(true);
            List rules = zrules.getRules();
            int index = -1;
            for (int i = 0; i < rules.size(); ++i) {
                String ruleName = StringUtil.escapeHtml((String)((ZFilterRule)rules.get(i)).getName());
                if (!ruleName.equalsIgnoreCase(this.mName)) continue;
                index = i;
                break;
            }
            if (index == -1) {
                throw ZTagLibException.NO_SUCH_FILTER_EXISTS("filter with name " + this.mName + " doesn't exist", null);
            }
            if (index == 0 && this.mUp || index == rules.size() - 1 && !this.mUp) {
                return;
            }
            ZFilterRule rule = (ZFilterRule)rules.get(index);
            rules.remove(index);
            if (this.mUp) {
                rules.add(index - 1, rule);
            } else if (++index > rules.size()) {
                rules.add(rule);
            } else {
                rules.add(index, rule);
            }
            mbox.saveIncomingFilterRules(new ZFilterRules(rules));
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }
}

