/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.filter;

import com.zimbra.client.ZFilterRule;
import com.zimbra.client.ZFilterRules;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.taglib.bean.ZTagLibException;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;

public class ModifyFilterRuleTag
extends ZimbraSimpleTag {
    private ZFilterRule mRule;
    private String mOriginalName;

    public void setRule(ZFilterRule rule) {
        this.mRule = rule;
    }

    public void setOriginalname(String originalName) {
        this.mOriginalName = originalName;
    }

    public void doTag() throws JspException, IOException {
        try {
            if (this.mOriginalName == null) {
                this.mOriginalName = this.mRule.getName();
            }
            ZMailbox mbox = this.getMailbox();
            ZFilterRules rules = mbox.getIncomingFilterRules(true);
            ArrayList<ZFilterRule> newRules = new ArrayList<ZFilterRule>();
            boolean origFound = false;
            for (ZFilterRule rule : rules.getRules()) {
                String ruleName = StringUtil.escapeHtml((String)rule.getName());
                if (ruleName.equalsIgnoreCase(this.mOriginalName)) {
                    newRules.add(this.mRule);
                    origFound = true;
                    continue;
                }
                if (rule.getName().equalsIgnoreCase(this.mRule.getName())) {
                    throw ZTagLibException.FILTER_EXISTS("filter with name " + this.mRule.getName() + " already exists", null);
                }
                newRules.add(rule);
            }
            if (!origFound) {
                throw ZTagLibException.NO_SUCH_FILTER_EXISTS("filter with name " + this.mRule.getName() + " doesn't exist", null);
            }
            mbox.saveIncomingFilterRules(new ZFilterRules(newRules));
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }
}

