/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.filter;

import com.zimbra.client.ZFilterRule;
import com.zimbra.client.ZFilterRules;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.taglib.bean.ZTagLibException;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;

public class DeleteFilterRuleTag
extends ZimbraSimpleTag {
    private String mName;

    public void setName(String name) {
        this.mName = name;
    }

    public void doTag() throws JspException, IOException {
        try {
            ZMailbox mbox = this.getMailbox();
            ZFilterRules rules = mbox.getIncomingFilterRules(true);
            ArrayList<ZFilterRule> newRules = new ArrayList<ZFilterRule>();
            boolean found = false;
            for (ZFilterRule rule : rules.getRules()) {
                String ruleName = StringUtil.escapeHtml((String)rule.getName());
                if (ruleName.equalsIgnoreCase(this.mName)) {
                    found = true;
                    continue;
                }
                newRules.add(rule);
            }
            if (!found) {
                throw ZTagLibException.NO_SUCH_FILTER_EXISTS("filter with name " + this.mName + " doesn't exist", null);
            }
            mbox.saveIncomingFilterRules(new ZFilterRules(newRules));
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }
}

