/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.filter;

import com.zimbra.client.ZFilterCondition;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZTagLibException;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import com.zimbra.cs.taglib.tag.filter.FilterRuleTag;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.JspTag;

public class DateConditionTag
extends ZimbraSimpleTag {
    private ZFilterCondition.DateOp mOp;
    private String mValue;

    public void setValue(String value) {
        this.mValue = value;
    }

    public void setOp(String op) throws ServiceException {
        this.mOp = ZFilterCondition.DateOp.fromString((String)op);
    }

    public void doTag() throws JspException {
        try {
            FilterRuleTag rule = (FilterRuleTag)DateConditionTag.findAncestorWithClass((JspTag)this, FilterRuleTag.class);
            if (rule == null) {
                throw new JspTagException("The dateCondition tag must be used within a filterRule tag");
            }
            if (this.mValue == null || this.mValue.equals("")) {
                this.mValue = new SimpleDateFormat("yyyyMMdd").format(new Date());
            }
            rule.addCondition((ZFilterCondition)new ZFilterCondition.ZDateCondition(this.mOp, this.mValue));
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)((Object)ZTagLibException.INVALID_FILTER_DATE(e.getMessage(), e)));
        }
    }
}

