/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.conv;

import com.zimbra.client.ZMailbox;
import com.zimbra.client.ZSearchPagerResult;
import com.zimbra.client.ZSearchParams;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZSearchResultBean;
import com.zimbra.cs.taglib.tag.SearchContext;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import com.zimbra.soap.type.SearchSortBy;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class SearchConvTag
extends ZimbraSimpleTag {
    private static final int DEFAULT_CONV_SEARCH_LIMIT = 10;
    private String mVar;
    private String mId;
    private SearchContext mContext;
    private int mLimit = 10;
    private boolean mWanthtml;
    private boolean mWantHtmlSet;
    private boolean mMarkread;
    private ZMailbox.Fetch mFetch;
    private SearchSortBy mSortBy = SearchSortBy.dateDesc;
    private static final String QP_CONV_SEARCH_OFFSET = "cso";

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setContext(SearchContext context) {
        this.mContext = context;
    }

    public void setId(String id) {
        this.mId = id;
    }

    public void setFetch(String fetch) throws ServiceException {
        this.mFetch = ZMailbox.Fetch.fromString((String)fetch);
    }

    public void setMarkread(boolean markread) {
        this.mMarkread = markread;
    }

    public void setSort(String sortBy) throws ServiceException {
        if (sortBy != null && sortBy.length() > 0) {
            this.mSortBy = SearchSortBy.fromString((String)sortBy);
        }
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public void setWanthtml(boolean wanthtml) {
        this.mWanthtml = wanthtml;
        this.mWantHtmlSet = true;
    }

    private int getInt(ServletRequest req, String name, int def) {
        try {
            String value = req.getParameter(name);
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return def;
    }

    public void doTag() throws JspException, IOException {
        ZMailbox mailbox = this.getMailbox();
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest req = pageContext.getRequest();
        if (this.mId == null) {
            return;
        }
        try {
            ZSearchParams params = new ZSearchParams(this.mContext.getParams());
            params.setRecipientMode(false);
            params.setConvId(this.mId);
            params.setOffset(this.getInt(req, QP_CONV_SEARCH_OFFSET, 0));
            params.setLimit(this.mLimit);
            params.setFetch(this.mFetch);
            params.setPeferHtml(this.mWantHtmlSet ? this.mWanthtml : mailbox.getPrefs().getMessageViewHtmlPreferred());
            params.setMarkAsRead(this.mMarkread);
            params.setSortBy(this.mSortBy);
            int offset = params.getOffset();
            int requestedPage = offset / params.getLimit();
            params.setOffset(0);
            ZSearchPagerResult pager = mailbox.searchConversation(this.mId, params, requestedPage, true, false);
            if (pager.getActualPage() != pager.getRequestedPage()) {
                offset = pager.getActualPage() * params.getLimit();
            }
            params.setOffset(offset);
            ZSearchResultBean result = new ZSearchResultBean(pager.getResult(), params);
            pageContext.setAttribute(this.mVar, (Object)result, 2);
        }
        catch (ServiceException e) {
            throw new JspTagException("search failed", (Throwable)e);
        }
    }
}

