/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.contact;

import com.zimbra.client.ZAutoCompleteMatch;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContactAutoCompleteTag
extends ZimbraSimpleTag {
    private String mVar;
    private String mQuery;
    private int mLimit;
    private boolean mJSON;

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setQuery(String query) {
        this.mQuery = query.toLowerCase();
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public void setJson(boolean json) {
        this.mJSON = json;
    }

    public void doTag() throws JspException, IOException {
        JspContext jctxt = this.getJspContext();
        try {
            ZMailbox mbox = this.getMailbox();
            List matches = mbox.autoComplete(this.mQuery, this.mLimit);
            if (this.mJSON) {
                this.toJSON(jctxt.getOut(), matches);
            }
        }
        catch (JSONException e) {
            throw new JspTagException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    public void toJSON(JspWriter out, Collection<ZAutoCompleteMatch> matches) throws JSONException, IOException {
        JSONArray jsonArray = new JSONArray();
        for (ZAutoCompleteMatch match : matches) {
            jsonArray.put((Object)match.toZJSONObject().getJSONObject());
        }
        JSONObject top = new JSONObject();
        top.put("Result", (Object)jsonArray);
        top.write((Writer)out);
    }
}

