/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.calendar;

import com.zimbra.client.ZDateTime;
import com.zimbra.client.ZInvite;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZMessageBean;
import com.zimbra.cs.taglib.bean.ZMessageComposeBean;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class SaveAppointmentTag
extends ZimbraSimpleTag {
    private String mVar;
    private ZMessageComposeBean mCompose;
    private ZMessageBean mMessage;

    public void setCompose(ZMessageComposeBean compose) {
        this.mCompose = compose;
    }

    public void setMessage(ZMessageBean message) {
        this.mMessage = message;
    }

    public void setVar(String var) {
        this.mVar = var;
    }

    public void doTag() throws JspException, IOException {
        JspContext jctxt = this.getJspContext();
        PageContext pc = (PageContext)jctxt;
        try {
            ZMailbox.ZAppointmentResult response;
            String compNum;
            ZMailbox mbox = this.getMailbox();
            String folderId = this.mCompose.getApptFolderId();
            ZInvite inv = this.mCompose.toInviteObject(mbox, this.mMessage, folderId);
            ZInvite previousInv = this.mMessage != null ? this.mMessage.getInvite() : null;
            ZInvite.ZComponent prevComp = previousInv != null ? previousInv.getComponent() : null;
            String string = compNum = prevComp != null ? prevComp.getComponentNumber() : "0";
            if (inv.getComponent().getAttendees().size() > 0) {
                String key = this.mMessage != null ? (this.mCompose.getUseInstance() ? "apptInstanceModified" : "apptModified") : "apptNew";
                this.mCompose.setInviteBlurb(mbox, pc, inv, previousInv, key);
            }
            ZDateTime exceptionId = prevComp != null && prevComp.isException() ? prevComp.getStart() : null;
            ZMailbox.ZOutgoingMessage m = this.mCompose.toOutgoingMessage(mbox);
            if (folderId == null || folderId.length() == 0) {
                folderId = "10";
            }
            if (this.mMessage != null) {
                if (this.mCompose.getUseInstance()) {
                    if (this.mCompose.getExceptionInviteId() != null && this.mCompose.getExceptionInviteId().length() > 0) {
                        response = mbox.modifyAppointment(this.mCompose.getExceptionInviteId(), compNum, exceptionId, m, inv);
                    } else {
                        exceptionId = new ZDateTime(this.mCompose.getInstanceStartTime(), this.mCompose.getAllDay(), mbox.getPrefs().getTimeZone());
                        response = mbox.createAppointmentException(this.mCompose.getInviteId(), compNum, exceptionId, m, inv, null);
                    }
                } else {
                    response = mbox.modifyAppointment(this.mCompose.getInviteId(), compNum, exceptionId, m, inv);
                }
            } else {
                response = mbox.createAppointment(folderId, null, m, inv, null);
            }
            jctxt.setAttribute(this.mVar, (Object)response, 1);
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
    }
}

