/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.calendar;

import com.zimbra.client.ZAppointmentHit;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZApptSummariesBean;
import com.zimbra.cs.taglib.bean.ZMailboxBean;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;

public class GetAppointmentSummariesTag
extends ZimbraSimpleTag {
    private String mVar;
    private String mVarException;
    private String mQuery;
    private long mStart;
    private long mEnd;
    private String mFolderId;
    private TimeZone mTimeZone = TimeZone.getDefault();
    private ZMailboxBean mMailbox;

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setVarexception(String varException) {
        this.mVarException = varException;
    }

    public void setQuery(String query) {
        this.mQuery = query;
    }

    public void setStart(long start) {
        this.mStart = start;
    }

    public void setEnd(long end) {
        this.mEnd = end;
    }

    public void setFolderid(String folderId) {
        this.mFolderId = folderId;
    }

    public void setTimezone(TimeZone timeZone) {
        this.mTimeZone = timeZone;
    }

    public void setBox(ZMailboxBean mailbox) {
        this.mMailbox = mailbox;
    }

    public void doTag() throws JspException, IOException {
        JspContext jctxt = this.getJspContext();
        try {
            List<Object> appts;
            ZMailbox mbox;
            ZMailbox zMailbox = mbox = this.mMailbox != null ? this.mMailbox.getMailbox() : this.getMailbox();
            if (this.mFolderId == null || this.mFolderId.length() == 0) {
                appts = new ArrayList<ZAppointmentHit>();
            } else if (this.mFolderId.indexOf(44) == -1) {
                List result = mbox.getApptSummaries(this.mQuery, this.mStart, this.mEnd, new String[]{this.mFolderId}, this.mTimeZone, "appointment");
                if (result.size() != 1) {
                    appts = new ArrayList();
                    for (ZMailbox.ZApptSummaryResult r : result) {
                        appts.addAll(r.getAppointments());
                    }
                } else {
                    ZMailbox.ZApptSummaryResult asr = (ZMailbox.ZApptSummaryResult)result.get(0);
                    appts = asr.getAppointments();
                }
            } else {
                appts = new ArrayList();
                List result = mbox.getApptSummaries(this.mQuery, this.mStart, this.mEnd, this.mFolderId.split(","), this.mTimeZone, "appointment");
                for (ZMailbox.ZApptSummaryResult sum : result) {
                    appts.addAll(sum.getAppointments());
                }
            }
            jctxt.setAttribute(this.mVar, (Object)new ZApptSummariesBean(appts), 1);
        }
        catch (ServiceException e) {
            if (this.mVarException != null) {
                jctxt.setAttribute(this.mVarException, (Object)e, 1);
                jctxt.setAttribute(this.mVar, (Object)new ZApptSummariesBean(new ArrayList<ZAppointmentHit>()), 1);
            }
            throw new JspTagException((Throwable)e);
        }
    }
}

