/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.calendar;

import com.zimbra.client.ZDateTime;
import com.zimbra.client.ZInvite;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZMessageBean;
import com.zimbra.cs.taglib.bean.ZMessageComposeBean;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class CancelAppointmentTag
extends ZimbraSimpleTag {
    private ZMessageComposeBean mCompose;
    private ZMessageBean mMessage;
    private long mInstance;

    public void setCompose(ZMessageComposeBean compose) {
        this.mCompose = compose;
    }

    public void setMessage(ZMessageBean message) {
        this.mMessage = message;
    }

    public void setInstance(long instance) {
        this.mInstance = instance;
    }

    public void doTag() throws JspException, IOException {
        JspContext jctxt = this.getJspContext();
        PageContext pc = (PageContext)jctxt;
        try {
            ZMailbox mbox = this.getMailbox();
            if (this.mCompose != null) {
                this.cancelAppt(mbox, pc, this.mCompose, this.mMessage);
            } else {
                this.cancelAppt(mbox, this.mMessage, this.mInstance);
            }
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
    }

    private void cancelAppt(ZMailbox mbox, ZMessageBean message, long instance) throws ServiceException {
        ZInvite inv = message.getInvite();
        ZInvite.ZComponent comp = inv.getComponent();
        ZDateTime exceptionId = instance == 0L ? null : new ZDateTime(instance, comp.isAllDay(), mbox.getPrefs().getTimeZone());
        ZMailbox.ZOutgoingMessage m = new ZMailbox.ZOutgoingMessage();
        m.setMessagePart(new ZMailbox.ZOutgoingMessage.MessagePart("text/plain", ""));
        mbox.cancelAppointment(message.getId(), "0", null, exceptionId, null, m);
    }

    private void cancelAppt(ZMailbox mbox, PageContext pc, ZMessageComposeBean compose, ZMessageBean message) throws ServiceException {
        ZMailbox.ZOutgoingMessage m;
        ZInvite.ZComponent prevComp;
        ZInvite inv = compose.toInvite(mbox, message);
        boolean hasAttendeees = inv.getComponent().getAttendees().size() > 0;
        ZInvite previousInv = message != null ? message.getInvite() : null;
        ZInvite.ZComponent zComponent = prevComp = previousInv != null ? previousInv.getComponent() : null;
        if (hasAttendeees) {
            String key = compose.getUseInstance() ? "apptInstanceCancelled" : "apptCancelled";
            compose.setInviteBlurb(mbox, pc, inv, previousInv, key);
        }
        ZDateTime exceptionId = prevComp != null && prevComp.isException() ? prevComp.getStart() : null;
        ZMailbox.ZOutgoingMessage zOutgoingMessage = m = hasAttendeees ? compose.toOutgoingMessage(mbox) : null;
        if (compose.getUseInstance()) {
            if (compose.getExceptionInviteId() != null && compose.getExceptionInviteId().length() > 0) {
                mbox.cancelAppointment(compose.getExceptionInviteId(), "0", null, exceptionId, null, m);
            } else {
                exceptionId = new ZDateTime(compose.getInstanceStartTime(), compose.getAllDay(), mbox.getPrefs().getTimeZone());
                mbox.cancelAppointment(compose.getInviteId(), "0", null, exceptionId, null, m);
            }
        } else {
            mbox.cancelAppointment(compose.getInviteId(), "0", null, exceptionId, null, m);
        }
    }
}

