/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.calendar;

import com.zimbra.client.ZAppointmentHit;
import com.zimbra.cs.taglib.bean.BeanUtils;
import com.zimbra.cs.taglib.bean.ZApptAllDayLayoutBean;
import com.zimbra.cs.taglib.bean.ZApptCellLayoutBean;
import com.zimbra.cs.taglib.bean.ZApptDayLayoutBean;
import com.zimbra.cs.taglib.bean.ZApptMultiDayLayoutBean;
import com.zimbra.cs.taglib.bean.ZApptRowLayoutBean;
import com.zimbra.cs.taglib.bean.ZApptSummariesBean;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;

public class ApptMultiDayLayoutTag
extends ZimbraSimpleTag {
    private int DEFAULT_HOUR_START = 8;
    private int DEFAULT_HOUR_END = 18;
    private int DEFAULT_MIN_START = 0;
    private int DEFAULT_MIN_END = 0;
    private static final long MSECS_PER_MINUTE = 60000L;
    private static final long MSECS_PER_HOUR = 3600000L;
    private static final long MSECS_PER_DAY = 86400000L;
    private static final long MSECS_INCR = 900000L;
    private String mVar;
    private TimeZone mTimeZone;
    private long mStart = -1L;
    private long mEnd = -1L;
    private int mNumDays = 1;
    private String mWDays;
    private long mWeekStart;
    private long mHourStart = this.DEFAULT_HOUR_START;
    private long mHourEnd = this.DEFAULT_HOUR_END;
    private long mMinStart = this.DEFAULT_MIN_START;
    private long mMinEnd = this.DEFAULT_MIN_END;
    private ZApptSummariesBean mAppointments;
    private long mMsecsDayStart;
    private long mMsecsDayEnd;
    private String mSchedule;
    boolean mScheduleMode;
    boolean mIsPrint;
    boolean mIsShowDeclined;
    private List<Boolean> workDays;

    public void setSchedule(String schedule) {
        this.mSchedule = schedule;
    }

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setStart(long start) {
        this.mStart = start;
    }

    public void setDays(int numDays) {
        this.mNumDays = numDays;
    }

    public void setWdays(String wDays) {
        this.mWDays = wDays;
    }

    public void setWeekStart(long firstDay) {
        this.mWeekStart = firstDay;
    }

    public void setHourstart(long start) {
        this.mHourStart = start;
    }

    public void setHourend(long end) {
        this.mHourEnd = end;
    }

    public void setMinstart(long minstart) {
        this.mMinStart = minstart;
    }

    public void setMinend(long minend) {
        this.mMinEnd = minend;
    }

    public void setAppointments(ZApptSummariesBean appts) {
        this.mAppointments = appts;
    }

    public void setTimezone(TimeZone timeZone) {
        this.mTimeZone = timeZone;
    }

    public void setIsprint(boolean isprint) {
        this.mIsPrint = isprint;
    }

    public void setIsShowDeclined(boolean isShowDeclined) {
        this.mIsShowDeclined = isShowDeclined;
    }

    public void doTag() throws JspException, IOException {
        String[] inpWdays;
        JspContext jctxt = this.getJspContext();
        this.workDays = new ArrayList<Boolean>();
        for (int i = 0; i < 7; ++i) {
            this.workDays.add(false);
        }
        for (String day : inpWdays = this.mWDays.split(",")) {
            this.workDays.remove(Integer.parseInt(day));
            this.workDays.add(Integer.parseInt(day), true);
        }
        ArrayList<ZApptDayLayoutBean> days = new ArrayList<ZApptDayLayoutBean>();
        boolean bl = this.mScheduleMode = this.mSchedule != null && this.mSchedule.length() > 0;
        if (this.mScheduleMode) {
            String[] folders = this.mSchedule.split(",");
            this.mNumDays = folders.length;
            Calendar startCal = Calendar.getInstance(this.mTimeZone);
            startCal.setTimeInMillis(this.mStart);
            this.mEnd = BeanUtils.addDay(startCal, 1).getTimeInMillis();
            for (int i = 0; i < folders.length; ++i) {
                days.add(new ZApptDayLayoutBean(this.mAppointments.getAppointments(), startCal, i, this.mNumDays, folders[i], 900000L, this.mIsShowDeclined));
            }
        } else {
            Calendar startCal = Calendar.getInstance(this.mTimeZone);
            startCal.setTimeInMillis(this.mStart);
            this.mEnd = BeanUtils.addDay(startCal, this.mNumDays).getTimeInMillis();
            for (int i = 0; i < this.mNumDays; ++i) {
                days.add(new ZApptDayLayoutBean(this.mAppointments.getAppointments(), startCal, i, this.mNumDays, null, 900000L, this.mIsShowDeclined));
                BeanUtils.getNextDay(startCal);
            }
        }
        this.computeDayStartEnd(days);
        List<ZApptRowLayoutBean> rows = this.computeRows(days);
        List<ZApptRowLayoutBean> allDayRows = this.computeAllDayRows(days);
        List<List<ZApptRowLayoutBean>> rowsSeperatedByDays = this.computeRowsSeperatedByDays(days);
        List<List<ZApptRowLayoutBean>> allDayRowsSeperatedByDays = this.computeAllDayRowsSeperatedByDays(days);
        jctxt.setAttribute(this.mVar, (Object)new ZApptMultiDayLayoutBean(days, allDayRows, rows, rowsSeperatedByDays, allDayRowsSeperatedByDays), 1);
    }

    private List<ZApptRowLayoutBean> computeAllDayRows(List<ZApptDayLayoutBean> days) {
        double percentPerDay;
        ZApptAllDayLayoutBean allday = new ZApptAllDayLayoutBean(this.mAppointments.getAppointments(), this.mStart, this.mEnd, this.mNumDays, this.mScheduleMode, this.mIsShowDeclined);
        if (this.mScheduleMode) {
            String[] folders = this.mSchedule.split(",");
            percentPerDay = 100.0 / (double)folders.length;
        } else {
            percentPerDay = 100.0 / (double)this.mWDays.split(",").length;
        }
        ArrayList<ZApptRowLayoutBean> allDayRows = new ArrayList<ZApptRowLayoutBean>();
        int rowNum = 0;
        for (List<ZAppointmentHit> row : allday.getRows()) {
            ArrayList<ZApptCellLayoutBean> cells = new ArrayList<ZApptCellLayoutBean>();
            Boolean addCellsToRow = false;
            for (int dayIndex = 0; dayIndex < days.size(); ++dayIndex) {
                int daySpan;
                ZApptDayLayoutBean day = days.get(dayIndex);
                String folderId = day.getFolderId();
                if (!this.workDays.get((day.getDay() + (int)this.mWeekStart) % 7).booleanValue()) continue;
                ZAppointmentHit match = null;
                for (ZAppointmentHit appt : row) {
                    if (!appt.isInRange(day.getStartTime(), day.getEndTime()) || folderId != null && !folderId.equals(appt.getFolderId())) continue;
                    match = appt;
                    addCellsToRow = true;
                    break;
                }
                ZApptCellLayoutBean cell = new ZApptCellLayoutBean(day);
                if (match != null) {
                    cell.setAppt(match);
                    cell.setIsFirst(true);
                    cell.setRowSpan(1L);
                    daySpan = this.computeAllDayDaySpan(match, days, dayIndex + 1);
                    int colSpan = 0;
                    for (int d = 0; d < daySpan; ++d) {
                        colSpan += days.get(dayIndex + d).getMaxColumns();
                    }
                    cell.setColSpan(colSpan);
                } else {
                    cell.setRowSpan(1L);
                    cell.setColSpan(day.getMaxColumns());
                    daySpan = 1;
                }
                cell.setDaySpan(daySpan);
                cell.setWidth((int)(percentPerDay * (double)cell.getColSpan()));
                cells.add(cell);
                if (daySpan <= 1) continue;
                dayIndex += daySpan - 1;
            }
            if (!addCellsToRow.booleanValue()) continue;
            allDayRows.add(new ZApptRowLayoutBean(cells, rowNum++, this.mStart));
        }
        return allDayRows;
    }

    private List<ZApptRowLayoutBean> computeRows(List<ZApptDayLayoutBean> days) {
        double percentPerDay;
        ArrayList<ZApptRowLayoutBean> rows = new ArrayList<ZApptRowLayoutBean>();
        if (this.mScheduleMode) {
            String[] folders = this.mSchedule.split(",");
            percentPerDay = 100.0 / (double)folders.length;
        } else {
            percentPerDay = 100.0 / (double)this.mWDays.split(",").length;
        }
        for (ZApptDayLayoutBean day : days) {
            if (!this.workDays.get((day.getDay() + (int)this.mWeekStart) % 7).booleanValue()) continue;
            int numCols = day.getColumns().size();
            double percentPerCol = percentPerDay / (double)numCols;
            HashMap<ZAppointmentHit, ZApptCellLayoutBean> mDoneAppts = new HashMap<ZAppointmentHit, ZApptCellLayoutBean>();
            int rowNum = 0;
            long lastRange = day.getStartTime() + this.mMsecsDayEnd;
            for (long msecsRangeStart = day.getStartTime() + this.mMsecsDayStart; msecsRangeStart < lastRange; msecsRangeStart += 900000L) {
                long msecsRangeEnd = msecsRangeStart + 900000L;
                ArrayList<ZApptCellLayoutBean> cells = rowNum < rows.size() ? ((ZApptRowLayoutBean)rows.get(rowNum)).getCells() : new ArrayList<ZApptCellLayoutBean>();
                for (int colIndex = 0; colIndex < numCols; ++colIndex) {
                    List<ZAppointmentHit> rawColumn = day.getColumns().get(colIndex);
                    ZAppointmentHit match = null;
                    for (ZAppointmentHit a : rawColumn) {
                        if (!a.isInRange(msecsRangeStart, msecsRangeEnd)) continue;
                        match = a;
                        break;
                    }
                    ZApptCellLayoutBean cell = new ZApptCellLayoutBean(day);
                    if (match != null) {
                        cell.setAppt(match);
                        ZApptCellLayoutBean existingCol = (ZApptCellLayoutBean)mDoneAppts.get(match);
                        if (existingCol == null) {
                            cell.setIsFirst(true);
                            mDoneAppts.put(match, cell);
                            cell.setRowSpan(this.computeRowSpan(match, 900000L, day.getStartTime() + this.mMsecsDayStart, day.getStartTime() + this.mMsecsDayEnd));
                            cell.setColSpan(this.computeColSpan(match.getStartTime(), match.getEndTime(), day.getColumns(), colIndex + 1, 900000L));
                        } else {
                            cell.setColSpan(existingCol.getColSpan());
                        }
                    } else {
                        cell.setRowSpan(1L);
                        cell.setColSpan(this.computeColSpan(msecsRangeStart, msecsRangeEnd, day.getColumns(), colIndex + 1, 900000L));
                    }
                    cell.setWidth((int)(percentPerCol * (double)cell.getColSpan()));
                    cells.add(cell);
                    if (cell.getColSpan() <= 1L) continue;
                    colIndex = (int)((long)colIndex + (cell.getColSpan() - 1L));
                }
                if (rowNum >= rows.size()) {
                    rows.add(new ZApptRowLayoutBean(cells, rowNum, msecsRangeStart));
                }
                ++rowNum;
            }
        }
        return rows;
    }

    private List<List<ZApptRowLayoutBean>> computeAllDayRowsSeperatedByDays(List<ZApptDayLayoutBean> days) {
        ZApptAllDayLayoutBean allday = new ZApptAllDayLayoutBean(this.mAppointments.getAppointments(), this.mStart, this.mEnd, this.mNumDays, this.mScheduleMode, this.mIsShowDeclined);
        double percentPerDay = 100.0;
        ArrayList<List<ZApptRowLayoutBean>> allDayRowsofRows = new ArrayList<List<ZApptRowLayoutBean>>();
        for (int dayIndex = 0; dayIndex < days.size(); ++dayIndex) {
            int rowNum = 0;
            ArrayList<ZApptRowLayoutBean> allDayRows = new ArrayList<ZApptRowLayoutBean>();
            ArrayList<ZApptCellLayoutBean> cells = new ArrayList<ZApptCellLayoutBean>();
            ZApptDayLayoutBean day = days.get(dayIndex);
            String folderId = day.getFolderId();
            for (List<ZAppointmentHit> row : allday.getRows()) {
                ZAppointmentHit match = null;
                for (ZAppointmentHit appt : row) {
                    if (!appt.isInRange(day.getStartTime(), day.getEndTime()) || folderId != null && !folderId.equals(appt.getFolderId())) continue;
                    match = appt;
                    break;
                }
                ZApptCellLayoutBean cell = new ZApptCellLayoutBean(day);
                int daySpan = 1;
                if (match != null) {
                    cell.setAppt(match);
                    cell.setIsFirst(true);
                    cell.setRowSpan(1L);
                    daySpan = this.computeAllDayDaySpan(match, days, dayIndex + 1);
                    int colSpan = 0;
                    for (int d = 0; d < daySpan; ++d) {
                        colSpan += days.get(dayIndex + d).getMaxColumns();
                    }
                    cell.setColSpan(colSpan);
                    cell.setDaySpan(daySpan);
                    cell.setWidth((int)(percentPerDay * (double)cell.getColSpan()));
                    cells.add(cell);
                }
                if (daySpan <= true) continue;
                dayIndex += daySpan - 1;
            }
            allDayRows.add(new ZApptRowLayoutBean(cells, rowNum++, this.mStart));
            allDayRowsofRows.add(allDayRows);
        }
        return allDayRowsofRows;
    }

    private List<List<ZApptRowLayoutBean>> computeRowsSeperatedByDays(List<ZApptDayLayoutBean> days) {
        ArrayList<List<ZApptRowLayoutBean>> rowsForAllDays = new ArrayList<List<ZApptRowLayoutBean>>();
        double percentPerDay = 100.0;
        for (ZApptDayLayoutBean day : days) {
            ArrayList<ZApptRowLayoutBean> rowsForOneDay = new ArrayList<ZApptRowLayoutBean>();
            int numCols = day.getColumns().size();
            double percentPerCol = percentPerDay / (double)numCols;
            HashMap<ZAppointmentHit, ZApptCellLayoutBean> mDoneAppts = new HashMap<ZAppointmentHit, ZApptCellLayoutBean>();
            int rowNum = 0;
            long lastRange = day.getStartTime() + this.mMsecsDayEnd;
            for (long msecsRangeStart = day.getStartTime() + this.mMsecsDayStart; msecsRangeStart < lastRange; msecsRangeStart += 900000L) {
                long msecsRangeEnd = msecsRangeStart + 900000L;
                ArrayList<ZApptCellLayoutBean> cells = rowNum < rowsForOneDay.size() ? ((ZApptRowLayoutBean)rowsForOneDay.get(rowNum)).getCells() : new ArrayList<ZApptCellLayoutBean>();
                for (int colIndex = 0; colIndex < numCols; ++colIndex) {
                    List<ZAppointmentHit> rawColumn = day.getColumns().get(colIndex);
                    ZAppointmentHit match = null;
                    for (ZAppointmentHit a : rawColumn) {
                        if (!a.isInRange(msecsRangeStart, msecsRangeEnd)) continue;
                        match = a;
                        break;
                    }
                    ZApptCellLayoutBean cell = new ZApptCellLayoutBean(day);
                    if (match != null) {
                        cell.setAppt(match);
                        ZApptCellLayoutBean existingCol = (ZApptCellLayoutBean)mDoneAppts.get(match);
                        if (existingCol == null) {
                            cell.setIsFirst(true);
                            mDoneAppts.put(match, cell);
                            cell.setRowSpan(this.computeRowSpan(match, 900000L, day.getStartTime() + this.mMsecsDayStart, day.getStartTime() + this.mMsecsDayEnd));
                            cell.setColSpan(this.computeColSpan(match.getStartTime(), match.getEndTime(), day.getColumns(), colIndex + 1, 900000L));
                        } else {
                            cell.setColSpan(existingCol.getColSpan());
                        }
                    } else {
                        cell.setRowSpan(1L);
                        cell.setColSpan(this.computeColSpan(msecsRangeStart, msecsRangeEnd, day.getColumns(), colIndex + 1, 900000L));
                    }
                    cell.setWidth((int)(percentPerCol * (double)cell.getColSpan()));
                    cells.add(cell);
                    if (cell.getColSpan() <= 1L) continue;
                    colIndex = (int)((long)colIndex + (cell.getColSpan() - 1L));
                }
                if (rowNum >= rowsForOneDay.size()) {
                    rowsForOneDay.add(new ZApptRowLayoutBean(cells, rowNum, msecsRangeStart));
                }
                ++rowNum;
            }
            rowsForAllDays.add(rowsForOneDay);
        }
        return rowsForAllDays;
    }

    private void computeDayStartEnd(List<ZApptDayLayoutBean> days) {
        long hourStart = this.mHourStart == -1L || this.mHourStart > this.mHourEnd ? (long)this.DEFAULT_HOUR_START : this.mHourStart;
        long hourEnd = this.mHourEnd == -1L || this.mHourEnd < hourStart ? (long)this.DEFAULT_HOUR_END : this.mHourEnd;
        long minStart = this.mMinStart == -1L || this.mMinStart > this.mMinEnd ? (long)this.DEFAULT_MIN_START : this.mMinStart;
        long minEnd = this.mMinEnd == -1L || this.mMinEnd < minStart ? (long)this.DEFAULT_MIN_END : this.mMinEnd;
        this.mMsecsDayStart = 3600000L * hourStart + 60000L * minStart;
        this.mMsecsDayEnd = 3600000L * hourEnd + 60000L * minEnd;
        if (!this.mIsPrint) {
            for (ZApptDayLayoutBean day : days) {
                if (day.getEarliestAppt() != null) {
                    long start = day.getEarliestAppt().getStartTime();
                    if (start < day.getStartTime()) {
                        this.mMsecsDayStart = 0L;
                    } else if ((start = (start - day.getStartTime()) / 3600000L * 3600000L) < this.mMsecsDayStart) {
                        this.mMsecsDayStart = start;
                    }
                }
                if (day.getLatestAppt() == null) continue;
                long end = day.getLatestAppt().getEndTime();
                if (end > day.getEndTime()) {
                    this.mMsecsDayEnd = day.getEndTime() - day.getStartTime();
                    continue;
                }
                if ((end = (end - day.getStartTime() + 3600000L - 1L) / 3600000L * 3600000L) <= this.mMsecsDayEnd) continue;
                this.mMsecsDayEnd = end;
            }
        }
        if (this.mMsecsDayStart < 0L) {
            this.mMsecsDayStart = 0L;
        }
    }

    private int computeAllDayDaySpan(ZAppointmentHit match, List<ZApptDayLayoutBean> days, int dayIndex) {
        int daySpan = 1;
        while (dayIndex < days.size() && !this.mScheduleMode) {
            ZApptDayLayoutBean day = days.get(dayIndex);
            if (!match.isOverLapping(day.getStartTime(), day.getEndTime())) {
                return daySpan;
            }
            ++daySpan;
            ++dayIndex;
        }
        return daySpan;
    }

    private long computeColSpan(long start, long end, List<List<ZAppointmentHit>> columns, int colIndex, long msecsIncr) {
        int i;
        for (i = colIndex; i < columns.size(); ++i) {
            for (ZAppointmentHit appt : columns.get(i)) {
                if (!ZAppointmentHit.isOverLapping((long)start, (long)end, (long)appt.getStartTime(), (long)appt.getEndTime(), (long)msecsIncr)) continue;
                return i - colIndex + 1;
            }
        }
        return i - colIndex + 1;
    }

    private long computeRowSpan(ZAppointmentHit match, long msecsIncr, long msecsStart, long msecsEnd) {
        long rowspan;
        if (msecsStart < match.getStartTime()) {
            msecsStart = match.getStartTime();
        }
        if (msecsEnd > match.getEndTime()) {
            msecsEnd = match.getEndTime();
        }
        return (rowspan = ((msecsEnd = (msecsEnd + msecsIncr - 1L) / msecsIncr * msecsIncr) - (msecsStart = msecsStart / msecsIncr * msecsIncr)) / msecsIncr) == 0L ? 1L : rowspan;
    }
}

