/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.briefcase;

import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZMessageBean;
import com.zimbra.cs.taglib.bean.ZMessageComposeBean;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;

public class SaveBriefcaseTag
extends ZimbraSimpleTag {
    private String mVar;
    private ZMessageComposeBean mCompose;
    private ZMessageBean mMessage;
    private String mFolderId;

    public void setCompose(ZMessageComposeBean compose) {
        this.mCompose = compose;
    }

    public void setMessage(ZMessageBean message) {
        this.mMessage = message;
    }

    public void setFolderId(String folderId) {
        this.mFolderId = folderId;
    }

    public void setVar(String var) {
        this.mVar = var;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTag() throws JspException, IOException {
        block12: {
            JspContext jctxt = this.getJspContext();
            PageContext pc = (PageContext)jctxt;
            try {
                ZMailbox mbox = this.getMailbox();
                if (this.mCompose == null || !this.mCompose.getHasFileItems()) break block12;
                List<FileItem> mFileItems = this.mCompose.getFileItems();
                int num = 0;
                for (FileItem item : mFileItems) {
                    if (item.getSize() <= 0L) continue;
                    ++num;
                }
                String[] briefIds = new String[num];
                int i = 0;
                try {
                    for (FileItem item : mFileItems) {
                        if (item.getSize() <= 0L) continue;
                        FilePart part = new FilePart(item.getFieldName(), (PartSource)new ZMessageComposeBean.UploadPartSource(item), item.getContentType(), "utf-8");
                        String attachmentUploadId = mbox.uploadAttachments(new Part[]{part}, 60000);
                        briefIds[i++] = mbox.createDocument(this.mFolderId, item.getName(), attachmentUploadId);
                    }
                }
                finally {
                    for (FileItem item : mFileItems) {
                        try {
                            item.delete();
                        }
                        catch (Exception exception) {}
                    }
                }
                jctxt.setAttribute(this.mVar, (Object)briefIds, 1);
            }
            catch (ServiceException e) {
                throw new JspTagException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

