/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.briefcase;

import com.zimbra.client.ZDocument;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZFolderBean;
import com.zimbra.cs.taglib.bean.ZMailboxBean;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class GetDocumentContentTag
extends ZimbraSimpleTag {
    private String mVar;
    private String mId;
    private String mCharset = "UTF-8";
    private ZMailboxBean mMailbox;

    public void setId(String id) {
        this.mId = id;
    }

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setCharset(String charset) {
        this.mCharset = charset;
    }

    public void setBox(ZMailboxBean mailbox) {
        this.mMailbox = mailbox;
    }

    public void doTag() throws JspException, IOException {
        JspContext jctxt = this.getJspContext();
        PageContext pc = (PageContext)jctxt;
        try {
            ZMailbox mbox = this.mMailbox != null ? this.mMailbox.getMailbox() : this.getMailbox();
            ZDocument doc = mbox.getDocument(this.mId);
            ZFolderBean fb = new ZFolderBean(mbox.getFolderById(doc.getFolderId()));
            if (fb != null) {
                int ch;
                InputStream is = mbox.getRESTResource(fb.getRootRelativePathURLEncoded() + "/" + URLEncoder.encode(doc.getName(), "UTF-8").replace("+", "%20") + "?fmt=native");
                InputStreamReader isr = new InputStreamReader(is, this.mCharset);
                StringBuffer buffer = new StringBuffer();
                BufferedReader in = new BufferedReader(isr);
                while ((ch = ((Reader)in).read()) > -1) {
                    buffer.append((char)ch);
                }
                isr.close();
                ((Reader)in).close();
                jctxt.setAttribute(this.mVar, (Object)buffer.toString().trim(), 1);
            }
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
    }
}

