/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag.briefcase;

import com.zimbra.client.ZFolder;
import com.zimbra.client.ZMailbox;
import com.zimbra.client.ZSearchContext;
import com.zimbra.client.ZSearchParams;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZFolderBean;
import com.zimbra.cs.taglib.bean.ZMailboxBean;
import com.zimbra.cs.taglib.bean.ZSearchResultBean;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.TimeZone;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;

public class GetBriefcaseTag
extends ZimbraSimpleTag {
    private String mVarSearch;
    private String mId;
    private String mVarFolder;
    private ZMailboxBean mMailbox;
    private TimeZone mTimeZone = TimeZone.getDefault();
    private String mRestTargetAccountId;

    public void setId(String id) {
        this.mId = id;
    }

    public void setVarSearch(String varSearch) {
        this.mVarSearch = varSearch;
    }

    public void setVarFolder(String varFolder) {
        this.mVarFolder = varFolder;
    }

    public void setBox(ZMailboxBean mailbox) {
        this.mMailbox = mailbox;
    }

    public void setTimezone(TimeZone timeZone) {
        this.mTimeZone = timeZone;
    }

    public void setResttargetaccountid(String targetId) {
        this.mRestTargetAccountId = targetId;
    }

    public void doTag() throws JspException, IOException {
        JspContext jctxt = this.getJspContext();
        try {
            ZMailbox mbox = this.mMailbox != null ? this.mMailbox.getMailbox() : this.getMailbox();
            ZFolder briefcaseFolder = mbox.getFolderById(this.mId);
            if (briefcaseFolder == null) {
                briefcaseFolder = mbox.getFolderById(this.mRestTargetAccountId + ":" + this.mId);
            }
            ZSearchParams params = new ZSearchParams("inid:\"" + briefcaseFolder.getId() + "\"");
            if (briefcaseFolder.getDefaultView() != null) {
                params.setTypes(briefcaseFolder.getDefaultView().name());
            }
            params.setTimeZone(this.mTimeZone);
            ZSearchContext searchCnt = new ZSearchContext(params, mbox);
            if (searchCnt.getResult() == null) {
                searchCnt.getNextHit();
            }
            jctxt.setAttribute(this.mVarSearch, (Object)new ZSearchResultBean(searchCnt.getResult(), searchCnt.getParams()), 1);
            jctxt.setAttribute(this.mVarFolder, (Object)new ZFolderBean(briefcaseFolder), 1);
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
    }
}

