/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.zimbra.client.ZMailbox;
import com.zimbra.client.ZSearchParams;
import com.zimbra.client.ZSearchResult;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZSearchResultBean;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import com.zimbra.soap.type.SearchSortBy;
import java.io.IOException;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public final class SearchTag
extends ZimbraSimpleTag {
    private static final AtomicLong ID_GEN = new AtomicLong(1L);
    private static final int DEFAULT_SEARCH_LIMIT = 25;
    private static final int CACHE_SIZE = 20;
    private static final String CACHE_ATTR = "SearchTag.cache";
    private String mVar;
    private long mSearchContext;
    private int mLimit = 25;
    private int mOffset;
    private String mConvId = null;
    private String mTypes = "conversation";
    private String mQuery = "in:inbox";
    private SearchSortBy mSortBy = SearchSortBy.dateDesc;
    private boolean mWanthtml;
    private boolean mWantHtmlSet;
    private boolean mMarkread;
    private long mStart;
    private long mEnd;
    private String mFolderId;
    private TimeZone mTimeZone;
    private ZMailbox.Fetch mFetch;
    private String mField = null;

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setTypes(String types) {
        this.mTypes = types;
    }

    public void setQuery(String query) {
        if (query == null || query.equals("")) {
            query = "in:inbox";
        }
        this.mQuery = query;
    }

    public void setSort(String sortBy) throws ServiceException {
        this.mSortBy = SearchSortBy.fromString((String)sortBy);
    }

    public void setConv(String convId) {
        this.mConvId = convId;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public void setOffset(int offset) {
        this.mOffset = offset;
    }

    public void setMarkread(boolean markread) {
        this.mMarkread = markread;
    }

    public void setField(String field) {
        this.mField = field;
    }

    public void setStart(long start) {
        this.mStart = start;
    }

    public void setEnd(long end) {
        this.mEnd = end;
    }

    public void setFolderid(String folderId) {
        this.mFolderId = folderId;
    }

    public void setTimezone(TimeZone timeZone) {
        this.mTimeZone = timeZone;
    }

    public void setWanthtml(boolean wanthtml) {
        this.mWanthtml = wanthtml;
        this.mWantHtmlSet = true;
    }

    public void setFetch(String fetch) throws ServiceException {
        this.mFetch = ZMailbox.Fetch.fromString((String)fetch);
    }

    public void setSearchContext(long context) {
        this.mSearchContext = context;
    }

    public void doTag() throws JspException, IOException {
        PageContext jctxt = (PageContext)this.getJspContext();
        try {
            ZSearchResult searchResults;
            ZMailbox mbox = this.getMailbox();
            if (this.mFolderId != null && this.mFolderId.length() > 0) {
                StringBuilder newQuery = new StringBuilder();
                newQuery.append("(");
                for (String fid : this.mFolderId.split(",")) {
                    if (newQuery.length() > 1) {
                        newQuery.append(" or ");
                    }
                    newQuery.append("inid:").append(fid);
                }
                newQuery.append(")");
                if (this.mQuery != null && this.mQuery.length() > 0) {
                    newQuery.append("AND (").append(this.mQuery).append(")");
                }
                this.mQuery = newQuery.toString();
            }
            ZSearchParams params = new ZSearchParams(this.mQuery);
            params.setOffset(this.mOffset);
            params.setLimit(this.mLimit);
            params.setSortBy(this.mSortBy);
            params.setTypes(this.mTypes);
            params.setFetch(this.mFetch);
            params.setPeferHtml(this.mWantHtmlSet ? this.mWanthtml : mbox.getPrefs().getMessageViewHtmlPreferred());
            params.setMarkAsRead(this.mMarkread);
            params.setField(this.mField);
            if (this.mStart != 0L) {
                params.setCalExpandInstStart(this.mStart);
            }
            if (this.mEnd != 0L) {
                params.setCalExpandInstEnd(this.mEnd);
            }
            if (this.mTimeZone != null) {
                params.setTimeZone(this.mTimeZone);
            }
            ZSearchResult zSearchResult = searchResults = this.mConvId == null ? mbox.search(params) : mbox.searchConversation(this.mConvId, params);
            if (this.mSearchContext != 0L) {
                SearchContext sc = (SearchContext)SearchTag.getSearchContextCache(jctxt).getIfPresent((Object)this.mSearchContext);
                if (sc == null) {
                    this.mSearchContext = 0L;
                } else {
                    sc.setSearchResult(searchResults);
                }
            }
            if (this.mOffset == 0 || this.mSearchContext == 0L) {
                this.mSearchContext = SearchTag.putSearchContext(jctxt, searchResults);
            }
            jctxt.setAttribute(this.mVar, (Object)new ZSearchResultBean(searchResults, params), 1);
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cache<Long, SearchContext> getSearchContextCache(PageContext ctxt) {
        HttpSession httpSession = ctxt.getSession();
        synchronized (httpSession) {
            Cache cache = (Cache)ctxt.getAttribute(CACHE_ATTR, 3);
            if (cache == null) {
                cache = CacheBuilder.newBuilder().maximumSize(20L).concurrencyLevel(1).build();
                ctxt.setAttribute(CACHE_ATTR, (Object)cache, 3);
            }
            return cache;
        }
    }

    private static long putSearchContext(PageContext ctxt, ZSearchResult result) {
        long id = ID_GEN.getAndIncrement();
        Cache<Long, SearchContext> cache = SearchTag.getSearchContextCache(ctxt);
        SearchContext sc = new SearchContext();
        sc.setSearchResult(result);
        cache.put((Object)id, (Object)sc);
        return id;
    }

    public static final class SearchContext {
        private ZSearchResult mResult;

        public ZSearchResult getSearchResult() {
            return this.mResult;
        }

        public void setSearchResult(ZSearchResult result) {
            this.mResult = result;
        }
    }
}

