/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.zimbra.client.ZMailbox;
import com.zimbra.client.ZPhoneAccount;
import com.zimbra.client.ZSearchPagerResult;
import com.zimbra.client.ZSearchParams;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZFolderBean;
import com.zimbra.cs.taglib.bean.ZPhoneAccountBean;
import com.zimbra.cs.taglib.bean.ZSearchHitBean;
import com.zimbra.cs.taglib.bean.ZSearchResultBean;
import com.zimbra.cs.taglib.bean.ZTagBean;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public final class SearchContext {
    private static final String CACHE_ATTR = "SearchContext.cache";
    private static final AtomicLong ID_GEN = new AtomicLong(1L);
    private static final int CACHE_SIZE = 10;
    private String mTitle;
    private String mBackTo;
    private String mShortBackTo;
    private String mSelectedId;
    private String mQuery;
    private String mSq;
    private String mSfi;
    private String mSti;
    private String mSt;
    private String mSs;
    private String mTypes;
    private ZFolderBean mFolderBean;
    private ZTagBean mTagBean;
    private ZPhoneAccountBean mPhoneAccount;
    private ZSearchParams mParams;
    private ZSearchResultBean mResult;
    private boolean mShowMatches;
    private int mItemIndex;
    private String mId;

    public String getSq() {
        return this.mSq;
    }

    public void setSq(String sq) {
        this.mSq = sq;
    }

    public String getSfi() {
        return this.mSfi;
    }

    public void setSfi(String sfi) {
        this.mSfi = sfi;
    }

    public String getSti() {
        return this.mSti;
    }

    public void setSti(String sti) {
        this.mSti = sti;
    }

    public String getSt() {
        return this.mSt;
    }

    public void setSt(String st) {
        this.mSt = st;
    }

    public String getSs() {
        return this.mSs;
    }

    public void setSs(String ss) {
        this.mSs = ss;
    }

    public ZFolderBean getFolder() {
        return this.mFolderBean;
    }

    public void setFolder(ZFolderBean folder) {
        this.mFolderBean = folder;
    }

    public String getTypes() {
        return this.mTypes;
    }

    public void setTypes(String types) {
        this.mTypes = types;
    }

    public boolean getIsConversationSearch() {
        return "conversation".equals(this.mTypes);
    }

    public boolean getIsMessageSearch() {
        return "message".equals(this.mTypes);
    }

    public boolean getIsContactSearch() {
        return "contact".equals(this.mTypes);
    }

    public boolean getIsGALSearch() {
        return "gal".equals(this.mTypes);
    }

    public boolean getIsTaskSearch() {
        return "task".equals(this.mTypes);
    }

    public boolean getIsBriefcaseSearch() {
        return "briefcase".equals(this.mTypes);
    }

    public boolean getIsWikiSearch() {
        return "wiki".equals(this.mTypes);
    }

    public boolean getIsVoiceMailSearch() {
        return "voicemail".equals(this.mTypes);
    }

    public boolean getIsCallSearch() {
        return "calllog".equals(this.mTypes);
    }

    public ZPhoneAccountBean getPhoneAccount() {
        return this.mPhoneAccount;
    }

    public void setPhoneAccount(ZPhoneAccount account) {
        this.mPhoneAccount = account == null ? null : new ZPhoneAccountBean(account);
    }

    public ZTagBean getTag() {
        return this.mTagBean;
    }

    public void setTag(ZTagBean tag) {
        this.mTagBean = tag;
    }

    public boolean getIsFolderSearch() {
        return this.mFolderBean != null && !this.mFolderBean.getIsSearchFolder();
    }

    public boolean getIsSearchFolderSearch() {
        return this.mFolderBean != null && this.mFolderBean.getIsSearchFolder();
    }

    public boolean getIsTagSearch() {
        return this.mTagBean != null;
    }

    public static SearchContext getSearchContext(PageContext ctxt, String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return null;
        }
        return (SearchContext)SearchContext.getSearchContextCache(ctxt).getIfPresent((Object)key);
    }

    public static SearchContext newSearchContext(PageContext ctxt) {
        SearchContext sc = new SearchContext(String.valueOf(ID_GEN.getAndIncrement()));
        SearchContext.getSearchContextCache(ctxt).put((Object)sc.getId(), (Object)sc);
        return sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cache<String, SearchContext> getSearchContextCache(PageContext ctxt) {
        HttpSession httpSession = ctxt.getSession();
        synchronized (httpSession) {
            Cache cache = (Cache)ctxt.getAttribute(CACHE_ATTR, 3);
            if (cache == null) {
                cache = CacheBuilder.newBuilder().maximumSize(10L).concurrencyLevel(1).build();
                ctxt.setAttribute(CACHE_ATTR, (Object)cache, 3);
            }
            return cache;
        }
    }

    private SearchContext(String id) {
        this.mId = id;
    }

    public String getId() {
        return this.mId;
    }

    public boolean getShowMatches() {
        return this.mShowMatches;
    }

    public void setShowMatches(boolean matches) {
        this.mShowMatches = matches;
    }

    public ZSearchResultBean getSearchResult() {
        return this.mResult;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public String getBackTo() {
        return this.mBackTo;
    }

    public void setBackTo(String backto) {
        this.mBackTo = backto;
    }

    public String getShortBackTo() {
        return this.mShortBackTo;
    }

    public void setShortBackTo(String backto) {
        this.mShortBackTo = backto;
    }

    public String getSelectedId() {
        return this.mSelectedId;
    }

    public void setSelectedId(String selectedId) {
        this.mSelectedId = selectedId;
    }

    public String getQuery() {
        return this.mQuery;
    }

    public void setQuery(String query) {
        this.mQuery = query;
    }

    public ZSearchParams getParams() {
        return this.mParams;
    }

    public void setParams(ZSearchParams params) {
        this.mParams = params;
    }

    public boolean getHasPrevItem() {
        return this.mResult.getOffset() > 0 || this.mItemIndex > 0;
    }

    public boolean getHasNextItem() {
        return this.mItemIndex < this.mResult.getHits().size() - 1 || this.mResult.getHasMore();
    }

    public ZSearchHitBean getCurrentItem() {
        if (this.mResult == null || this.mResult.getHits() == null) {
            return null;
        }
        int size = this.mResult.getHits().size();
        if (this.mItemIndex >= 0 && this.mItemIndex < size) {
            return this.mResult.getHits().get(this.mItemIndex);
        }
        return null;
    }

    public int getCurrentItemIndex() {
        return this.mItemIndex;
    }

    public void setCurrentItemIndex(int index) {
        if (index >= 0 && this.mResult != null && index < this.mResult.getHits().size()) {
            this.mItemIndex = index;
        }
    }

    public synchronized void doSearch(ZMailbox mailbox, boolean useCache, boolean useCursor) throws JspTagException {
        try {
            int offset = this.mParams.getOffset();
            int requestedPage = offset / this.mParams.getLimit();
            this.mParams.setOffset(0);
            ZSearchPagerResult pager = mailbox.search(this.mParams, requestedPage, useCache, useCursor);
            if (pager.getActualPage() != pager.getRequestedPage()) {
                offset = pager.getActualPage() * this.mParams.getLimit();
            }
            this.mParams.setOffset(offset);
            this.mResult = new ZSearchResultBean(pager.getResult(), this.mParams);
            this.mItemIndex = 0;
        }
        catch (ServiceException e) {
            throw new JspTagException("search failed", (Throwable)e);
        }
    }
}

