/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.client.ZEmailAddress;
import com.zimbra.client.ZMailbox;
import com.zimbra.client.ZMessage;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZMessageComposeBean;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;

public class SaveDraftTag
extends ZimbraSimpleTag {
    private String mVar;
    private String mTo;
    private String mReplyTo;
    private String mCc;
    private String mBcc;
    private String mFrom;
    private String mSubject;
    private String mContentType = "text/plain";
    private String mContent;
    private String mReplyType;
    private String mInReplyTo;
    private String mMessageId;
    private String mMessages;
    private String mAttachments;
    private String mAttachmentUploadId;
    private String mDraftId;
    private String mFolderId;
    private ZMessageComposeBean mCompose;

    public void setCompose(ZMessageComposeBean compose) {
        this.mCompose = compose;
    }

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setTo(String to) {
        this.mTo = to;
    }

    public void setReplyto(String replyTo) {
        this.mReplyTo = replyTo;
    }

    public void setReplytype(String replyType) {
        this.mReplyType = replyType;
    }

    public void setContent(String content) {
        this.mContent = content;
    }

    public void setContenttype(String contentType) {
        this.mContentType = contentType;
    }

    public void setSubject(String subject) {
        this.mSubject = subject;
    }

    public void setMessageid(String id) {
        this.mMessageId = id;
    }

    public void setInreplyto(String inReplyto) {
        this.mInReplyTo = inReplyto;
    }

    public void setFrom(String from) {
        this.mFrom = from;
    }

    public void setBcc(String bcc) {
        this.mBcc = bcc;
    }

    public void setCc(String cc) {
        this.mCc = cc;
    }

    public void setMessages(String messages) {
        this.mMessages = messages;
    }

    public void setAttachments(String attachments) {
        this.mAttachments = attachments;
    }

    public void setAttachmentuploadid(String id) {
        this.mAttachmentUploadId = id;
    }

    public void setDraftid(String draftId) {
        this.mDraftId = draftId;
    }

    public void setFolderid(String folderId) {
        this.mFolderId = folderId;
    }

    public void doTag() throws JspException, IOException {
        JspContext jctxt = this.getJspContext();
        try {
            ZMailbox mbox = this.getMailbox();
            ZMailbox.ZOutgoingMessage m = this.mCompose != null ? this.mCompose.toOutgoingMessage(mbox) : this.getOutgoingMessage();
            String folderId = this.mFolderId != null && this.mFolderId.length() > 0 ? this.mFolderId : null;
            String draftId = this.mDraftId != null && this.mDraftId.length() > 0 ? this.mDraftId : null;
            ZMessage response = mbox.saveDraft(m, draftId, folderId);
            jctxt.setAttribute(this.mVar, (Object)response, 1);
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
    }

    private ZMailbox.ZOutgoingMessage getOutgoingMessage() throws ServiceException {
        ArrayList<ZMailbox.ZOutgoingMessage.AttachedMessagePart> attachments;
        ArrayList<String> messages;
        ArrayList addrs = new ArrayList();
        if (this.mTo != null && this.mTo.length() > 0) {
            addrs.addAll(ZEmailAddress.parseAddresses((String)this.mTo, (String)"t"));
        }
        if (this.mReplyTo != null && this.mReplyTo.length() > 0) {
            addrs.addAll(ZEmailAddress.parseAddresses((String)this.mReplyTo, (String)"r"));
        }
        if (this.mCc != null && this.mCc.length() > 0) {
            addrs.addAll(ZEmailAddress.parseAddresses((String)this.mCc, (String)"c"));
        }
        if (this.mFrom != null && this.mFrom.length() > 0) {
            addrs.addAll(ZEmailAddress.parseAddresses((String)this.mFrom, (String)"f"));
        }
        if (this.mBcc != null && this.mBcc.length() > 0) {
            addrs.addAll(ZEmailAddress.parseAddresses((String)this.mBcc, (String)"b"));
        }
        if (this.mMessages != null && this.mMessages.length() > 0) {
            messages = new ArrayList<String>();
            for (String m : this.mMessages.split(",")) {
                messages.add(m);
            }
        } else {
            messages = null;
        }
        if (this.mAttachments != null && this.mAttachments.length() > 0) {
            attachments = new ArrayList<ZMailbox.ZOutgoingMessage.AttachedMessagePart>();
            for (String partName : this.mAttachments.split(",")) {
                attachments.add(new ZMailbox.ZOutgoingMessage.AttachedMessagePart(this.mMessageId, partName, null));
            }
        } else {
            attachments = null;
        }
        ZMailbox.ZOutgoingMessage m = new ZMailbox.ZOutgoingMessage();
        m.setAddresses(addrs);
        m.setSubject(this.mSubject);
        if (this.mInReplyTo != null && this.mInReplyTo.length() > 0) {
            m.setInReplyTo(this.mInReplyTo);
        }
        m.setMessagePart(new ZMailbox.ZOutgoingMessage.MessagePart(this.mContentType, this.mContent));
        m.setMessageIdsToAttach(messages);
        m.setMessagePartsToAttach(attachments);
        m.setAttachmentUploadId(this.mAttachmentUploadId);
        if (this.mMessageId != null && this.mMessageId.length() > 0) {
            m.setOriginalMessageId(this.mMessageId);
        }
        if (this.mReplyType != null && this.mReplyType.length() > 0) {
            m.setReplyType(this.mReplyType);
        }
        return m;
    }
}

