/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZMessageBean;
import com.zimbra.cs.taglib.bean.ZMessageComposeBean;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.Calendar;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class MessageComposeTag
extends ZimbraSimpleTag {
    public static final String ACTION_NEW = "new";
    public static final String ACTION_APPT_EDIT = "apptedit";
    public static final String ACTION_APPT_NEW = "apptnew";
    public static final String ACTION_REPLY = "reply";
    public static final String ACTION_REPLY_ALL = "replyAll";
    public static final String ACTION_FORWARD = "forward";
    public static final String ACTION_RESEND = "resend";
    public static final String ACTION_DRAFT = "draft";
    public static final String ACTION_ACCEPT = "accept";
    public static final String ACTION_DECLINE = "decline";
    public static final String ACTION_TENTATIVE = "tentative";
    private String mVar;
    private ZMessageBean mMessage;
    private String mAction;
    private Calendar mDate;
    private String mInviteId;
    private String mExceptionInviteId;
    private boolean mUseInstance;
    private long mInstanceStartTime;
    private long mInstanceDuration;
    private boolean mIstask;
    private boolean mIsmobile;

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setMessage(ZMessageBean message) {
        this.mMessage = message;
    }

    public void setAction(String action) {
        this.mAction = action;
    }

    public void setDate(Calendar date) {
        this.mDate = date;
    }

    public void setInviteId(String inviteId) {
        this.mInviteId = inviteId;
    }

    public void setExceptionInviteId(String exceptionInviteId) {
        this.mExceptionInviteId = exceptionInviteId;
    }

    public void setUseInstance(boolean useInstance) {
        this.mUseInstance = useInstance;
    }

    public void setIstask(boolean isTask) {
        this.mIstask = isTask;
    }

    public void setInstanceStartTime(long instanceStartTime) {
        this.mInstanceStartTime = instanceStartTime;
    }

    public void setInstanceDuration(long instanceDuration) {
        this.mInstanceDuration = instanceDuration;
    }

    public void setIsmobile(boolean isMobile) {
        this.mIsmobile = isMobile;
    }

    public void doTag() throws JspException, IOException {
        try {
            ZMessageComposeBean compose;
            JspContext jctxt = this.getJspContext();
            PageContext pc = (PageContext)jctxt;
            ZMailbox mailbox = this.getMailbox();
            if (ACTION_REPLY.equals(this.mAction)) {
                compose = new ZMessageComposeBean(ZMessageComposeBean.Action.REPLY, this.mMessage, mailbox, pc, null, this.mIsmobile);
            } else if (ACTION_REPLY_ALL.equals(this.mAction)) {
                compose = new ZMessageComposeBean(ZMessageComposeBean.Action.REPLY_ALL, this.mMessage, mailbox, pc, null, this.mIsmobile);
            } else if (ACTION_FORWARD.equals(this.mAction)) {
                compose = new ZMessageComposeBean(ZMessageComposeBean.Action.FORWARD, this.mMessage, mailbox, pc, null, this.mIsmobile);
            } else if (ACTION_RESEND.equals(this.mAction)) {
                compose = new ZMessageComposeBean(ZMessageComposeBean.Action.RESEND, this.mMessage, mailbox, pc, null, this.mIsmobile);
            } else if (ACTION_DRAFT.equals(this.mAction)) {
                compose = new ZMessageComposeBean(ZMessageComposeBean.Action.DRAFT, this.mMessage, mailbox, pc, null, this.mIsmobile);
            } else if (ACTION_ACCEPT.equals(this.mAction)) {
                compose = new ZMessageComposeBean(ZMessageComposeBean.Action.INVITE_ACCEPT, this.mMessage, mailbox, pc, null, this.mIsmobile);
            } else if (ACTION_DECLINE.equals(this.mAction)) {
                compose = new ZMessageComposeBean(ZMessageComposeBean.Action.INVITE_DECLINE, this.mMessage, mailbox, pc, null, this.mIsmobile);
            } else if (ACTION_TENTATIVE.equals(this.mAction)) {
                compose = new ZMessageComposeBean(ZMessageComposeBean.Action.INVITE_TENTATIVE, this.mMessage, mailbox, pc, null, this.mIsmobile);
            } else if (ACTION_APPT_NEW.equals(this.mAction)) {
                ZMessageComposeBean.AppointmentOptions options = new ZMessageComposeBean.AppointmentOptions();
                options.setDate(this.mDate);
                options.setIsTask(this.mIstask);
                compose = new ZMessageComposeBean(ZMessageComposeBean.Action.APPT_NEW, null, mailbox, pc, options, this.mIsmobile);
            } else if (ACTION_APPT_EDIT.equals(this.mAction)) {
                ZMessageComposeBean.AppointmentOptions options = new ZMessageComposeBean.AppointmentOptions();
                options.setDate(this.mDate);
                options.setInviteId(this.mInviteId);
                options.setExceptionInviteId(this.mExceptionInviteId);
                options.setUseInstance(this.mUseInstance);
                options.setInstanceStartTime(this.mInstanceStartTime);
                options.setInstanceDuration(this.mInstanceDuration);
                options.setIsTask(this.mIstask);
                compose = new ZMessageComposeBean(ZMessageComposeBean.Action.APPT_EDIT, this.mMessage, mailbox, pc, options, this.mIsmobile);
            } else {
                compose = new ZMessageComposeBean(ZMessageComposeBean.Action.NEW, null, mailbox, pc, null, this.mIsmobile);
            }
            jctxt.setAttribute(this.mVar, (Object)compose, 1);
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
    }
}

