/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.client.ZMailbox;
import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraCookie;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.ZimbraAuthToken;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.taglib.ZJspSession;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class LogoutTag
extends ZimbraSimpleTag {
    private boolean mIsAdmin = false;

    public void setIsAdmin(boolean isAdmin) {
        this.mIsAdmin = isAdmin;
    }

    public void doTag() throws JspException, IOException {
        JspContext jctxt = this.getJspContext();
        PageContext pageContext = (PageContext)jctxt;
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        ZAuthToken authToken = this.mIsAdmin ? new ZAuthToken(request, true) : ZJspSession.getAuthToken(pageContext);
        try {
            if (authToken != null && authToken.getValue() != null) {
                AuthToken at = ZimbraAuthToken.getAuthToken((String)authToken.getValue());
                Account acc = at.getAccount();
                if (at != null && acc != null) {
                    ZMailbox mbox = ZMailbox.getByAuthToken((ZAuthToken)authToken, (String)URLUtil.getSoapURL((Server)acc.getServer(), (boolean)false), (boolean)true, (boolean)true);
                    mbox.logout();
                }
            }
        }
        catch (ServiceException e) {
            if (!"service.AUTH_EXPIRED".equals(e.getCode())) {
                throw new JspTagException(e.getMessage(), (Throwable)e);
            }
        }
        catch (AuthTokenException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
        finally {
            HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
            if (this.mIsAdmin) {
                ZimbraCookie.clearCookie((HttpServletResponse)response, (String)"ZM_ADMIN_AUTH_TOKEN");
                ZimbraCookie.clearCookie((HttpServletResponse)response, (String)"JSESSIONID");
            } else {
                ZAuthToken.clearCookies((HttpServletResponse)response);
            }
            ZJspSession.clearSession(pageContext);
        }
    }
}

