/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.client.ZAuthResult;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.common.util.WebSplitUtil;
import com.zimbra.common.util.ZimbraCookie;
import com.zimbra.common.util.ngxlookup.NginxAuthServer;
import com.zimbra.cs.taglib.ZJspSession;
import com.zimbra.cs.taglib.ngxlookup.NginxRouteLookUpConnector;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class LoginTag
extends ZimbraSimpleTag {
    private String mUsername;
    private String mPassword;
    private String mNewPassword;
    private String mTwoFactorCode;
    private String mAuthToken;
    private boolean mAuthTokenInUrl;
    private boolean mRememberMe;
    private boolean mImportData;
    private boolean mAdminPreAuth;
    private String mUrl = null;
    private String mPath = null;
    private String mVarRedirectUrl = null;
    private String mVarAuthResult = null;
    private String mAttrs;
    private String mPrefs;
    private String mRequestedSkin;
    private boolean mCsrfTokenSecured;
    private boolean mTrustedDevice;
    private String mTrustedDeviceToken;
    private String mDeviceId;
    private boolean mGenerateDeviceId;

    public void setVarRedirectUrl(String varRedirectUrl) {
        this.mVarRedirectUrl = varRedirectUrl;
    }

    public void setVarAuthResult(String varAuthResult) {
        this.mVarAuthResult = varAuthResult;
    }

    public void setUsername(String username) {
        this.mUsername = username;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public void setTwoFactorCode(String code) {
        this.mTwoFactorCode = code;
    }

    public void setNewpassword(String password) {
        this.mNewPassword = password;
    }

    public void setRememberme(boolean rememberMe) {
        this.mRememberMe = rememberMe;
    }

    public void setImportData(boolean importData) {
        this.mImportData = importData;
    }

    public void setCsrfTokenSecured(boolean csrfTokenSecured) {
        this.mCsrfTokenSecured = csrfTokenSecured;
    }

    public void setAdminPreAuth(boolean isAdmin) {
        this.mAdminPreAuth = isAdmin;
    }

    public void setAuthtoken(String authToken) {
        this.mAuthToken = authToken;
    }

    public void setAuthtokenInUrl(boolean authTokenInUrl) {
        this.mAuthTokenInUrl = authTokenInUrl;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public void setPrefs(String prefs) {
        this.mPrefs = prefs;
    }

    public void setAttrs(String attrs) {
        this.mAttrs = attrs;
    }

    public void setRequestedSkin(String skin) {
        this.mRequestedSkin = skin;
    }

    public void setTrustedDevice(Boolean trusted) {
        this.mTrustedDevice = trusted;
    }

    public void setTrustedDeviceToken(String token) {
        this.mTrustedDeviceToken = token;
    }

    public void setGenerateDeviceId(Boolean generateId) {
        this.mGenerateDeviceId = generateId;
    }

    public void setDeviceId(String deviceId) {
        this.mDeviceId = deviceId;
    }

    private String getVirtualHost(HttpServletRequest request) {
        return HttpUtil.getVirtualHost((HttpServletRequest)request);
    }

    public void doTag() throws JspException, IOException {
        JspContext jctxt = this.getJspContext();
        try {
            ZAuthResult authResult;
            boolean needRefer;
            PageContext pageContext = (PageContext)jctxt;
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            String serverName = request.getServerName();
            ZMailbox.Options options = new ZMailbox.Options();
            options.setClientIp(ZJspSession.getRemoteAddr(pageContext));
            options.setNoSession(true);
            if (this.mPrefs != null && this.mPrefs.length() > 0) {
                options.setPrefs(Arrays.asList(this.mPrefs.split(",")));
            }
            if (this.mAttrs != null && this.mAttrs.length() > 0) {
                options.setAttrs(Arrays.asList(this.mAttrs.split(",")));
            }
            if (this.mTwoFactorCode != null && this.mTwoFactorCode.length() > 0) {
                options.setTwoFactorCode(this.mTwoFactorCode);
            }
            if (this.mAuthToken != null) {
                options.setAuthToken(this.mAuthToken);
                options.setAuthAuthToken(true);
            } else {
                options.setAccount(this.mUsername);
                options.setPassword(this.mPassword);
                options.setVirtualHost(this.getVirtualHost(request));
                if (this.mNewPassword != null && this.mNewPassword.length() > 0) {
                    options.setNewPassword(this.mNewPassword);
                }
            }
            if (this.mUrl == null) {
                if (this.mAuthToken == null && WebSplitUtil.isZimbraWebClientSplitEnabled()) {
                    String protocol = ZJspSession.isProtocolModeHttps() ? "httpssl" : "http";
                    NginxAuthServer nginxLookUpServer = NginxRouteLookUpConnector.getClient().getRouteforAccount(this.mUsername, "username", protocol, HttpUtil.getVirtualHost((HttpServletRequest)request), request.getRemoteAddr(), request.getHeader("Virtual-Host"));
                    protocol = ZJspSession.isProtocolModeHttps() ? "https" : "http";
                    this.mUrl = protocol + "://" + nginxLookUpServer.getNginxAuthServer() + "/service/soap";
                } else {
                    this.mUrl = ZJspSession.getSoapURL(pageContext);
                }
            }
            options.setUri(this.mUrl);
            options.setRequestedSkin(this.mRequestedSkin);
            if (this.mCsrfTokenSecured) {
                options.setCsrfSupported(this.mCsrfTokenSecured);
            }
            if (this.mTrustedDevice) {
                options.setTrustedDevice(true);
            }
            if (this.mTrustedDeviceToken != null) {
                options.setTrustedDeviceToken(this.mTrustedDeviceToken);
            }
            if (this.mGenerateDeviceId) {
                options.setGenerateDeviceId(true);
            }
            if (this.mDeviceId != null) {
                options.setDeviceId(this.mDeviceId);
            }
            ZMailbox mbox = ZMailbox.getMailbox((ZMailbox.Options)options);
            HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
            String refer = mbox.getAuthResult().getRefer();
            boolean bl = needRefer = refer != null && !refer.equalsIgnoreCase(serverName);
            if ((this.mAuthToken == null || this.mAuthTokenInUrl || this.mTwoFactorCode != null && this.mTwoFactorCode.length() > 0) && !needRefer) {
                LoginTag.setCookie(response, mbox.getAuthToken(), ZJspSession.secureAuthTokenCookie(request), this.mRememberMe, mbox.getAuthResult().getExpires());
            }
            if ((authResult = mbox.getAuthResult()).getTrustedToken() != null) {
                LoginTag.setTrustedCookie(response, authResult.getTrustedToken(), authResult.getTrustLifetime(), ZJspSession.secureAuthTokenCookie(request));
            }
            if (this.mVarRedirectUrl != null) {
                jctxt.setAttribute(this.mVarRedirectUrl, (Object)ZJspSession.getPostLoginRedirectUrl(pageContext, this.mPath, mbox.getAuthResult(), this.mRememberMe, needRefer), 2);
            }
            if (this.mVarAuthResult != null) {
                jctxt.setAttribute(this.mVarAuthResult, (Object)mbox.getAuthResult(), 2);
            }
            if (!authResult.getTwoFactorAuthRequired()) {
                boolean importDataOnLoginAttr = mbox.getFeatures().getDataSourceImportOnLogin();
                if (this.mImportData && !this.mAdminPreAuth && importDataOnLoginAttr) {
                    mbox.importData(mbox.getAllDataSources());
                }
            }
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
    }

    public static void setCookie(HttpServletResponse response, ZAuthToken zat, boolean secure, boolean rememberMe, long expires) {
        Map cookieMap = zat.cookieMap(false);
        Integer maxAge = null;
        if (rememberMe) {
            long timeLeft = expires - System.currentTimeMillis();
            if (timeLeft > 0L) {
                maxAge = new Integer((int)(timeLeft / 1000L));
            }
        } else {
            maxAge = new Integer(-1);
        }
        for (Map.Entry ck : cookieMap.entrySet()) {
            ZimbraCookie.addHttpOnlyCookie((HttpServletResponse)response, (String)((String)ck.getKey()), (String)((String)ck.getValue()), (String)ZimbraCookie.PATH_ROOT, (Integer)maxAge, (boolean)secure);
        }
    }

    public static void setTrustedCookie(HttpServletResponse response, String trustedToken, long expires, boolean secure) {
        Long timeLeft = expires - System.currentTimeMillis();
        String name = "ZM_TRUST_TOKEN";
        String path = ZimbraCookie.PATH_ROOT;
        Integer secondsLeft = (int)(timeLeft / 1000L);
        if (timeLeft > 0L) {
            ZimbraCookie.addHttpOnlyCookie((HttpServletResponse)response, (String)name, (String)trustedToken, (String)path, (Integer)secondsLeft, (boolean)secure);
        } else {
            ZimbraCookie.clearCookie((HttpServletResponse)response, (String)name);
        }
    }
}

