/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.taglib.ZJspSession;
import com.zimbra.cs.taglib.tag.TagUtil;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.dom4j.QName;

public class GetItemInfoJSONTag
extends ZimbraSimpleTag {
    private static final Pattern sSCRIPT = Pattern.compile("</script>", 2);
    private String mVar;
    private String mId;
    private String mAuthToken;

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setId(String id) {
        this.mId = id;
    }

    public void setAuthtoken(String authToken) {
        this.mAuthToken = authToken;
    }

    public void doTag() throws JspException, IOException {
        try {
            JspContext ctxt = this.getJspContext();
            PageContext pageContext = (PageContext)ctxt;
            String url = ZJspSession.getSoapURL(pageContext);
            String remoteAddr = ZJspSession.getRemoteAddr(pageContext);
            ZAuthToken authToken = new ZAuthToken(this.mAuthToken);
            Element e = GetItemInfoJSONTag.getItemInfoJSON(url, remoteAddr, authToken, this.mId);
            ctxt.setAttribute(this.mVar, (Object)sSCRIPT.matcher(e.toString()).replaceAll("</scr\"+\"ipt>"), 2);
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
    }

    public static Element getItemInfoJSON(String url, String remoteAddr, ZAuthToken authToken, String mId) throws ServiceException {
        TagUtil.JsonDebugListener debug = new TagUtil.JsonDebugListener();
        SoapTransport transport = TagUtil.newJsonTransport(url, remoteAddr, authToken, debug);
        try {
            Element req = Element.create((SoapProtocol)SoapProtocol.SoapJS, (QName)MailConstants.GET_ITEM_REQUEST);
            Element item = req.addElement("item");
            item.addAttribute("id", mId);
            transport.invokeWithoutSession(req);
            return debug.getEnvelope();
        }
        catch (IOException e) {
            throw ZClientException.IO_ERROR((String)("invoke " + e.getMessage()), (Throwable)e);
        }
    }
}

