/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.client.ZFolder;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.soap.ZimbraNamespace;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.taglib.ZJspSession;
import com.zimbra.cs.taglib.tag.TagUtil;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.dom4j.QName;

public class GetInfoJSONTag
extends ZimbraSimpleTag {
    private String mVar;
    private String mCsrfToken;
    private ZAuthToken mAuthToken;
    private String mItemsPerPage;
    private String mTypes;
    private boolean mDoSearch;
    private String mFolderPath;
    private String mSortBy;
    private boolean mFullConversation;

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setAuthtoken(ZAuthToken authToken) {
        this.mAuthToken = authToken;
    }

    public void setCsrftoken(String csrfToken) {
        this.mCsrfToken = csrfToken;
    }

    public void setDosearch(boolean doSearch) {
        this.mDoSearch = doSearch;
    }

    public void setItemsperpage(String itemsPerPage) {
        this.mItemsPerPage = itemsPerPage;
    }

    public void setTypes(String types) {
        this.mTypes = types;
    }

    public void setFolderpath(String folderPath) {
        this.mFolderPath = folderPath;
    }

    public void setSortby(String sortBy) {
        this.mSortBy = sortBy;
    }

    public void setFullconversation(boolean fullConversation) {
        this.mFullConversation = fullConversation;
    }

    public void doTag() throws JspException {
        try {
            JspContext ctxt = this.getJspContext();
            PageContext pageContext = (PageContext)ctxt;
            String url = ZJspSession.getSoapURL(pageContext);
            String remoteAddr = ZJspSession.getRemoteAddr(pageContext);
            if (this.mFolderPath != null && !this.mFolderPath.isEmpty()) {
                ZMailbox.Options options = new ZMailbox.Options();
                options.setClientIp(ZJspSession.getRemoteAddr(pageContext));
                options.setNoSession(true);
                options.setAuthToken(this.mAuthToken);
                options.setAuthAuthToken(true);
                options.setUri(url);
                ZMailbox mbox = ZMailbox.getMailbox((ZMailbox.Options)options);
                mbox.initCsrfToken(this.mCsrfToken);
                String folderId = this.getFolderFromPath(mbox, this.mFolderPath);
                if (folderId != null && !folderId.isEmpty()) {
                    this.mSortBy = this.getSortByAttr(folderId, this.mSortBy);
                }
            }
            Element e = GetInfoJSONTag.getBootstrapJSON(url, remoteAddr, this.mAuthToken, this.mCsrfToken, this.mDoSearch, this.mItemsPerPage, this.mTypes, this.mSortBy, this.mFullConversation);
            ctxt.setAttribute(this.mVar, (Object)e.toString(), 2);
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
    }

    public static Element getBootstrapJSON(String url, String remoteAddr, ZAuthToken authToken, boolean doSearch, String itemsPerPage, String searchTypes, String sortBy, boolean fullConversation) throws ServiceException {
        return GetInfoJSONTag.getBootstrapJSON(url, remoteAddr, authToken, null, doSearch, itemsPerPage, searchTypes, sortBy, fullConversation);
    }

    public static Element getBootstrapJSON(String url, String remoteAddr, ZAuthToken authToken, String csrfToken, boolean doSearch, String itemsPerPage, String searchTypes, String sortBy, boolean fullConversation) throws ServiceException {
        TagUtil.JsonDebugListener debug = new TagUtil.JsonDebugListener();
        SoapTransport transport = TagUtil.newJsonTransport(url, remoteAddr, authToken, csrfToken, debug);
        try {
            Element batch = Element.create((SoapProtocol)SoapProtocol.SoapJS, (QName)ZimbraNamespace.E_BATCH_REQUEST);
            Element getInfoRequest = batch.addElement(AccountConstants.GET_INFO_REQUEST);
            getInfoRequest.addAttribute("rights", "createDistList");
            if (doSearch) {
                Element search = batch.addElement(MailConstants.SEARCH_REQUEST);
                if (itemsPerPage != null && itemsPerPage.length() > 0) {
                    search.addAttribute("limit", itemsPerPage);
                }
                if (searchTypes != null && searchTypes.length() > 0) {
                    search.addAttribute("types", searchTypes);
                }
                if (sortBy != null && !sortBy.isEmpty()) {
                    search.addAttribute("sortBy", sortBy);
                }
                search.addAttribute("fullConversation", fullConversation);
            }
            transport.invoke(batch);
            return debug.getEnvelope();
        }
        catch (IOException e) {
            throw ZClientException.IO_ERROR((String)("invoke " + e.getMessage()), (Throwable)e);
        }
    }

    private String getFolderFromPath(ZMailbox mbox, String folderPath) throws ServiceException {
        ZFolder rootFolder;
        ZFolder folder;
        String folderId = "";
        if (folderPath != null && (folder = (rootFolder = mbox.getUserRoot()).getSubFolderByPath(this.mFolderPath)) != null) {
            folderId = folder.getId();
        }
        if (ZimbraLog.webclient.isDebugEnabled()) {
            ZimbraLog.webclient.debug((Object)("folderPath = " + folderPath));
            ZimbraLog.webclient.debug((Object)("folderId = " + folderId));
        }
        return folderId;
    }

    private String getSortByAttr(String folderId, String sortOrderPref) {
        String sortBy = "";
        if (folderId != null & !folderId.isEmpty() && sortOrderPref != null && !sortOrderPref.isEmpty()) {
            String[] folders = sortOrderPref.split(",");
            for (int i = 0; i < folders.length; ++i) {
                if (!folders[i].startsWith(folderId + ":")) continue;
                int index = folders[i].indexOf(":");
                sortBy = folders[i].substring(index + 1);
                break;
            }
        }
        if (ZimbraLog.webclient.isDebugEnabled()) {
            ZimbraLog.webclient.debug((Object)("sortOrderPref = " + sortOrderPref));
            ZimbraLog.webclient.debug((Object)("sortBy = " + sortBy));
        }
        return sortBy;
    }
}

