/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.client.ZDomain;
import com.zimbra.client.ZSoapProvisioning;
import com.zimbra.common.account.Key;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

public class GetFavIconTag
extends ZimbraSimpleTag {
    private String var;
    private HttpServletRequest request;

    public void setVar(String var) {
        this.var = var;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void doTag() throws JspException, IOException {
        try {
            ZDomain info;
            String soapUri = LC.zimbra_admin_service_scheme.value() + LC.zimbra_zmprov_default_soap_server.value() + ':' + LC.zimbra_admin_service_port.intValue() + "/service/admin/soap/";
            ZSoapProvisioning provisioning = new ZSoapProvisioning();
            provisioning.soapSetURI(soapUri);
            String serverName = this.request.getParameter("customerDomain");
            if (serverName == null) {
                serverName = HttpUtil.getVirtualHost((HttpServletRequest)this.request);
            }
            if ((info = provisioning.getDomainInfo(Key.DomainBy.virtualHostname, serverName)) != null) {
                String favicon = info.getSkinFavicon();
                this.getJspContext().setAttribute(this.var, (Object)favicon, 2);
            } else {
                ZimbraLog.webclient.debug((Object)"unable to get domain info");
            }
        }
        catch (Exception e) {
            ZimbraLog.webclient.debug((Object)"error getting favicon:", (Throwable)e);
        }
    }
}

