/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.client.ZDomain;
import com.zimbra.client.ZSoapProvisioning;
import com.zimbra.common.account.Key;
import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.net.SocketFactories;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;

public class GetDomainInfoTag
extends ZimbraSimpleTag {
    private static final String CONFIG_ZIMBRA_DOMAININFO_TTL = "zimbra.domaininfo.ttl";
    private String mVar;
    private Key.DomainBy mBy;
    private String mValue;
    private String mCsrfToken;
    private ZAuthToken mAuthToken;
    private static final Map<String, CachedDomain> mCache;
    private static final String DEFAULT_TTL_STR = "60m";
    private static final long DEFAULT_TTL = 3600000L;
    private static long sCacheTtl;

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setBy(String by) throws ServiceException {
        this.mBy = Key.DomainBy.fromString((String)by);
    }

    public void setValue(String value) {
        this.mValue = value;
    }

    public void setAuthtoken(ZAuthToken authToken) {
        this.mAuthToken = authToken;
    }

    public void setCsrftoken(String csrfToken) {
        this.mCsrfToken = csrfToken;
    }

    public void doTag() throws JspException, IOException {
        JspContext ctxt = this.getJspContext();
        if (sCacheTtl == -1L) {
            String ttl = (String)Config.find((PageContext)((PageContext)ctxt), (String)CONFIG_ZIMBRA_DOMAININFO_TTL);
            sCacheTtl = DateUtil.getTimeInterval((String)(ttl != null ? ttl : DEFAULT_TTL_STR), (long)3600000L);
        }
        ctxt.setAttribute(this.mVar, (Object)this.checkCache(), 2);
    }

    private String getCacheKey() {
        return this.mBy + "/" + this.mValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZDomain checkCache() {
        CachedDomain cd;
        if (this.mAuthToken == null && (cd = mCache.get(this.getCacheKey())) != null && cd.expireTime > System.currentTimeMillis()) {
            return cd.domain;
        }
        ZDomain d = this.getInfo();
        if (this.mAuthToken == null) {
            Map<String, CachedDomain> map = mCache;
            synchronized (map) {
                mCache.put(this.getCacheKey(), new CachedDomain(d));
            }
        }
        return d;
    }

    private ZDomain getInfo() {
        ZSoapProvisioning sp = new ZSoapProvisioning();
        String mServer = LC.zimbra_zmprov_default_soap_server.value();
        int mPort = LC.zimbra_admin_service_port.intValue();
        sp.soapSetURI(LC.zimbra_admin_service_scheme.value() + mServer + ":" + mPort + "/service/admin/soap/");
        sp.setAuthToken(this.mAuthToken);
        sp.setCsrfToken(this.mCsrfToken);
        try {
            return sp.getDomainInfo(this.mBy, this.mValue);
        }
        catch (ServiceException e) {
            ZimbraLog.webclient.error((Object)"Error during GetDomainInfoRequest invocation", (Throwable)e);
            return null;
        }
    }

    static {
        SocketFactories.registerProtocols();
        mCache = new HashMap<String, CachedDomain>();
        sCacheTtl = -1L;
    }

    static class CachedDomain {
        public ZDomain domain;
        public long expireTime;

        public CachedDomain(ZDomain d) {
            this.domain = d;
            this.expireTime = System.currentTimeMillis() + sCacheTtl;
        }
    }
}

