/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.client.ZFolder;
import com.zimbra.client.ZMailbox;
import com.zimbra.client.ZSearchFolder;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZFolderBean;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.JspFragment;

public class ForEachFolderTag
extends ZimbraSimpleTag {
    private String mVar;
    private Map mExpanded = null;
    private String mParentId;
    private ZFolderBean mParentFolder;
    private boolean mSkipRoot = true;
    private boolean mSkipSystem = false;
    private boolean mSkipTopSearch = false;
    private boolean mSkipTrash = false;

    public void setParentid(String parentId) {
        this.mParentId = parentId != null && parentId.length() == 0 ? null : parentId;
    }

    public void setParentfolder(ZFolderBean folder) {
        this.mParentFolder = folder;
    }

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setSkiproot(boolean skiproot) {
        this.mSkipRoot = skiproot;
    }

    public void setSkipsystem(boolean skipsystem) {
        this.mSkipSystem = skipsystem;
    }

    public void setSkiptopsearch(boolean skiptopsearch) {
        this.mSkipTopSearch = skiptopsearch;
    }

    public void setExpanded(Map expanded) {
        this.mExpanded = expanded;
    }

    public void setSkiptrash(boolean skipTrash) {
        this.mSkipTrash = skipTrash;
    }

    public void doTag() throws JspException, IOException {
        JspFragment body = this.getJspBody();
        if (body == null) {
            return;
        }
        try {
            ZMailbox mbox = this.getMailbox();
            JspContext jctxt = this.getJspContext();
            ZFolder folder = this.mParentId != null ? mbox.getFolderById(this.mParentId) : (this.mParentFolder != null ? this.mParentFolder.folderObject() : mbox.getUserRoot());
            this.handleFolder(folder, body, jctxt, this.mSkipRoot, this.mSkipSystem);
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    private void handleFolder(ZFolder folder, JspFragment body, JspContext jctxt, boolean skip, boolean skipsystem) throws ServiceException, JspException, IOException {
        String state;
        if (folder == null) {
            return;
        }
        if (skipsystem && folder.isSystemFolder() && !folder.getId().equals("1")) {
            return;
        }
        if (this.mSkipTopSearch && folder instanceof ZSearchFolder && folder.getParentId().equals("1")) {
            return;
        }
        if (this.mSkipTrash && folder.getId().equals("3")) {
            return;
        }
        if (!skip) {
            jctxt.setAttribute(this.mVar, (Object)new ZFolderBean(folder));
            body.invoke(null);
        }
        if (this.mExpanded != null && !folder.getSubFolders().isEmpty() && (state = (String)this.mExpanded.get(folder.getId())) != null && state.equals("collapse")) {
            return;
        }
        List subfolders = folder.getSubFolders();
        Collections.sort(subfolders);
        for (ZFolder subfolder : subfolders) {
            if (subfolder == null) continue;
            this.handleFolder(subfolder, body, jctxt, false, skipsystem);
        }
    }
}

