/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.client.ZFolder;
import com.zimbra.client.ZMailbox;
import com.zimbra.client.ZPhoneAccount;
import com.zimbra.client.ZSearchFolder;
import com.zimbra.client.ZSearchParams;
import com.zimbra.client.ZTag;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.ZJspSession;
import com.zimbra.cs.taglib.bean.ZFolderBean;
import com.zimbra.cs.taglib.bean.ZPhoneAccountBean;
import com.zimbra.cs.taglib.bean.ZTagBean;
import com.zimbra.cs.taglib.tag.SearchContext;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import com.zimbra.cs.taglib.tag.i18n.I18nUtil;
import com.zimbra.soap.type.SearchSortBy;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class ComputeSearchContextTag
extends ZimbraSimpleTag {
    private static final int DEFAULT_SEARCH_LIMIT = 25;
    public static final String TYPE_MAIL = "mail";
    public static final String TYPE_CONTACTS = "contacts";
    private static final String QP_SEARCH_CONTEXT = "sc";
    private static final String QP_SEARCH_QUERY = "sq";
    private static final String QP_SEARCH_FOLDER_ID = "sfi";
    private static final String QP_SEARCH_TAG_ID = "sti";
    private static final String QP_SEARCH_OFFSET = "so";
    private static final String QP_SEARCH_LIMIT = "sl";
    private static final String QP_SEARCH_SORT = "ss";
    private static final String QP_SEARCH_USE_CACHE = "su";
    private static final String QP_SEARCH_TYPES = "st";
    private static final String QP_SEARCH_INDEX = "si";
    private static final String QP_ACCT_NAME = "acct";
    private String mVar;
    private String mTypes;
    private String mQuery;
    private SearchSortBy mSortBy;
    private boolean mUseCache;
    private int mLimit = -1;

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setQuery(String query) {
        this.mQuery = query != null && query.length() > 0 ? query : null;
    }

    public void setUsecache(boolean usecache) {
        this.mUseCache = usecache;
    }

    public void setTypes(String types) {
        this.mTypes = types;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    private int getInt(ServletRequest req, String name, int def) {
        try {
            String value = req.getParameter(name);
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return def;
    }

    public void doTag() throws JspException, IOException {
        try {
            String sc;
            SearchContext sContext;
            ZMailbox mailbox = this.getMailbox();
            PageContext pageContext = (PageContext)this.getJspContext();
            ServletRequest req = pageContext.getRequest();
            int si = this.getInt(req, QP_SEARCH_INDEX, 0);
            int so = this.getInt(req, QP_SEARCH_OFFSET, 0);
            int usecache = this.getInt(req, QP_SEARCH_USE_CACHE, -1);
            if (usecache == 1) {
                this.mUseCache = true;
            }
            if ((sContext = SearchContext.getSearchContext(pageContext, sc = req.getParameter(QP_SEARCH_CONTEXT))) != null) {
                pageContext.setAttribute(this.mVar, (Object)sContext, 2);
                if (si != -1) {
                    sContext.setCurrentItemIndex(si);
                }
                if (sContext.getSearchResult() == null || sContext.getParams().getOffset() != so || !this.mUseCache) {
                    sContext.getParams().setOffset(so);
                }
            } else {
                sContext = SearchContext.newSearchContext(pageContext);
                pageContext.setAttribute(this.mVar, (Object)sContext, 2);
                this.determineQuery(pageContext, sContext, req, mailbox);
                sContext.setParams(this.determineParams(sContext, req, so, mailbox));
                this.mUseCache = false;
            }
            String st = sContext.getSt();
            boolean isVoiceMailSearch = "voicemail".equals(st);
            ZPhoneAccountBean account = sContext.getPhoneAccount();
            if (!isVoiceMailSearch || account == null || account.getHasVoiceMail()) {
                boolean useOffset = isVoiceMailSearch || "calllog".equals(st) || ZJspSession.getSearchUseOffset(pageContext);
                sContext.doSearch(mailbox, this.mUseCache, !useOffset);
                if (sContext.getCurrentItemIndex() != si) {
                    sContext.setCurrentItemIndex(si);
                }
            }
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
    }

    private ZSearchParams determineParams(SearchContext result, ServletRequest trareq, int so, ZMailbox mailbox) throws ServiceException {
        ZSearchParams params = new ZSearchParams(result.getQuery());
        params.setOffset(so);
        if (result.getFolder() != null && (result.getFolder().getIsDrafts() || result.getFolder().getIsSent())) {
            params.setRecipientMode(true);
        }
        params.setSortBy(this.mSortBy);
        params.setTypes(this.mTypes);
        if (this.mLimit == -1) {
            try {
                this.mLimit = Integer.parseInt(trareq.getParameter(QP_SEARCH_LIMIT));
            }
            catch (NumberFormatException e) {
                this.mLimit = "contact".equals(this.mTypes) ? (int)mailbox.getPrefs().getContactsPerPage() : ("voicemail".equals(this.mTypes) || "calllog".equals(this.mTypes) ? (int)mailbox.getPrefs().getVoiceItemsPerPage() : (int)mailbox.getPrefs().getMailItemsPerPage());
            }
            if (this.mLimit == -1) {
                this.mLimit = 25;
            }
        }
        params.setLimit(this.mLimit);
        return params;
    }

    private void determineQuery(PageContext pageContext, SearchContext result, ServletRequest req, ZMailbox mailbox) throws JspException, ServiceException {
        ZTag tag;
        String sq = this.mQuery != null ? this.mQuery : req.getParameter(QP_SEARCH_QUERY);
        String sfi = req.getParameter(QP_SEARCH_FOLDER_ID);
        String sti = req.getParameter(QP_SEARCH_TAG_ID);
        String st = req.getParameter(QP_SEARCH_TYPES);
        String ss = req.getParameter(QP_SEARCH_SORT);
        String acct = req.getParameter(QP_ACCT_NAME);
        result.setSq(sq);
        result.setSfi(sfi);
        result.setSti(sti);
        result.setSs(ss);
        if (this.mTypes == null) {
            this.mTypes = st != null ? st : (mailbox.getFeatures().getConversations() ? (mailbox.getPrefs().getGroupByMessage() ? "message" : "conversation") : "message");
        }
        result.setSt(this.mTypes);
        if (ss != null) {
            this.mSortBy = SearchSortBy.fromString((String)ss);
        }
        if (this.mSortBy == null) {
            SearchSortBy searchSortBy = "contact".equals(this.mTypes) || "gal".equals(this.mTypes) ? SearchSortBy.nameAsc : (this.mSortBy = "task".equals(this.mTypes) ? SearchSortBy.taskDueDesc : SearchSortBy.dateDesc);
        }
        if (sq == null && sti == null && sfi == null) {
            if ("contact".equals(this.mTypes)) {
                sfi = "7";
            } else if ("task".equals(this.mTypes)) {
                sfi = "15";
            } else if ("wiki".equals(this.mTypes)) {
                sfi = "12";
            } else if ("briefcase".equals(this.mTypes)) {
                sfi = "16";
            } else if (!"voicemail".equals(this.mTypes)) {
                if (mailbox.getFeatures().getInitialSearchPreference() && (sq = mailbox.getPrefs().getMailInitialSearch()) != null && sq.equalsIgnoreCase("in:inbox")) {
                    sq = null;
                }
                if (sq == null || sq.length() == 0) {
                    sfi = "2";
                }
            }
        }
        result.setTypes(this.mTypes);
        if ("voicemail".equals(st) || "calllog".equals(st)) {
            this.determineVoiceQuery(mailbox, sq, result);
            return;
        }
        if (sq != null) {
            result.setTitle(sq);
            result.setBackTo(I18nUtil.getLocalizedMessage(pageContext, "backToSearch"));
            result.setShortBackTo(sq);
            result.setQuery(sq);
            result.setShowMatches(true);
            return;
        }
        if (sfi != null) {
            ZFolder folder = mailbox.getFolderById(sfi);
            if (folder != null) {
                if (folder instanceof ZSearchFolder) {
                    result.setQuery(((ZSearchFolder)folder).getQuery());
                    result.setShowMatches(true);
                    String name = I18nUtil.getLocalizedMessage(pageContext, "FOLDER_LABEL_" + folder.getId());
                    name = name == null || name.startsWith("???") ? folder.getName() : name;
                    result.setBackTo(I18nUtil.getLocalizedMessage(pageContext, "backToSearchFolder", new Object[]{name}));
                    result.setShortBackTo(name);
                } else {
                    String name = I18nUtil.getLocalizedMessage(pageContext, "FOLDER_LABEL_" + folder.getId());
                    name = name == null || name.startsWith("???") ? folder.getName() : name;
                    result.setQuery("in:\"" + folder.getRootRelativePath() + "\"");
                    result.setBackTo(I18nUtil.getLocalizedMessage(pageContext, "backToFolder", new Object[]{name}));
                    result.setShortBackTo(name);
                }
                result.setFolder(new ZFolderBean(folder));
                result.setTitle(folder.getName());
                result.setSelectedId(folder.getId());
            } else if (acct != null) {
                result.setQuery("inid:\"" + sfi + "\"");
            }
            return;
        }
        if (sti != null && (tag = mailbox.getTagById(sti)) != null) {
            result.setQuery("tag:\"" + tag.getName() + "\"");
            result.setTitle(tag.getName());
            result.setBackTo(I18nUtil.getLocalizedMessage(pageContext, "backToTag", new Object[]{tag.getName()}));
            result.setShortBackTo(tag.getName());
            result.setSelectedId(tag.getId());
            result.setTag(new ZTagBean(tag));
            result.setShowMatches(true);
            return;
        }
        throw new JspTagException("unable to determine query");
    }

    private void determineVoiceQuery(ZMailbox mailbox, String sq, SearchContext result) throws ServiceException {
        ZPhoneAccount account = this.getAccountFromVoiceQuery(mailbox, sq);
        result.setPhoneAccount(account);
        String query = sq;
        if (query == null && account != null) {
            query = "phone:" + account.getPhone().getName();
        }
        result.setQuery(query);
        if (account != null) {
            String folderName = "Voicemail Inbox";
            if (sq != null) {
                if (sq.indexOf("Missed Calls") != -1) {
                    folderName = "Missed Calls";
                } else if (sq.indexOf("Answered Calls") != -1) {
                    folderName = "Answered Calls";
                } else if (sq.indexOf("Placed Calls") != -1) {
                    folderName = "Placed Calls";
                } else if (sq.indexOf("Trash") != -1) {
                    folderName = "Trash";
                }
            }
            ZFolder folder = account.getRootFolder().getSubFolderByPath(folderName);
            result.setFolder(new ZFolderBean(folder));
            result.setSelectedId(folder.getId());
            result.setTitle(folder.getName());
        }
    }

    private ZPhoneAccount getAccountFromVoiceQuery(ZMailbox mailbox, String query) throws ServiceException {
        String phone;
        int match;
        if (query != null && (match = query.indexOf(phone = "phone:")) != -1) {
            int startIndex = match + phone.length();
            int endIndex = query.indexOf(32, startIndex);
            if (endIndex == -1) {
                endIndex = query.length();
            }
            String name = query.substring(startIndex, endIndex);
            return mailbox.getPhoneAccount(name);
        }
        List accounts = mailbox.getAllPhoneAccounts();
        for (ZPhoneAccount account : accounts) {
            if (!account.getHasVoiceMail()) continue;
            return account;
        }
        return null;
    }
}

