/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import com.zimbra.soap.mail.message.CheckSpellingResponse;
import com.zimbra.soap.mail.type.Misspelling;
import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;

public class CheckSpellingTag
extends ZimbraSimpleTag {
    private String mText;

    public void setText(String text) {
        this.mText = text;
    }

    public void doTag() throws JspException, IOException {
        JspContext jctxt = this.getJspContext();
        try {
            ZMailbox mbox = this.getMailbox();
            String trimmed = this.mText.trim().replaceAll("\\u00A0", " ").replaceAll("\\s\\s+", " ");
            CheckSpellingResponse res = mbox.checkSpelling(trimmed);
            JspWriter out = jctxt.getOut();
            out.print("{\"available\":");
            out.print(res.isAvailable() ? "true" : "false");
            out.println(",\"data\":[");
            boolean firstMisspelling = true;
            for (Misspelling misspelling : res.getMisspelledWords()) {
                if (!firstMisspelling) {
                    out.print(',');
                }
                firstMisspelling = false;
                out.print("{\"word\":\"");
                out.print(misspelling.getWord());
                out.print("\",\"suggestions\":[");
                List suggestions = misspelling.getSuggestionsList();
                int count = suggestions.size();
                for (int i = 0; i < count && i < 5; ++i) {
                    if (i > 0) {
                        out.print(',');
                    }
                    out.print('\"');
                    out.print((String)suggestions.get(i));
                    out.print('\"');
                }
                out.println("]}");
            }
            out.println("]}");
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }
}

