/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.client.ZChangePasswordResult;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.ZJspSession;
import com.zimbra.cs.taglib.tag.LoginTag;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class ChangePasswordTag
extends ZimbraSimpleTag {
    private String mUsername;
    private String mPassword;
    private String mNewPassword;
    private String mUrl = null;
    private boolean mSecure = ZJspSession.isProtocolModeHttps();
    private boolean mRememberMe;

    public void setUsername(String username) {
        this.mUsername = username;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public void setNewpassword(String password) {
        this.mNewPassword = password;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public void setSecure(boolean secure) {
        this.mSecure = secure;
    }

    public void setRememberme(boolean rememberMe) {
        this.mRememberMe = rememberMe;
    }

    public void doTag() throws JspException, IOException {
        JspContext jctxt = this.getJspContext();
        try {
            PageContext pageContext = (PageContext)jctxt;
            ZMailbox.Options options = new ZMailbox.Options();
            options.setAccount(this.mUsername);
            options.setPassword(this.mPassword);
            options.setNewPassword(this.mNewPassword);
            options.setUri(this.mUrl == null ? ZJspSession.getSoapURL(pageContext) : this.mUrl);
            ZChangePasswordResult cpr = ZMailbox.changePassword((ZMailbox.Options)options);
            LoginTag.setCookie((HttpServletResponse)pageContext.getResponse(), cpr.getAuthToken(), this.mSecure, this.mRememberMe, cpr.getExpires());
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
    }
}

