/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.client.ZFolder;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.soap.ZimbraNamespace;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.taglib.ZJspSession;
import com.zimbra.cs.taglib.tag.TagUtil;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class CalSearchJSONTag
extends ZimbraSimpleTag {
    private static final Pattern sSCRIPT = Pattern.compile("</script>", 2);
    private String mVar;
    private ZAuthToken mAuthToken;
    private String mCsrfToken;
    private String mItemsPerPage;
    private String mTypes;
    private TimeZone mTimeZone;

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setAuthtoken(ZAuthToken authToken) {
        this.mAuthToken = authToken;
    }

    public void setCsrftoken(String csrfToken) {
        this.mCsrfToken = csrfToken;
    }

    public void setItemsperpage(String itemsPerPage) {
        this.mItemsPerPage = itemsPerPage;
    }

    public void setTypes(String types) {
        this.mTypes = types;
    }

    public void setTimezone(TimeZone timezone) {
        this.mTimeZone = timezone;
    }

    public void doTag() throws JspException {
        try {
            JspContext ctxt = this.getJspContext();
            PageContext pageContext = (PageContext)ctxt;
            String url = ZJspSession.getSoapURL(pageContext);
            String remoteAddr = ZJspSession.getRemoteAddr(pageContext);
            Element e = CalSearchJSONTag.getBootstrapCalSearchJSON(url, remoteAddr, this.mAuthToken, this.mCsrfToken, this.mItemsPerPage, this.mTypes);
            String json = e.toString();
            String json2 = sSCRIPT.matcher(json).replaceAll("</scr\"+\"ipt>");
            ctxt.setAttribute(this.mVar, (Object)json2, 2);
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
    }

    public static Element getBootstrapCalSearchJSON(String url, String remoteAddr, ZAuthToken authToken, String itemsPerPage, String searchTypes) throws ServiceException {
        return CalSearchJSONTag.getBootstrapCalSearchJSON(url, remoteAddr, authToken, null, itemsPerPage, searchTypes);
    }

    public static Element getBootstrapCalSearchJSON(String url, String remoteAddr, ZAuthToken authToken, String csrfToken, String itemsPerPage, String searchTypes) throws ServiceException {
        ZMailbox.Options options = new ZMailbox.Options(authToken, url);
        options.setNoSession(false);
        options.setAuthAuthToken(false);
        options.setClientIp(remoteAddr);
        ZMailbox mbox = ZMailbox.getMailbox((ZMailbox.Options)options);
        if (csrfToken != null) {
            mbox.initCsrfToken(csrfToken);
        }
        try {
            TimeZone tz = mbox.getPrefs().getTimeZone();
            Calendar currentDay = tz == null ? Calendar.getInstance() : Calendar.getInstance(tz);
            currentDay.setTimeInMillis(System.currentTimeMillis());
            currentDay.set(11, 0);
            currentDay.set(12, 0);
            currentDay.set(13, 0);
            currentDay.set(14, 0);
            currentDay.set(5, 1);
            StringBuilder sb = new StringBuilder();
            CalSearchJSONTag.getCheckedCalendarFoldersRecursive(mbox.getUserRoot(), sb);
            String checkedCalendars = sb.toString();
            Calendar other = Calendar.getInstance(currentDay.getTimeZone());
            other.setTimeInMillis(currentDay.getTimeInMillis());
            other.add(5, -8);
            long calStart = other.getTimeInMillis();
            other.setTimeInMillis(currentDay.getTimeInMillis());
            other.add(5, 42);
            long calEnd = other.getTimeInMillis();
            Element.JSONElement batch = new Element.JSONElement(ZimbraNamespace.E_BATCH_REQUEST);
            Element miniCalRequest = batch.addElement(MailConstants.GET_MINI_CAL_REQUEST);
            miniCalRequest.addAttribute("s", calStart);
            miniCalRequest.addAttribute("e", calEnd);
            String[] sArray = null;
            StringBuilder searchQuery = new StringBuilder();
            if (checkedCalendars != null) {
                sArray = checkedCalendars.indexOf(",") == -1 ? new String[]{checkedCalendars} : checkedCalendars.split(",");
                for (int i = 0; i < sArray.length; ++i) {
                    Element folder = miniCalRequest.addElement("folder");
                    folder.addAttribute("id", sArray[i]);
                    if (searchQuery.length() > 1) {
                        searchQuery.append(" or ");
                    }
                    searchQuery.append("inid:").append("\"" + sArray[i] + "\"");
                }
            }
            Element search = batch.addElement(MailConstants.SEARCH_REQUEST);
            if (itemsPerPage != null && itemsPerPage.length() > 0) {
                search.addAttribute("limit", itemsPerPage);
            }
            if (searchTypes != null && searchTypes.length() > 0) {
                search.addAttribute("types", searchTypes);
            }
            search.addAttribute("calExpandInstStart", calStart);
            search.addAttribute("calExpandInstEnd", calEnd);
            search.addAttribute("offset", 0L);
            Element queryEl = search.addElement("query");
            queryEl.setText(searchQuery.toString());
            TagUtil.JsonDebugListener debug = new TagUtil.JsonDebugListener();
            SoapTransport transport = TagUtil.newJsonTransport(url, remoteAddr, authToken, csrfToken, debug);
            transport.invoke((Element)batch);
            Element e = debug.getEnvelope();
            Element responseParams = e.addElement("search");
            responseParams.addAttribute("s", calStart);
            responseParams.addAttribute("e", calEnd);
            Element queryElement = responseParams.addElement("query");
            queryElement.setText(searchQuery.toString());
            responseParams.addAttribute("l", checkedCalendars);
            return e;
        }
        catch (IOException e) {
            throw ZClientException.IO_ERROR((String)("invoke " + e.getMessage()), (Throwable)e);
        }
    }

    private static void getCheckedCalendarFoldersRecursive(ZFolder f, StringBuilder sb) {
        if (f.getDefaultView() == ZFolder.View.appointment && f.isCheckedInUI()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(f.getId());
        }
        for (ZFolder child : f.getSubFolders()) {
            CalSearchJSONTag.getCheckedCalendarFoldersRecursive(child, sb);
        }
    }
}

