/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.tag;

import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZUserAgentBean;
import com.zimbra.cs.taglib.tag.GetUserAgentTag;
import com.zimbra.cs.taglib.tag.ZimbraSimpleTag;
import com.zimbra.cs.taglib.tag.i18n.I18nUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class BindKeyTag
extends ZimbraSimpleTag {
    public static final String CTRL = "Ctrl+";
    public static final String META = "Meta+";
    public static final String ALT = "Alt+";
    public static final String SHIFT = "Shift+";
    public static final String ARROW_DOWN = "ArrowDown";
    public static final String ARROW_LEFT = "ArrowLeft";
    public static final String ARROW_RIGHT = "ArrowRight";
    public static final String ARROW_UP = "ArrowUp";
    public static final String BACKSPACE = "Backspace";
    public static final String COMMA = "Comma";
    public static final String SEMICOLON = "Semicolon";
    public static final String DELETE = "Del";
    public static final String END = "End";
    public static final String ENTER = "Enter";
    public static final String ESC = "Esc";
    public static final String HOME = "Home";
    public static final String PAGE_DOWN = "PgDown";
    public static final String PAGE_UP = "PgUp";
    public static final String SPACE = "Space";
    public static final String BACKSLASH = "Backslash";
    private static final String BINDKEY_CACHE = "BindKeyTag.CACHE";
    private static final String A_GOTO_TAG = "gototag";
    private static final String A_TAG = "tag";
    private static final String A_GOTO_FOLDER = "gotofolder";
    private static final String A_FOLDER = "folder";
    private static final String A_SEARCH = "search";
    private String mKey;
    private String mMessage;
    private String mBasename = "/keys/ZhKeys";
    private String mId;
    private String mFunc;
    private String mUrl;
    private String mAlias;
    private static final Pattern sOLD_SHORTCUT = Pattern.compile("^(global\\.GoToTag|global\\.SavedSearch|mail.GoToFolder)(\\d+)\\.(\\d+)=.*");
    private static final Pattern sSHORTCUT = Pattern.compile("^(F|T|S),(\\d+),(\\d+)$");
    private static final Pattern sSEP = Pattern.compile("\\|");

    public void setId(String id) {
        this.mId = id;
    }

    public void setKey(String key) {
        this.mKey = key;
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }

    public void setFunc(String func) {
        this.mFunc = func;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public void setBasename(String basename) {
        this.mBasename = basename;
    }

    public void setAlias(String alias) {
        this.mAlias = alias;
    }

    public void doTag() throws JspException, IOException {
        JspContext jctxt = this.getJspContext();
        if (this.mKey == null && this.mMessage == null) {
            throw new JspTagException("The bindKey tag must have either a key or a message attribute");
        }
        String js = null;
        try {
            if (this.mAlias == null) {
                if (this.mId == null && this.mFunc == null && this.mUrl == null) {
                    throw new JspTagException("The bindKey tag must have either a function, url, or an id");
                }
                js = this.mMessage != null ? this.getJavaScriptForMessage(jctxt, this.mMessage, true) : this.getJavaScriptForKey(this.mKey);
            } else if (A_GOTO_TAG.equals(this.mAlias)) {
                js = this.generateGoToTagAliases(jctxt, NumericShortCutType.tag);
            } else if (A_GOTO_FOLDER.equals(this.mAlias)) {
                js = this.generateGoToTagAliases(jctxt, NumericShortCutType.folder);
            } else if (A_SEARCH.equals(this.mAlias)) {
                js = this.generateGoToTagAliases(jctxt, NumericShortCutType.search);
            } else if (A_TAG.equals(this.mAlias)) {
                js = this.generateTagAliases(jctxt);
            } else if (A_FOLDER.equals(this.mAlias)) {
                js = this.generateFolderMoveAliases(jctxt);
            }
            if (js != null) {
                JspWriter out = jctxt.getOut();
                out.write(js);
            }
        }
        catch (ServiceException e) {
            throw new JspTagException(e.getMessage(), (Throwable)e);
        }
    }

    private String resolveMessageKey(JspContext ctxt, String message) {
        ZUserAgentBean ua = GetUserAgentTag.getUserAgent(ctxt, true);
        String prop = message + ".keycode";
        if (ua != null) {
            String key;
            String os;
            String string = ua.getIsOsWindows() ? ".win" : (ua.getIsOsMac() ? ".mac" : (os = ua.getIsOsLinux() ? ".linux" : null));
            if (os != null && !(key = I18nUtil.getLocalizedMessage((PageContext)ctxt, prop + os, this.mBasename)).startsWith("???")) {
                return key;
            }
        }
        return I18nUtil.getLocalizedMessage((PageContext)ctxt, prop, this.mBasename);
    }

    private String generateGoToTagAliases(JspContext ctxt, NumericShortCutType type) throws JspException, ServiceException, IOException {
        ZMailbox mailbox = this.getMailbox();
        String pref = mailbox.getPrefs().getShortcuts();
        if (pref == null) {
            return null;
        }
        String seq = this.resolveMessageKey(ctxt, this.mMessage);
        if (seq == null || seq.indexOf("NNN") == -1) {
            return null;
        }
        List<NumericShortCut> shortCuts = BindKeyTag.getNumericShortCuts(pref);
        StringBuilder sb = new StringBuilder();
        for (NumericShortCut shortcut : shortCuts) {
            if (shortcut.getType() != type) continue;
            String msg = seq.replace("NNN", shortcut.getNumber());
            this.mId = (type == NumericShortCutType.tag ? "TAG" : (type == NumericShortCutType.folder ? "FLDR" : "SRCH")) + shortcut.getId();
            String js = this.getJavaScriptForMessage(ctxt, msg, false);
            if (js == null) continue;
            sb.append(js);
        }
        return sb.toString();
    }

    private String generateTagAliases(JspContext ctxt) throws JspException, ServiceException, IOException {
        ZMailbox mailbox = this.getMailbox();
        String pref = mailbox.getPrefs().getShortcuts();
        if (pref == null) {
            return null;
        }
        String seq = this.resolveMessageKey(ctxt, this.mMessage);
        if (seq == null || seq.indexOf("NNN") == -1) {
            return null;
        }
        List<NumericShortCut> shortCuts = BindKeyTag.getNumericShortCuts(pref);
        StringBuilder sb = new StringBuilder();
        String func = this.mFunc;
        for (NumericShortCut shortcut : shortCuts) {
            if (shortcut.getType() != NumericShortCutType.tag) continue;
            String msg = seq.replace("NNN", shortcut.getNumber());
            this.mFunc = func.replace("{TAGID}", shortcut.getId());
            String js = this.getJavaScriptForMessage(ctxt, msg, false);
            if (js == null) continue;
            sb.append(js);
        }
        return sb.toString();
    }

    private String generateFolderMoveAliases(JspContext ctxt) throws JspException, ServiceException, IOException {
        ZMailbox mailbox = this.getMailbox();
        String pref = mailbox.getPrefs().getShortcuts();
        if (pref == null) {
            return null;
        }
        String seq = this.resolveMessageKey(ctxt, this.mMessage);
        if (seq == null || seq.indexOf("NNN") == -1) {
            return null;
        }
        List<NumericShortCut> shortCuts = BindKeyTag.getNumericShortCuts(pref);
        StringBuilder sb = new StringBuilder();
        String func = this.mFunc;
        for (NumericShortCut shortcut : shortCuts) {
            if (shortcut.getType() != NumericShortCutType.folder) continue;
            String msg = seq.replace("NNN", shortcut.getNumber());
            this.mFunc = func.replace("{FOLDERID}", shortcut.getId());
            String js = this.getJavaScriptForMessage(ctxt, msg, false);
            if (js == null) continue;
            sb.append(js);
        }
        return sb.toString();
    }

    private String getJavaScriptForMessage(JspContext ctxt, String message, boolean resolve) throws JspTagException {
        String cacheKey;
        String js;
        Map<String, String> cache = (Map<String, String>)ctxt.getAttribute(BINDKEY_CACHE, 3);
        if (cache == null) {
            cache = Collections.synchronizedMap(new HashMap());
            ctxt.setAttribute(BINDKEY_CACHE, cache, 3);
        }
        if ((js = (String)cache.get(cacheKey = message + "/" + (this.mFunc != null ? this.mFunc : (this.mUrl != null ? this.mUrl : this.mId)))) == null) {
            String key;
            String string = key = resolve ? this.resolveMessageKey(ctxt, message) : message;
            if (key.startsWith("???")) {
                System.err.println("bindKey: unresolved prop: " + message);
                return null;
            }
            js = this.getJavaScriptForKey(key);
            cache.put(cacheKey, js);
        }
        return js;
    }

    private String getJavaScriptForKey(String k) throws JspTagException {
        StringBuilder js = new StringBuilder();
        if (k == null) {
            return "";
        }
        if ((k = k.trim()).length() == 0) {
            return "";
        }
        for (String keySeq : k.split(";")) {
            String[] keys = keySeq.trim().split(",");
            if (keys.length == 0) {
                throw new JspTagException("invalid key binding: " + k);
            }
            StringBuilder sb = new StringBuilder();
            for (String key : keys) {
                sb.append(':').append(this.getCode(key.trim()));
            }
            if (this.mFunc != null) {
                js.append(String.format("bindKey('%s', %s);%n", sb.toString(), this.mFunc));
                continue;
            }
            if (this.mUrl != null) {
                js.append(String.format("bindKey('%s', function(){ window.location=\"%s\";});%n", sb.toString(), this.mUrl));
                continue;
            }
            js.append(String.format("bindKey('%s', '%s');%n", sb.toString(), this.mId));
        }
        return js.toString();
    }

    private String getCode(String seq) throws JspTagException {
        String kc;
        StringBuilder code = new StringBuilder();
        if (seq.contains(ALT)) {
            code.append('a');
        }
        if (seq.contains(CTRL)) {
            code.append('c');
        }
        if (seq.contains(META)) {
            code.append('m');
        }
        if (seq.contains(SHIFT)) {
            code.append('s');
        }
        if ((kc = seq.substring(seq.lastIndexOf(43) + 1)) == null || kc == "") {
            throw new JspTagException("invalid key binding: " + seq);
        }
        code.append(kc);
        return code.toString();
    }

    public static List<NumericShortCut> getNumericShortCuts(String pref) {
        ArrayList<NumericShortCut> result = new ArrayList<NumericShortCut>();
        if (pref == null) {
            return result;
        }
        if (pref.indexOf(61) == -1) {
            for (String s : sSEP.split(pref)) {
                Matcher matcher = sSHORTCUT.matcher(s);
                if (!matcher.matches()) continue;
                String t = matcher.group(1);
                String id = matcher.group(2);
                String n = matcher.group(3);
                if (t.equals("T")) {
                    result.add(new NumericShortCut(NumericShortCutType.tag, n, id));
                    continue;
                }
                if (t.equals("S")) {
                    result.add(new NumericShortCut(NumericShortCutType.search, n, id));
                    continue;
                }
                if (!t.equals("F")) continue;
                result.add(new NumericShortCut(NumericShortCutType.folder, n, id));
            }
        } else {
            for (String s : sSEP.split(pref)) {
                Matcher matcher = sOLD_SHORTCUT.matcher(s);
                if (!matcher.matches()) continue;
                String t = matcher.group(1);
                String n = matcher.group(2);
                String id = matcher.group(3);
                if (t.equals("global.GoToTag")) {
                    result.add(new NumericShortCut(NumericShortCutType.tag, n, id));
                    continue;
                }
                if (t.equals("global.SavedSearch")) {
                    result.add(new NumericShortCut(NumericShortCutType.search, n, id));
                    continue;
                }
                if (!t.equals("mail.GoToFolder")) continue;
                result.add(new NumericShortCut(NumericShortCutType.folder, n, id));
            }
        }
        return result;
    }

    public static void main(String[] args) {
        List<NumericShortCut> result = BindKeyTag.getNumericShortCuts("global.GoToTag1.65=Y,1|global.GoToTag2.64=Y,2|global.SavedSearch99.283=S,9,9|global.Tag1.65=T,1|global.Tag2.64=T,2|mail.GoToFolder1.2=V,1|mail.GoToFolder3.5=V,3|mail.MoveToFolder1.2=.,1|mail.MoveToFolder1.2=Shift+.,1|mail.MoveToFolder3.5=.,3|mail.MoveToFolder3.5=Shift+.,3");
        for (NumericShortCut nsc : result) {
            System.out.println(nsc);
        }
        result = BindKeyTag.getNumericShortCuts("F,2,1|F,5,3|S,283,99|S,284,1|T,64,2|T,65,1");
        for (NumericShortCut nsc : result) {
            System.out.println(nsc);
        }
    }

    public static class NumericShortCut {
        private NumericShortCutType mType;
        private String mNumber;
        private String mId;

        public NumericShortCut(NumericShortCutType type, String number, String id) {
            this.mType = type;
            if (number.length() > 1) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < number.length(); ++i) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(number.charAt(i));
                }
                this.mNumber = sb.toString();
            } else {
                this.mNumber = number;
            }
            this.mId = id;
        }

        public NumericShortCutType getType() {
            return this.mType;
        }

        public String getNumber() {
            return this.mNumber;
        }

        public String getId() {
            return this.mId;
        }

        public String toString() {
            return String.format("{type=%s, id=%s, number=%s}", this.mType.name(), this.mId, this.mNumber);
        }
    }

    public static enum NumericShortCutType {
        search,
        folder,
        tag;

    }
}

