/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.ngxlookup;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ngxlookup.ZimbraNginxLookUpClient;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class NginxRouteLookUpConnector {
    private static ZimbraNginxLookUpClient sTheClient = new ZimbraNginxLookUpClient();

    public static ZimbraNginxLookUpClient getClient() {
        return sTheClient;
    }

    public static void startup() throws ServiceException {
        NginxRouteLookUpConnector.reloadConfig();
    }

    public static void reloadConfig() throws ServiceException {
        String[] lookUpServers = null;
        String[] upstreamMailServers = null;
        int connectTimeout = 15000;
        int retryTimeout = 60000;
        try {
            InitialContext initCtx = new InitialContext();
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            lookUpServers = ((String)envCtx.lookup("nginxLookUpHandlers")).split("\\s+");
            upstreamMailServers = ((String)envCtx.lookup("upstreamMailServers")).split("\\s+");
            connectTimeout = (Integer)envCtx.lookup("reverseProxyRouteLookupTimeout");
            retryTimeout = (Integer)envCtx.lookup("memcachedClientTimeout");
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sTheClient.setAttributes(lookUpServers, upstreamMailServers, connectTimeout, retryTimeout);
    }

    public static void shutdown() throws ServiceException {
        sTheClient = null;
    }
}

