/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.memcached;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.memcached.MemcachedKey;
import com.zimbra.common.util.memcached.MemcachedMap;
import com.zimbra.common.util.memcached.MemcachedSerializer;
import com.zimbra.common.util.memcached.ZimbraMemcachedClient;
import com.zimbra.cs.taglib.ZJspSession;
import com.zimbra.cs.taglib.memcached.MemcachedConnector;
import com.zimbra.cs.taglib.memcached.RouteCacheKey;

public class RouteCache {
    private static RouteCache sTheInstance = new RouteCache();
    private MemcachedMap<RouteCacheKey, String> mMemcachedLookup;

    public static RouteCache getInstance() {
        return sTheInstance;
    }

    RouteCache() {
        ZimbraMemcachedClient memcachedClient = MemcachedConnector.getClient();
        RouteSerializer serializer = new RouteSerializer();
        this.mMemcachedLookup = new MemcachedMap(memcachedClient, (MemcachedSerializer)serializer, false);
    }

    public String get(String accountId) throws ServiceException {
        RouteCacheKey key = new RouteCacheKey(ZJspSession.isProtocolModeHttps() ? "https" : "http", accountId);
        return (String)this.mMemcachedLookup.get((MemcachedKey)key);
    }

    public void put(String accountId, String route) throws ServiceException {
        RouteCacheKey key = new RouteCacheKey(ZJspSession.isProtocolModeHttps() ? "https" : "http", accountId);
        this.mMemcachedLookup.put((MemcachedKey)key, (Object)route);
    }

    private static class RouteSerializer
    implements MemcachedSerializer<String> {
        private RouteSerializer() {
        }

        public Object serialize(String value) {
            return value;
        }

        public String deserialize(Object obj) throws ServiceException {
            return (String)obj;
        }
    }
}

