/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.memcached;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.memcached.ZimbraMemcachedClient;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.spy.memcached.DefaultHashAlgorithm;

public class MemcachedConnector {
    private static ZimbraMemcachedClient sTheClient = new ZimbraMemcachedClient();

    public static ZimbraMemcachedClient getClient() {
        return sTheClient;
    }

    public static void startup() throws ServiceException {
        MemcachedConnector.reloadConfig();
    }

    public static boolean isConnected() {
        return sTheClient.isConnected();
    }

    public static void reloadConfig() throws ServiceException {
        String[] serverList = null;
        boolean useBinaryProtocol = false;
        String hashAlgorithm = DefaultHashAlgorithm.KETAMA_HASH.toString();
        int expirySeconds = 86400;
        long timeoutMillis = 10000L;
        try {
            InitialContext initCtx = new InitialContext();
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            serverList = ((String)envCtx.lookup("memcachedServers")).split("\\s+");
            useBinaryProtocol = (Boolean)envCtx.lookup("memcachedClientBinaryProtocolEnabled");
            hashAlgorithm = (String)envCtx.lookup("memcachedClientHashAlgorithm");
            expirySeconds = (Integer)envCtx.lookup("memcachedClientExpiry");
            timeoutMillis = ((Integer)envCtx.lookup("memcachedClientTimeout")).intValue();
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sTheClient.connect(serverList, useBinaryProtocol, hashAlgorithm, expirySeconds, timeoutMillis);
    }

    public static void shutdown() throws ServiceException {
        sTheClient.disconnect(30000L);
        sTheClient = null;
    }
}

