/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZUserAgentBean {
    private String mUserAgent;
    Version browserVersion = new Version("-1");
    Version mozVersion = new Version("-1");
    Version tridentVersion = new Version("-1");
    Version androidVersion = new Version("-1");
    Version iOsVersion = new Version("-1");
    boolean isOsMac = false;
    boolean isOsWindows = false;
    boolean isOsLinux = false;
    boolean isOsAndroid = false;
    boolean isOsBlackBerry = false;
    boolean isNav = false;
    boolean isIE = false;
    boolean isModernIE = false;
    boolean trueNs = false;
    boolean isFirefox = false;
    boolean isMozilla = false;
    boolean isSafari = false;
    boolean isChrome = false;
    boolean isGeckoBased = false;
    boolean isOpera = false;
    boolean isWebTv = false;
    boolean isHotJava = false;
    boolean isIPhone = false;
    boolean isIPod = false;
    boolean isTouchiPad = false;
    boolean isMobile = false;
    boolean isWindowsNT = false;
    boolean isWindowsPhone = false;
    boolean isEdge = false;
    @Deprecated
    boolean isIPad = false;

    public ZUserAgentBean(String userAgent) {
        this.mUserAgent = userAgent;
        if (this.mUserAgent != null) {
            this.parseUserAgent(userAgent);
        }
    }

    public String getUserAgent() {
        return this.mUserAgent;
    }

    private void parseUserAgent(String agent) {
        String agt = agent.toLowerCase();
        StringTokenizer agtArr = new StringTokenizer(agt, " ;()");
        int index = -1;
        boolean isSpoofer = false;
        double geckoDate = 0.0;
        boolean beginsWithMozilla = false;
        boolean isCompatible = false;
        boolean isTokenAndroid = false;
        boolean isTokenOS = false;
        if (agtArr.hasMoreTokens()) {
            String token = agtArr.nextToken();
            Pattern pattern = Pattern.compile("\\s*mozilla");
            Matcher mozilla = pattern.matcher(token);
            if (mozilla.find()) {
                index = mozilla.start();
                beginsWithMozilla = true;
                this.browserVersion = new Version(token.substring(index + 8));
                this.isNav = true;
            }
            do {
                if (token.indexOf("compatible") != -1) {
                    isCompatible = true;
                    this.isNav = false;
                    continue;
                }
                if (token.indexOf("opera") != -1) {
                    this.isOpera = true;
                    this.isNav = false;
                    index = token.indexOf("opera/");
                    if (index != -1) {
                        this.browserVersion = new Version(token.substring(index + 6));
                        continue;
                    }
                    if (!agtArr.hasMoreTokens()) continue;
                    this.browserVersion = new Version(agtArr.nextToken());
                    continue;
                }
                if (token.indexOf("spoofer") != -1) {
                    isSpoofer = true;
                    this.isNav = false;
                    continue;
                }
                if (token.indexOf("webtv") != -1) {
                    this.isWebTv = true;
                    this.isNav = false;
                    continue;
                }
                if (token.indexOf("iphone") != -1) {
                    this.isIPhone = true;
                    continue;
                }
                if (token.indexOf("ipad") != -1) {
                    this.isTouchiPad = true;
                    continue;
                }
                if (token.indexOf("ipod") != -1) {
                    this.isIPod = true;
                    continue;
                }
                if (token.indexOf("hotjava") != -1) {
                    this.isHotJava = true;
                    this.isNav = false;
                    continue;
                }
                index = token.indexOf("msie");
                if (index != -1) {
                    this.isIE = true;
                    if (!agtArr.hasMoreTokens()) continue;
                    this.browserVersion = new Version(agtArr.nextToken());
                    continue;
                }
                index = token.indexOf("trident/");
                if (index != -1) {
                    this.tridentVersion = new Version(token.substring(index + 8));
                    continue;
                }
                index = token.indexOf("gecko/");
                if (index != -1) {
                    this.isGeckoBased = true;
                    this.browserVersion = new Version(token.substring(index + 6));
                    continue;
                }
                index = token.indexOf("rv:");
                if (index != -1) {
                    this.mozVersion = new Version(token.substring(index + 3));
                    continue;
                }
                index = token.indexOf("firefox/");
                if (index != -1) {
                    this.isFirefox = true;
                    this.browserVersion = new Version(token.substring(index + 8));
                    continue;
                }
                index = token.indexOf("netscape6/");
                if (index != -1) {
                    this.trueNs = true;
                    this.browserVersion = new Version(token.substring(index + 10));
                    continue;
                }
                index = token.indexOf("netscape/");
                if (index != -1) {
                    this.trueNs = true;
                    this.browserVersion = new Version(token.substring(index + 9));
                    continue;
                }
                if (token.indexOf("safari/") != -1) {
                    this.isSafari = true;
                    continue;
                }
                index = token.indexOf("chrome/");
                if (index != -1) {
                    this.isChrome = true;
                    this.browserVersion = new Version(token.substring(index + 7));
                    continue;
                }
                if (token.indexOf("windows") != -1) {
                    this.isOsWindows = true;
                    continue;
                }
                if (token.indexOf("macintosh") != -1 || token.indexOf("mac_") != -1) {
                    this.isOsMac = true;
                    continue;
                }
                if (token.indexOf("linux") != -1) {
                    this.isOsLinux = true;
                    continue;
                }
                if (token.indexOf("android") != -1) {
                    this.isOsAndroid = true;
                    isTokenAndroid = true;
                    continue;
                }
                if (token.indexOf("blackberry") != -1 || token.startsWith("bb")) {
                    this.isOsBlackBerry = true;
                    continue;
                }
                index = token.indexOf("version/");
                if (index != -1) {
                    this.browserVersion = new Version(token.substring(index + 8));
                    continue;
                }
                if (token.indexOf("mobile") != -1) {
                    this.isMobile = true;
                    continue;
                }
                if (token.indexOf("touch") != -1 || token.indexOf("tablet") != -1) {
                    this.isMobile = true;
                    continue;
                }
                if (token.equals("os") && (this.isIPhone || this.isIPod || this.isTouchiPad)) {
                    isTokenOS = true;
                    continue;
                }
                if (isTokenAndroid && token.matches("^(\\d).*")) {
                    this.androidVersion = new Version(token);
                    isTokenAndroid = false;
                    continue;
                }
                if (isTokenOS && token.matches("^(\\d).*")) {
                    token = token.replaceAll("_", ".");
                    this.iOsVersion = new Version(token);
                    isTokenOS = false;
                    continue;
                }
                if (this.isOsWindows && token.equals("nt")) {
                    this.isWindowsNT = true;
                    continue;
                }
                if (this.isOsWindows && token.equals("phone")) {
                    this.isWindowsPhone = true;
                    this.isMobile = true;
                    continue;
                }
                if (!this.isOsWindows || token.indexOf("edge") == -1) continue;
                this.isEdge = true;
            } while ((token = agtArr.hasMoreTokens() ? agtArr.nextToken() : null) != null);
            this.isNav = beginsWithMozilla && !isSpoofer && !isCompatible && !this.isOpera && !this.isWebTv && !this.isHotJava && !this.isSafari && !this.isChrome;
            this.isIE = this.isIE && !this.isOpera;
            this.isModernIE = !this.isIE && this.tridentVersion.getMajor() >= 7 && this.mozVersion.getMajor() >= 11;
            this.isMozilla = this.isNav && this.mozVersion.getMajor() > -1 && this.isGeckoBased;
            boolean bl = this.isFirefox = this.isMozilla && this.isFirefox;
            if (this.isModernIE) {
                this.browserVersion = this.mozVersion;
            }
        }
    }

    public Version getBrowserVersion() {
        return this.browserVersion;
    }

    public boolean getIsOsWindows() {
        return this.isOsWindows;
    }

    public boolean getIsOsMac() {
        return this.isOsMac;
    }

    public boolean getIsOsLinux() {
        return this.isOsLinux;
    }

    public boolean getIsOsAndroid() {
        return this.isOsAndroid;
    }

    public boolean getIsIos() {
        return this.isIPhone || this.isIPod || this.isTouchiPad;
    }

    public boolean getIsOpera() {
        return this.isOpera;
    }

    public boolean getIsSafari() {
        return this.isSafari;
    }

    public boolean getIsChrome() {
        return this.isChrome;
    }

    public boolean getIsSafari3Up() {
        return this.isSafari && this.browserVersion.greaterOrEqual(3, 0) || this.isChrome;
    }

    public boolean getIsSafari4Up() {
        return this.isSafari && this.browserVersion.greaterOrEqual(4, 0);
    }

    public boolean getIsWebTv() {
        return this.isWebTv;
    }

    public boolean getIsNav() {
        return this.isNav;
    }

    public boolean getIsNav4() {
        return this.isNav && this.browserVersion.getMajor() == 4 && !this.isIE;
    }

    public boolean getIsNav6() {
        return this.isNav && this.trueNs && this.browserVersion.getMajor() >= 6 && this.browserVersion.getMajor() < 7;
    }

    public boolean getIsNav6up() {
        return this.isNav && this.trueNs && this.browserVersion.getMajor() >= 6;
    }

    public boolean getIsNav7() {
        return this.isNav && this.trueNs && this.browserVersion.getMajor() == 7;
    }

    public boolean getIsIE() {
        return this.isIE;
    }

    public boolean getIsIE3() {
        return this.isIE && this.browserVersion.getMajor() < 4;
    }

    public boolean getIsIE4() {
        return this.isIE && this.browserVersion.equals(4, 0);
    }

    public boolean getIsIE4up() {
        return this.isIE && this.browserVersion.getMajor() >= 4;
    }

    public boolean getIsIE5() {
        return this.isIE && this.browserVersion.equals(5, 0);
    }

    public boolean getIsIE5_5() {
        return this.isIE && this.browserVersion.equals(5, 5);
    }

    public boolean getIsIE5up() {
        return this.isIE && this.browserVersion.getMajor() > 5;
    }

    public boolean getIsIE5_5up() {
        return this.isIE && this.browserVersion.greaterOrEqual(5, 5);
    }

    public boolean getIsIE6() {
        return this.isIE && this.browserVersion.equals(6, 0);
    }

    public boolean getIsIE6up() {
        return this.isIE && this.browserVersion.getMajor() >= 6;
    }

    public boolean getIsIE7() {
        return this.isIE && this.browserVersion.equals(7, 0);
    }

    public boolean getIsIE7up() {
        return this.isIE && this.browserVersion.greaterOrEqual(7, 0);
    }

    public boolean getIsIE8() {
        return this.isIE && this.browserVersion.equals(8, 0);
    }

    public boolean getIsIE8up() {
        return this.isIE && this.browserVersion.greaterOrEqual(8, 0);
    }

    public boolean getIsIE9() {
        return this.isIE && this.browserVersion.equals(9, 0);
    }

    public boolean getIsIE9up() {
        return this.isIE && this.browserVersion.greaterOrEqual(9, 0);
    }

    public boolean getIsIE10() {
        return this.isIE && this.browserVersion.equals(10, 0);
    }

    public boolean getIsIE10up() {
        return this.isIE && this.browserVersion.getMajor() >= 10;
    }

    public boolean getIsModernIE() {
        return this.isModernIE;
    }

    public boolean getIsMozilla() {
        return this.isMozilla;
    }

    public boolean getIsMozilla1_4up() {
        return this.isMozilla && this.mozVersion.greaterOrEqual(1, 4);
    }

    public boolean getIsFirefox() {
        return this.isFirefox;
    }

    public boolean getIsFirefox1up() {
        return this.isFirefox && this.browserVersion.greaterOrEqual(1, 0);
    }

    public boolean getIsFirefox1_5up() {
        return this.isFirefox && this.browserVersion.greaterOrEqual(1, 5);
    }

    public boolean getIsFirefox2up() {
        return this.isFirefox && this.browserVersion.greaterOrEqual(2, 0);
    }

    public boolean getIsFirefox3up() {
        return this.isFirefox && this.browserVersion.greaterOrEqual(3, 0);
    }

    public boolean getIsGecko1_9up() {
        return this.isGeckoBased && this.mozVersion.greaterOrEqual(1, 9);
    }

    public boolean getIsGecko() {
        return this.isGeckoBased;
    }

    public boolean getIsHotJava() {
        return this.isHotJava;
    }

    public boolean getIsiPhone() {
        return this.isIPhone;
    }

    public boolean getIsiPod() {
        return this.isIPod;
    }

    public boolean getIsOsBlackBerry() {
        return this.isOsBlackBerry;
    }

    public boolean getIsAndroid4_0up() {
        return this.isOsAndroid && this.androidVersion.greaterOrEqual(4, 0);
    }

    public boolean getIsIos6_0up() {
        return (this.isIPhone || this.isIPod || this.isTouchiPad) && this.iOsVersion.greaterOrEqual(6, 0);
    }

    @Deprecated
    public boolean getIsiPad() {
        return this.isIPad;
    }

    public boolean getIsTouchiPad() {
        return this.isTouchiPad;
    }

    public boolean getIsMobile() {
        return this.isMobile;
    }

    public boolean getIsWindowsNT() {
        return this.isWindowsNT;
    }

    public boolean getIsWindowsPhone() {
        return this.isWindowsPhone;
    }

    public boolean getIsEdge() {
        return this.isEdge;
    }

    public static class Version {
        private String mRawVersion;
        private String mVersion;
        private int mMajor = -1;
        private int mMinor = 0;

        public Version(String v) {
            this.mRawVersion = v;
            if (v == null || v.length() == 0) {
                return;
            }
            int d1 = (v = v.replaceAll("[^0-9\\.].*", "")).indexOf(46);
            if (d1 != -1) {
                this.mMajor = this.parseInt(v.substring(0, d1), -1);
                int d2 = v.indexOf(46, d1 + 1);
                this.mMinor = d2 != -1 ? this.parseInt(v.substring(d1 + 1, d2), 0) : this.parseInt(v.substring(d1 + 1), 0);
            } else {
                this.mMajor = this.parseInt(v, -1);
            }
            this.mVersion = this.mMajor + "." + this.mMinor;
        }

        private int parseInt(String s, int defaultVal) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return defaultVal;
            }
        }

        public boolean equals(int major, int minor) {
            return this.mMajor == major && this.mMinor == minor;
        }

        public boolean greaterOrEqual(int major, int minor) {
            return this.mMajor > major || this.mMajor == major && this.mMinor >= minor;
        }

        public String getRawVersion() {
            return this.mRawVersion;
        }

        public String getVersion() {
            return this.mVersion;
        }

        public int getMajor() {
            return this.mMajor;
        }

        public int getMinor() {
            return this.mMinor;
        }

        public String toString() {
            return this.mRawVersion;
        }
    }
}

