/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.client.ZAppointmentHit;
import com.zimbra.client.ZCallHit;
import com.zimbra.client.ZContactHit;
import com.zimbra.client.ZConversationHit;
import com.zimbra.client.ZDocumentHit;
import com.zimbra.client.ZMessageHit;
import com.zimbra.client.ZSearchHit;
import com.zimbra.client.ZSearchParams;
import com.zimbra.client.ZSearchResult;
import com.zimbra.client.ZTaskHit;
import com.zimbra.client.ZVoiceMailItemHit;
import com.zimbra.client.ZWikiHit;
import com.zimbra.cs.taglib.bean.ZAppointmentHitBean;
import com.zimbra.cs.taglib.bean.ZCallHitBean;
import com.zimbra.cs.taglib.bean.ZContactHitBean;
import com.zimbra.cs.taglib.bean.ZConversationHitBean;
import com.zimbra.cs.taglib.bean.ZDocumentHitBean;
import com.zimbra.cs.taglib.bean.ZMessageBean;
import com.zimbra.cs.taglib.bean.ZMessageHitBean;
import com.zimbra.cs.taglib.bean.ZSearchHitBean;
import com.zimbra.cs.taglib.bean.ZTaskHitBean;
import com.zimbra.cs.taglib.bean.ZVoiceMailItemHitBean;
import com.zimbra.cs.taglib.bean.ZWikiHitBean;
import java.util.ArrayList;
import java.util.List;

public class ZSearchResultBean {
    private ZSearchResult mResult;
    private ArrayList<ZSearchHitBean> mHits;
    private int mLimit;
    private int mOffset;
    private int mPrevOffset;
    private int mNextOffset;

    public ZSearchResultBean(ZSearchResult result, ZSearchParams params) {
        this.mResult = result;
        this.mLimit = params.getLimit();
        this.mOffset = params.getOffset();
        this.mPrevOffset = this.mLimit > this.mOffset ? 0 : this.mOffset - this.mLimit;
        this.mNextOffset = this.mOffset + this.mLimit;
    }

    public int getSize() {
        return this.mResult.getHits().size();
    }

    public ZSearchResult.ZConversationSummary getConversationSummary() {
        return this.mResult.getConversationSummary();
    }

    public synchronized ZMessageBean getFetchedMessage() {
        for (ZSearchHitBean hit : this.getHits()) {
            ZMessageBean msg;
            if (!hit.getIsMessage() || (msg = hit.getMessageHit().getMessage()) == null) continue;
            return msg;
        }
        return null;
    }

    public synchronized int getFetchedMessageIndex() {
        int i = 0;
        for (ZSearchHitBean hit : this.getHits()) {
            ZMessageBean msg;
            if (hit.getIsMessage() && (msg = hit.getMessageHit().getMessage()) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized List<ZSearchHitBean> getHits() {
        if (this.mHits == null) {
            this.mHits = new ArrayList();
            for (ZSearchHit hit : this.mResult.getHits()) {
                if (hit instanceof ZConversationHit) {
                    this.mHits.add(new ZConversationHitBean((ZConversationHit)hit));
                    continue;
                }
                if (hit instanceof ZMessageHit) {
                    this.mHits.add(new ZMessageHitBean((ZMessageHit)hit));
                    continue;
                }
                if (hit instanceof ZContactHit) {
                    this.mHits.add(new ZContactHitBean((ZContactHit)hit));
                    continue;
                }
                if (hit instanceof ZVoiceMailItemHit) {
                    this.mHits.add(new ZVoiceMailItemHitBean((ZVoiceMailItemHit)hit));
                    continue;
                }
                if (hit instanceof ZCallHit) {
                    this.mHits.add(new ZCallHitBean((ZCallHit)hit));
                    continue;
                }
                if (hit instanceof ZTaskHit) {
                    this.mHits.add(new ZTaskHitBean((ZTaskHit)hit));
                    continue;
                }
                if (hit instanceof ZDocumentHit) {
                    this.mHits.add(new ZDocumentHitBean((ZDocumentHit)hit));
                    continue;
                }
                if (hit instanceof ZAppointmentHit) {
                    this.mHits.add(new ZAppointmentHitBean((ZAppointmentHit)hit));
                    continue;
                }
                if (!(hit instanceof ZWikiHit)) continue;
                this.mHits.add(new ZWikiHitBean((ZWikiHit)hit));
            }
        }
        return this.mHits;
    }

    public boolean getHasMore() {
        return this.mResult.hasMore();
    }

    public boolean getHasNextPage() {
        return this.mResult.hasMore();
    }

    public boolean getHasPrevPage() {
        return this.mOffset > 0;
    }

    public String getSortBy() {
        return this.mResult.getSortBy();
    }

    public int getOffset() {
        return this.mOffset;
    }

    public int getPrevOffset() {
        return this.mPrevOffset;
    }

    public int getNextOffset() {
        return this.mNextOffset;
    }

    public int getLimit() {
        return this.mLimit;
    }
}

