/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.client.ZMessage;
import com.zimbra.cs.taglib.bean.BeanUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ZMimePartBean {
    public static final String CT_APP = "application";
    public static final String CT_APP_ADOBE_PDF = "application/pdf";
    public static final String CT_APP_ADOBE_PS = "application/postscript";
    public static final String CT_APP_APPLE_DOUBLE = "application/applefile";
    public static final String CT_APP_EXE = "application/exe";
    public static final String CT_APP_MS_DOWNLOAD = "application/x-msdownload";
    public static final String CT_APP_MS_EXCEL = "application/vnd.ms-excel";
    public static final String CT_APP_MS_PPT = "application/vnd.ms-powerpoint";
    public static final String CT_APP_MS_PROJECT = "application/vnd.ms-project";
    public static final String CT_APP_MS_TNEF = "application/ms-tnef";
    public static final String CT_APP_MS_TNEF2 = "application/vnd.ms-tnef";
    public static final String CT_APP_MS_VISIO = "application/vnd.visio";
    public static final String CT_APP_MS_WORD = "application/msword";
    public static final String CT_APP_OCTET_STREAM = "application/octet-stream";
    public static final String CT_APP_ZIP = "application/zip";
    public static final String CT_APP_ZIP2 = "application/x-zip-compressed";
    public static final String CT_AUDIO = "audio";
    public static final String CT_AUDIO_WAV = "audio/x-wav";
    public static final String CT_AUDIO_MP3 = "audio/mpeg";
    public static final String CT_IMG = "image";
    public static final String CT_IMG_GIF = "image/gif";
    public static final String CT_IMG_JPEG = "image/jpeg";
    public static final String CT_IMG_PNG = "image/png";
    public static final String CT_IMG_TIFF = "image/tiff";
    public static final String CT_MSG_RFC822 = "message/rfc822";
    public static final String CT_MULTI = "multipart";
    public static final String CT_MULTI_ALT = "multipart/alternative";
    public static final String CT_MULTI_MIXED = "multipart/mixed";
    public static final String CT_MULTI_RELATED = "multipart/related";
    public static final String CT_MULTI_APPLE_DBL = "multipart/appledouble";
    public static final String CT_TEXT = "text";
    public static final String CT_TEXT_RTF = "text/enriched";
    public static final String CT_TEXT_HTML = "text/html";
    public static final String CT_TEXT_CAL = "text/calendar";
    public static final String CT_TEXT_JAVA = "text/x-java";
    public static final String CT_TEXT_VCARD = "text/x-vcard";
    public static final String CT_TEXT_PLAIN = "text/plain";
    public static final String CT_TEXT_XML = "text/xml";
    public static final String CT_VIDEO = "video";
    public static final String CT_VIDEO_WMV = "video/x-ms-wmv";
    public static final String CT_XML_ZIMBRA_SHARE = "xml/x-zimbra-share";
    public static final String CT_PLAIN_TEXT = "plain/text";
    private static final Set<String> sIgnoredTypes = new HashSet<String>(Arrays.asList("application/applefile", "application/ms-tnef", "application/vnd.ms-tnef", "multipart/alternative", "multipart/mixed", "multipart/related", "multipart/appledouble"));
    private static final Map<String, String> sTypeToImage = new HashMap<String, String>();
    private ZMessage.ZMimePart mMimePart;

    public static boolean isIgnoredPArt(ZMessage.ZMimePart part) {
        if (part.getContentType().equalsIgnoreCase(CT_APP_APPLE_DOUBLE)) {
            if (part.getParent() != null) {
                return part.getParent().getContentType().equalsIgnoreCase(CT_MULTI_APPLE_DBL);
            }
            return false;
        }
        return sIgnoredTypes.contains(part.getContentType());
    }

    public ZMimePartBean(ZMessage.ZMimePart mimePart) {
        this.mMimePart = mimePart;
    }

    public ZMessage.ZMimePart getMimePart() {
        return this.mMimePart;
    }

    public String getPartName() {
        return this.mMimePart.getPartName();
    }

    public String getName() {
        return this.mMimePart.getName();
    }

    public String getContentType() {
        return this.mMimePart.getContentType();
    }

    public String getContentDisposition() {
        return this.mMimePart.getContentDisposition();
    }

    public String getFileName() {
        return this.mMimePart.getFileName();
    }

    public String getContentId() {
        return this.mMimePart.getContentId();
    }

    public String getContentLocation() {
        return this.mMimePart.getContentLocation();
    }

    public String getContentDescription() {
        return this.mMimePart.getContentDescription();
    }

    public String getContent() {
        return this.mMimePart.getContent();
    }

    public boolean isBody() {
        return this.mMimePart.isBody();
    }

    public List<ZMessage.ZMimePart> getChildren() {
        return this.mMimePart.getChildren();
    }

    public long getSize() {
        return this.mMimePart.getSize();
    }

    public String getTextContentAsHtml() {
        return BeanUtils.textToHtml(this.getContent());
    }

    public String getDisplayName() {
        return this.getName() != null ? this.getName() : this.getFileName();
    }

    public String getDisplaySize() {
        return BeanUtils.displaySize(null, this.getSize());
    }

    public boolean getIsImage() {
        return this.getContentType().toLowerCase().startsWith(CT_IMG);
    }

    public boolean getIsAudio() {
        return this.getContentType().toLowerCase().startsWith(CT_AUDIO);
    }

    public boolean getIsVideo() {
        return this.getContentType().toLowerCase().startsWith(CT_VIDEO);
    }

    public boolean getIsOctectStream() {
        return this.getContentType().equalsIgnoreCase(CT_APP_OCTET_STREAM);
    }

    public boolean getIsViewAsHtmlTarget() {
        return this.getContentType().toLowerCase().startsWith(CT_APP);
    }

    public boolean getIsMssage() {
        return this.getContentType().equalsIgnoreCase(CT_MSG_RFC822);
    }

    public boolean getIsMultipart() {
        return this.getContentType().toLowerCase().startsWith(CT_MULTI);
    }

    public boolean getIsApp() {
        return this.getContentType().toLowerCase().startsWith(CT_APP);
    }

    public boolean getIsTextPlain() {
        return this.getContentType().equalsIgnoreCase(CT_TEXT_PLAIN);
    }

    public boolean getIsTextHtml() {
        return this.getContentType().equalsIgnoreCase(CT_TEXT_HTML);
    }

    public String getImage() {
        int index;
        String ct = this.getContentType();
        String image = sTypeToImage.get(ct);
        if (image == null && (index = ct.indexOf(47)) != -1) {
            ct = ct.substring(0, index);
            image = sTypeToImage.get(ct);
        }
        if (image == null) {
            image = sTypeToImage.get(CT_APP_OCTET_STREAM);
        }
        return image;
    }

    public String toString() {
        return this.mMimePart.toString();
    }

    static {
        sTypeToImage.put(CT_APP, "zimbra/ImgExeDoc.png");
        sTypeToImage.put(CT_APP_ADOBE_PDF, "zimbra/ImgPDFDoc.png");
        sTypeToImage.put(CT_APP_ADOBE_PS, "zimbra/ImgGenericDoc.png");
        sTypeToImage.put(CT_APP_EXE, "zimbra/ImgExeDoc.png");
        sTypeToImage.put(CT_APP_MS_DOWNLOAD, "zimbra/ImgExeDoc.png");
        sTypeToImage.put(CT_APP_MS_EXCEL, "zimbra/ImgMSExcelDoc.png");
        sTypeToImage.put(CT_APP_MS_PPT, "zimbra/ImgMSPowerpointDoc.png");
        sTypeToImage.put(CT_APP_MS_PROJECT, "zimbra/ImgMSProjectDoc.png");
        sTypeToImage.put(CT_APP_MS_VISIO, "zimbra/ImgMSVisioDoc.png");
        sTypeToImage.put(CT_APP_MS_WORD, "zimbra/ImgMSWordDoc.png");
        sTypeToImage.put(CT_APP_OCTET_STREAM, "zimbra/ImgUnknownDoc.png");
        sTypeToImage.put(CT_APP_ZIP, "zimbra/ImgZipDoc.png");
        sTypeToImage.put(CT_APP_ZIP2, "zimbra/ImgZipDoc.png");
        sTypeToImage.put(CT_AUDIO, "zimbra/ImgAudioDoc.png");
        sTypeToImage.put(CT_VIDEO, "zimbra/ImgVideoDoc.png");
        sTypeToImage.put(CT_IMG, "zimbra/ImgImageDoc.png");
        sTypeToImage.put(CT_MSG_RFC822, "zimbra/ImgMessageDoc.png");
        sTypeToImage.put(CT_TEXT, "zimbra/ImgGenericDoc.png");
        sTypeToImage.put(CT_PLAIN_TEXT, "zimbra/ImgGenericDoc.png");
        sTypeToImage.put(CT_TEXT_HTML, "zimbra/ImgHtmlDoc.png");
    }
}

