/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.client.ZEmailAddress;
import com.zimbra.client.ZMessageHit;
import com.zimbra.client.ZSearchHit;
import com.zimbra.cs.taglib.bean.BeanUtils;
import com.zimbra.cs.taglib.bean.ZMessageBean;
import com.zimbra.cs.taglib.bean.ZSearchHitBean;
import java.util.Date;
import java.util.List;

public class ZMessageHitBean
extends ZSearchHitBean {
    private ZMessageHit mHit;

    public ZMessageHitBean(ZMessageHit hit) {
        super((ZSearchHit)hit, ZSearchHitBean.HitType.message);
        this.mHit = hit;
    }

    public String getFlags() {
        return this.mHit.getFlags();
    }

    public String getFolderId() {
        return this.mHit.getFolderId();
    }

    public long getSize() {
        return this.mHit.getSize();
    }

    public Date getDate() {
        return new Date(this.mHit.getDate());
    }

    public String getConversationId() {
        return this.mHit.getConversationId();
    }

    public boolean getIsInvite() {
        return this.mHit.getIsInvite();
    }

    public boolean getIsUnread() {
        return this.mHit.isUnread();
    }

    public boolean getIsFlagged() {
        return this.mHit.isFlagged();
    }

    public boolean getIsHighPriority() {
        return this.mHit.isHighPriority();
    }

    public boolean getIsLowPriority() {
        return this.mHit.isLowPriority();
    }

    public boolean getHasAttachment() {
        return this.mHit.hasAttachment();
    }

    public boolean getIsRepliedTo() {
        return this.mHit.isRepliedTo();
    }

    public boolean getIsSentByMe() {
        return this.mHit.isSentByMe();
    }

    public boolean getIsForwarded() {
        return this.mHit.isForwarded();
    }

    public boolean getIsDraft() {
        return this.mHit.isDraft();
    }

    public boolean getIsDeleted() {
        return this.mHit.isDeleted();
    }

    public boolean getIsNotificationSent() {
        return this.mHit.isNotificationSent();
    }

    public String getTagIds() {
        return this.mHit.getTagIds();
    }

    public String getSubject() {
        return this.mHit.getSubject();
    }

    public boolean getHasFlags() {
        return this.mHit.hasFlags();
    }

    public boolean getHasTags() {
        return this.mHit.hasTags();
    }

    public String getFragment() {
        return this.mHit.getFragment();
    }

    public ZEmailAddress getSender() {
        return this.mHit.getSender();
    }

    public String getDisplaySender() {
        return BeanUtils.getAddr(this.mHit.getSender());
    }

    public List<ZEmailAddress> getAddresses() {
        return this.mHit.getAddresses();
    }

    public String getDisplayAddresses() {
        return BeanUtils.getAddrs(this.mHit.getAddresses());
    }

    public boolean getContentMatched() {
        return this.mHit.getContentMatched();
    }

    public boolean getMessageMatched() {
        return this.mHit.getContentMatched() || this.mHit.getMimePartHits().size() > 0;
    }

    public ZMessageBean getMessage() {
        if (this.mHit.getMessage() != null) {
            return new ZMessageBean(this.mHit.getMessage());
        }
        return null;
    }

    public List<String> getMimePartHits() {
        return this.mHit.getMimePartHits();
    }

    public String getStatusImage() {
        if (this.getIsInvite()) {
            return "startup/ImgAppointment.png";
        }
        if (this.getIsUnread()) {
            return "startup/ImgMsgStatusUnread.png";
        }
        if (this.getIsDraft()) {
            return "startup/ImgMsgStatusDraft.png";
        }
        if (this.getIsRepliedTo()) {
            return "startup/ImgMsgStatusReply.png";
        }
        if (this.getIsForwarded()) {
            return "startup/ImgMsgStatusForward.png";
        }
        if (this.getIsSentByMe()) {
            return "startup/ImgMsgStatusSent.png";
        }
        return "startup/ImgMsgStatusRead.png";
    }

    public String getStatusImageAltKey() {
        if (this.getIsInvite()) {
            return "ALT_MSG_STATUS_APPT";
        }
        if (this.getIsUnread()) {
            return "ALT_MSG_STATUS_UNREAD";
        }
        if (this.getIsDraft()) {
            return "ALT_MSG_STATUS_DRAFT";
        }
        if (this.getIsRepliedTo()) {
            return "ALT_MSG_STATUS_REPLIEDTO";
        }
        if (this.getIsForwarded()) {
            return "ALT_MSG_STATUS_FORWARDED";
        }
        if (this.getIsSentByMe()) {
            return "ALT_MSG_STATUS_SENTBYME";
        }
        return "ALT_MSG_STATUS_READ";
    }
}

