/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.client.ZAlarm;
import com.zimbra.client.ZDateTime;
import com.zimbra.client.ZEmailAddress;
import com.zimbra.client.ZFolder;
import com.zimbra.client.ZIdentity;
import com.zimbra.client.ZInvite;
import com.zimbra.client.ZMailbox;
import com.zimbra.client.ZPrefs;
import com.zimbra.client.ZSignature;
import com.zimbra.client.ZSimpleRecurrence;
import com.zimbra.common.calendar.ParsedDuration;
import com.zimbra.common.calendar.TZIDMapper;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.BeanUtils;
import com.zimbra.cs.taglib.bean.ZFolderBean;
import com.zimbra.cs.taglib.bean.ZMessageBean;
import com.zimbra.cs.taglib.bean.ZMimePartBean;
import com.zimbra.cs.taglib.bean.ZTagLibException;
import com.zimbra.cs.taglib.tag.i18n.I18nUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;

public class ZMessageComposeBean {
    public static final String NOTES_SEPARATOR = "*~*~*~*~*~*~*~*~*~*";
    public static String RT_BASIC = "BASIC";
    public static String CRLF = "\r\n";
    private String mAttendees;
    private String mResources;
    private String mApptFolderId;
    private String mLocation;
    private String mTimeZone;
    private String mFreeBusyStatus;
    private boolean mAllDay;
    private String mStartDate;
    private long mStartHour;
    private long mStartMinute;
    private String mEndDate;
    private long mEndHour;
    private long mEndMinute;
    private String mInviteReplyVerb;
    private long mInviteReplyInst;
    private boolean mInviteReplyAllDay;
    private String mSendUID;
    private String mInviteId;
    private String mExceptionInviteId;
    private boolean mUseInstance;
    private long mInstanceStartTime;
    private long mInstanceDuration;
    private String mCompNum;
    private String mInstanceCompNum;
    private String mClassProp;
    private String mTaskStatus;
    private String mTaskPriority;
    private String mTaskPercentComplete;
    private String mDescription;
    private String mDescriptionHtml;
    private String mDecodedDescHtml;
    private String mOrigOrganizer;
    private String mRepeatBasicType;
    private String mRepeatType;
    private int mRepeatDailyInterval;
    private int mRepeatWeeklyByDay;
    private int mRepeatWeeklyInterval;
    private boolean mRepeatWeeklySun;
    private boolean mRepeatWeeklyMon;
    private boolean mRepeatWeeklyTue;
    private boolean mRepeatWeeklyWed;
    private boolean mRepeatWeeklyThu;
    private boolean mRepeatWeeklyFri;
    private boolean mRepeatWeeklySat;
    private int mRepeatMonthlyInterval;
    private int mRepeatMonthlyMonthDay;
    private int mRepeatMonthlyRelativeInterval;
    private int mRepeatMonthlyRelativeOrd;
    private int mRepeatMonthlyRelativeDay;
    private int mRepeatYearlyMonthDay;
    private int mRepeatYearlyMonth;
    private int mRepeatYearlyRelativeOrd;
    private int mRepeatYearlyRelativeDay;
    private int mRepeatYearlyRelativeMonth;
    private String mRepeatEndType;
    private int mRepeatEndCount;
    private String mRecurrenceIdZ;
    private String mRepeatEndDate;
    private String mDateFormat;
    private String mTo;
    private String mCc;
    private String mBcc;
    private String mFrom;
    private String mReplyTo;
    private String mReplyType;
    private String mSubject;
    private String mPriority;
    private String mContentType = "text/plain";
    private String mContent;
    private String mHtmlContent;
    private String mMessageId;
    private String mInReplyTo;
    private String mDraftId;
    private List<MessageAttachment> mMessageAttachments;
    private List<DocumentAttachment> mDocumentAttachments;
    private Map<String, String> mCheckedAttachmentNames = new HashMap<String, String>();
    private List<ZMimePartBean> mOriginalAttachments;
    private List<FileItem> mFileItems = new ArrayList<FileItem>();
    private String mUploadedAttachmentId;
    private String mReminder1;
    private String mReminder2;
    private String mReminderEmail;
    private String mReminderMobile;
    private boolean mSendReminderEmail;
    private boolean mSendReminderMobile;
    private boolean mSendReminderYIM;

    public ZMessageComposeBean(PageContext pageContext) {
        this.mMessageAttachments = new ArrayList<MessageAttachment>();
        this.mDocumentAttachments = new ArrayList<DocumentAttachment>();
        this.mOriginalAttachments = new ArrayList<ZMimePartBean>();
        this.mDateFormat = I18nUtil.getLocalizedMessage(pageContext, "CAL_APPT_EDIT_DATE_FORMAT");
    }

    public void setInviteReplyVerb(String verb) {
        this.mInviteReplyVerb = verb;
    }

    public String getInviteReplyVerb() {
        return this.mInviteReplyVerb;
    }

    public void setInviteReplyInst(long inst) {
        this.mInviteReplyInst = inst;
    }

    public long getInviteReplyInst() {
        return this.mInviteReplyInst;
    }

    public void setInviteReplyAllDay(boolean allDay) {
        this.mInviteReplyAllDay = allDay;
    }

    public boolean getInviteReplyAllDay() {
        return this.mInviteReplyAllDay;
    }

    public void setTo(String to) {
        this.mTo = to;
    }

    public String getTo() {
        return this.mTo;
    }

    public void setContent(String content) {
        this.mContent = content;
    }

    public String getContent() {
        return this.mContent;
    }

    public void setHtmlContent(String htmlContent) {
        this.mHtmlContent = htmlContent;
    }

    public String getHtmlContent() {
        return this.mHtmlContent;
    }

    public void setContenttype(String contentType) {
        this.mContentType = contentType;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public void setReplyType(String replyType) {
        this.mReplyType = replyType;
    }

    public String getReplyType() {
        return this.mReplyType;
    }

    public void setSubject(String subject) {
        this.mSubject = subject;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public void setPriority(String priority) {
        this.mPriority = priority;
    }

    public String getPriority() {
        return this.mPriority;
    }

    public void setInReplyTo(String inReplyTo) {
        this.mInReplyTo = inReplyTo;
    }

    public String getInReplyTo() {
        return this.mInReplyTo;
    }

    public void setFrom(String from) {
        this.mFrom = from;
    }

    public String getFrom() {
        return this.mFrom;
    }

    public void setBcc(String bcc) {
        this.mBcc = bcc;
    }

    public String getBcc() {
        return this.mBcc;
    }

    public void setCc(String cc) {
        this.mCc = cc;
    }

    public String getCc() {
        return this.mCc;
    }

    public void setApptFolderId(String id) {
        this.mApptFolderId = id;
    }

    public String getApptFolderId() {
        return this.mApptFolderId;
    }

    public void setAttendees(String attendees) {
        this.mAttendees = attendees;
    }

    public String getAttendees() {
        return this.mAttendees;
    }

    public void setResources(String resources) {
        this.mResources = resources;
    }

    public String getResources() {
        return this.mResources;
    }

    public void setLocation(String location) {
        this.mLocation = location;
    }

    public String getLocation() {
        return this.mLocation;
    }

    public void setOrigOrganizer(String organizer) {
        this.mOrigOrganizer = organizer;
    }

    public String getOrigOrganizer() {
        return this.mOrigOrganizer;
    }

    public void setTimeZone(String timeZone) {
        this.mTimeZone = timeZone;
    }

    public String getTimeZone() {
        if (this.mTimeZone == null || this.mTimeZone.length() == 0) {
            return TZIDMapper.canonicalize((String)TimeZone.getDefault().getID());
        }
        return this.mTimeZone;
    }

    public void setRecurrenceIdZ(String ridZ) {
        this.mRecurrenceIdZ = ridZ;
    }

    public String getRecurrenceIdZ() {
        return this.mRecurrenceIdZ;
    }

    public void setFreeBusyStatus(String freeBusyStatus) {
        this.mFreeBusyStatus = freeBusyStatus;
    }

    public String getFreeBusyStatus() {
        return this.mFreeBusyStatus;
    }

    public void setClassProp(String classProp) {
        this.mClassProp = classProp;
    }

    public String getClassProp() {
        return this.mClassProp;
    }

    public void setTaskPriority(String prio) {
        this.mTaskPriority = prio;
    }

    public String getTaskPriority() {
        return this.mTaskPriority;
    }

    public void setTaskStatus(String status) {
        this.mTaskStatus = status;
    }

    public String getTaskStatus() {
        return this.mTaskStatus;
    }

    public void setTaskPercentComplete(String per) {
        this.mTaskPercentComplete = per;
    }

    public String getTaskPercentComplete() {
        return this.mTaskPercentComplete;
    }

    public void setAllDay(boolean allDay) {
        this.mAllDay = allDay;
    }

    public boolean getAllDay() {
        return this.mAllDay;
    }

    public void setStartDate(String startDate) {
        this.mStartDate = startDate;
    }

    public String getStartDate() {
        return this.mStartDate;
    }

    public void setStartHour(long startHour) {
        this.mStartHour = startHour;
    }

    public long getStartHour() {
        return this.mStartHour;
    }

    public void setStartMinute(long startMinute) {
        this.mStartMinute = startMinute;
    }

    public long getStartMinute() {
        return this.mStartMinute;
    }

    public void setEndDate(String endDate) {
        this.mEndDate = endDate;
    }

    public String getEndDate() {
        return this.mEndDate;
    }

    public void setEndHour(long endHour) {
        this.mEndHour = endHour;
    }

    public long getEndHour() {
        return this.mEndHour;
    }

    public void setEndMinute(long endMinute) {
        this.mEndMinute = endMinute;
    }

    public long getEndMinute() {
        return this.mEndMinute;
    }

    public void setDateFormat(String dateFormat) {
        this.mDateFormat = dateFormat;
    }

    public String getDateFormat() {
        return this.mDateFormat;
    }

    public void setInviteId(String inviteId) {
        this.mInviteId = inviteId;
    }

    public String getInviteId() {
        return this.mInviteId;
    }

    public void setCompNum(String compNum) {
        this.mCompNum = compNum;
    }

    public String getCompNum() {
        return this.mCompNum;
    }

    public void setInstanceCompNum(String instCompNum) {
        this.mInstanceCompNum = instCompNum;
    }

    public String getInstanceCompNum() {
        return this.mInstanceCompNum;
    }

    public void setExceptionInviteId(String exceptionInviteId) {
        this.mExceptionInviteId = exceptionInviteId;
    }

    public String getExceptionInviteId() {
        return this.mExceptionInviteId;
    }

    public void setUseInstance(boolean useInstance) {
        this.mUseInstance = useInstance;
    }

    public boolean getUseInstance() {
        return this.mUseInstance;
    }

    public void setInstanceStartTime(long startTime) {
        this.mInstanceStartTime = startTime;
    }

    public long getInstanceStartTime() {
        return this.mInstanceStartTime;
    }

    public void setInstanceDuration(long duration) {
        this.mInstanceDuration = duration;
    }

    public long getInstanceDuration() {
        return this.mInstanceDuration;
    }

    public void setReplyTo(String replyTo) {
        this.mReplyTo = replyTo;
    }

    public String getReplyTo() {
        return this.mReplyTo;
    }

    public void setMessageId(String id) {
        this.mMessageId = id;
    }

    public String getMessageId() {
        return this.mMessageId;
    }

    public void setDraftId(String id) {
        this.mDraftId = id;
    }

    public String getDraftId() {
        return this.mDraftId;
    }

    public Map<String, String> getCheckedAttachmentNames() {
        return this.mCheckedAttachmentNames;
    }

    public void setCheckedAttachmentName(String name, String id) {
        this.mCheckedAttachmentNames.put(name, id);
    }

    public String getUploadedAttachment() {
        return this.mUploadedAttachmentId;
    }

    public void setUploadedAttachment(String id) {
        this.mUploadedAttachmentId = id;
    }

    public List<FileItem> getFileItems() {
        return this.mFileItems;
    }

    public void addFileItem(FileItem item) {
        this.mFileItems.add(item);
    }

    public boolean getHasFileItems() {
        return !this.mFileItems.isEmpty();
    }

    public void setOrignalAttachments(List<ZMimePartBean> attachments) {
        this.mOriginalAttachments = attachments;
    }

    public List<ZMimePartBean> getOriginalAttachments() {
        return this.mOriginalAttachments;
    }

    public void setMessageAttachments(List<MessageAttachment> attachments) {
        this.mMessageAttachments = attachments;
    }

    public List<MessageAttachment> getMessageAttachments() {
        return this.mMessageAttachments;
    }

    public void setDocumentAttachments(List<DocumentAttachment> attachments) {
        this.mDocumentAttachments = attachments;
    }

    public List<DocumentAttachment> getDocumentAttachments() {
        return this.mDocumentAttachments;
    }

    public String getRepeatBasicType() {
        return this.mRepeatBasicType;
    }

    public void setRepeatBasicType(String repeatBasicType) {
        this.mRepeatBasicType = repeatBasicType;
    }

    public String getRepeatType() {
        return this.mRepeatType;
    }

    public void setRepeatType(String repeatType) {
        this.mRepeatType = repeatType;
    }

    public int getRepeatDailyInterval() {
        return this.mRepeatDailyInterval;
    }

    public void setRepeatDailyInterval(int repeatDailyInterval) {
        this.mRepeatDailyInterval = repeatDailyInterval;
    }

    public int getRepeatWeeklyByDay() {
        return this.mRepeatWeeklyByDay;
    }

    public void setRepeatWeeklyByDay(int repeatWeeklyByDay) {
        this.mRepeatWeeklyByDay = repeatWeeklyByDay;
    }

    public int getRepeatWeeklyInterval() {
        return this.mRepeatWeeklyInterval;
    }

    public void setRepeatWeeklyInterval(int repeatWeeklyInterval) {
        this.mRepeatWeeklyInterval = repeatWeeklyInterval;
    }

    public boolean isRepeatWeeklySun() {
        return this.mRepeatWeeklySun;
    }

    public void setRepeatWeeklySun(boolean repeatWeeklySun) {
        this.mRepeatWeeklySun = repeatWeeklySun;
    }

    public boolean isRepeatWeeklyMon() {
        return this.mRepeatWeeklyMon;
    }

    public void setRepeatWeeklyMon(boolean repeatWeeklyMon) {
        this.mRepeatWeeklyMon = repeatWeeklyMon;
    }

    public boolean isRepeatWeeklyTue() {
        return this.mRepeatWeeklyTue;
    }

    public void setRepeatWeeklyTue(boolean repeatWeeklyTue) {
        this.mRepeatWeeklyTue = repeatWeeklyTue;
    }

    public boolean isRepeatWeeklyWed() {
        return this.mRepeatWeeklyWed;
    }

    public void setRepeatWeeklyWed(boolean repeatWeeklyWed) {
        this.mRepeatWeeklyWed = repeatWeeklyWed;
    }

    public boolean isRepeatWeeklyThu() {
        return this.mRepeatWeeklyThu;
    }

    public void setRepeatWeeklyThu(boolean repeatWeeklyThu) {
        this.mRepeatWeeklyThu = repeatWeeklyThu;
    }

    public boolean isRepeatWeeklyFri() {
        return this.mRepeatWeeklyFri;
    }

    public void setRepeatWeeklyFri(boolean repeatWeeklyFri) {
        this.mRepeatWeeklyFri = repeatWeeklyFri;
    }

    public boolean isRepeatWeeklySat() {
        return this.mRepeatWeeklySat;
    }

    public void setRepeatWeeklySat(boolean repeatWeeklySat) {
        this.mRepeatWeeklySat = repeatWeeklySat;
    }

    public int getRepeatMonthlyInterval() {
        return this.mRepeatMonthlyInterval;
    }

    public void setRepeatMonthlyInterval(int repeatMonthlyInterval) {
        this.mRepeatMonthlyInterval = repeatMonthlyInterval;
    }

    public int getRepeatMonthlyMonthDay() {
        return this.mRepeatMonthlyMonthDay;
    }

    public void setRepeatMonthlyMonthDay(int repeatMonthlyMonthDay) {
        this.mRepeatMonthlyMonthDay = repeatMonthlyMonthDay;
    }

    public int getRepeatMonthlyRelativeInterval() {
        return this.mRepeatMonthlyRelativeInterval;
    }

    public void setRepeatMonthlyRelativeInterval(int repeatMonthlyRelativeInterval) {
        this.mRepeatMonthlyRelativeInterval = repeatMonthlyRelativeInterval;
    }

    public int getRepeatMonthlyRelativeOrd() {
        return this.mRepeatMonthlyRelativeOrd;
    }

    public void setRepeatMonthlyRelativeOrd(int repeatMonthlyRelativeOrd) {
        this.mRepeatMonthlyRelativeOrd = repeatMonthlyRelativeOrd;
    }

    public int getRepeatMonthlyRelativeDay() {
        return this.mRepeatMonthlyRelativeDay;
    }

    public void setRepeatMonthlyRelativeDay(int repeatMonthlyRelativeDay) {
        this.mRepeatMonthlyRelativeDay = repeatMonthlyRelativeDay;
    }

    public int getRepeatYearlyMonthDay() {
        return this.mRepeatYearlyMonthDay;
    }

    public void setRepeatYearlyMonthDay(int repeatYearlyMonthDay) {
        this.mRepeatYearlyMonthDay = repeatYearlyMonthDay;
    }

    public int getRepeatYearlyMonth() {
        return this.mRepeatYearlyMonth;
    }

    public void setRepeatYearlyMonth(int repeatYearlyMonth) {
        this.mRepeatYearlyMonth = repeatYearlyMonth;
    }

    public int getRepeatYearlyRelativeOrd() {
        return this.mRepeatYearlyRelativeOrd;
    }

    public void setRepeatYearlyRelativeOrd(int repeatYearlyRelativeOrd) {
        this.mRepeatYearlyRelativeOrd = repeatYearlyRelativeOrd;
    }

    public int getRepeatYearlyRelativeDay() {
        return this.mRepeatYearlyRelativeDay;
    }

    public void setRepeatYearlyRelativeDay(int repeatYearlyRelativeDay) {
        this.mRepeatYearlyRelativeDay = repeatYearlyRelativeDay;
    }

    public int getRepeatYearlyRelativeMonth() {
        return this.mRepeatYearlyRelativeMonth;
    }

    public void setRepeatYearlyRelativeMonth(int repeatYearlyRelativeMonth) {
        this.mRepeatYearlyRelativeMonth = repeatYearlyRelativeMonth;
    }

    public String getRepeatEndType() {
        return this.mRepeatEndType;
    }

    public void setRepeatEndType(String repeatEndType) {
        this.mRepeatEndType = repeatEndType;
    }

    public int getRepeatEndCount() {
        return this.mRepeatEndCount;
    }

    public void setRepeatEndCount(int repeatEndCount) {
        this.mRepeatEndCount = repeatEndCount;
    }

    public String getRepeatEndDate() {
        return this.mRepeatEndDate;
    }

    public void setRepeatEndDate(String repeatEndDate) {
        this.mRepeatEndDate = repeatEndDate;
    }

    public String getSendUID() {
        return this.mSendUID;
    }

    public void setSendUID(String uid) {
        this.mSendUID = uid;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String desc) {
        this.mDescription = desc;
    }

    public String getDescriptionHtml() {
        return this.mDescriptionHtml;
    }

    public void setDescriptionHtml(String descHtml) {
        this.mDescriptionHtml = descHtml;
    }

    public String getDecodedDescHtml() {
        return this.mDecodedDescHtml;
    }

    public void setDecodedDescHtml(String descHtml) {
        this.mDecodedDescHtml = BeanUtils.htmlDecode(descHtml);
    }

    public String paramInit(HttpServletRequest req, String name, String defaultValue) {
        String value = req.getParameter(name);
        return value == null || value.length() == 0 ? defaultValue : value;
    }

    public String getReminder1() {
        return this.mReminder1;
    }

    public void setReminder1(String mReminder1) {
        this.mReminder1 = mReminder1 != null && mReminder1.length() == 0 ? null : mReminder1;
    }

    public String getReminder2() {
        return this.mReminder2;
    }

    public void setReminder2(String mReminder2) {
        this.mReminder2 = mReminder2 != null && mReminder2.length() == 0 ? null : mReminder2;
    }

    public String getReminderEmail() {
        return this.mReminderEmail;
    }

    public void setReminderEmail(String mReminderEmail) {
        this.mReminderEmail = mReminderEmail;
    }

    public boolean isSendReminderEmail() {
        return this.mSendReminderEmail;
    }

    public void setSendReminderEmail(boolean mSendReminderEmail) {
        this.mSendReminderEmail = mSendReminderEmail;
    }

    public String getReminderMobile() {
        return this.mReminderMobile;
    }

    public void setReminderMobile(String mReminderMobile) {
        this.mReminderMobile = mReminderMobile;
    }

    public boolean isSendReminderMobile() {
        return this.mSendReminderMobile;
    }

    public void setSendReminderMobile(boolean mSendReminderMobile) {
        this.mSendReminderMobile = mSendReminderMobile;
    }

    public boolean isSendReminderYIM() {
        return this.mSendReminderYIM;
    }

    public void setSendReminderYIM(boolean mSendReminderYIM) {
        this.mSendReminderYIM = mSendReminderYIM;
    }

    private ZEmailAddress getOrganizerEmailAddress(ZInvite inv) {
        ZInvite.ZOrganizer org;
        ZInvite.ZComponent appt;
        if (inv != null && (appt = inv.getComponent()) != null && (org = appt.getOrganizer()) != null) {
            return org.getEmailAddress();
        }
        return null;
    }

    public ZMessageComposeBean(Action action, ZMessageBean msg, ZMailbox mailbox, PageContext pc, AppointmentOptions options, Boolean isMobile) throws ServiceException {
        HttpServletRequest req = (HttpServletRequest)pc.getRequest();
        this.setDateFormat(I18nUtil.getLocalizedMessage(pc, "CAL_APPT_EDIT_DATE_FORMAT"));
        Set emailAddresses = mailbox.getAccountInfo(false).getEmailAddresses();
        List identities = mailbox.getAccountInfo(false).getIdentities();
        this.mSendUID = UUID.randomUUID().toString();
        if (msg != null) {
            this.setMessageId(msg.getId());
            ZMimePartBean body = msg.getBody();
            if (body != null) {
                this.setContenttype(body.getContentType());
            }
        }
        ZIdentity identity = action == Action.NEW ? this.defaultIdentity(identities) : this.computeIdentity(msg, identities);
        switch (action) {
            case INVITE_ACCEPT: 
            case INVITE_DECLINE: 
            case INVITE_TENTATIVE: 
            case REPLY: 
            case REPLY_ALL: {
                ZInvite.ZOrganizer org;
                ZInvite.ZComponent appt;
                ZInvite inv;
                if (msg == null) break;
                this.setSubject(ZMessageComposeBean.getReplySubject(msg.getSubject(), pc));
                ArrayList<ZEmailAddress> toAddressList = new ArrayList<ZEmailAddress>();
                HashSet<String> toAddressSet = new HashSet<String>();
                this.setTo(ZMessageComposeBean.getToAddress(msg.getEmailAddresses(), toAddressList, toAddressSet, emailAddresses));
                if (action == Action.REPLY_ALL) {
                    this.setCc(ZMessageComposeBean.getCcAddress(msg.getEmailAddresses(), toAddressSet, emailAddresses));
                    if (this.mTo == null || this.mTo.length() == 0) {
                        this.mTo = this.mCc;
                        this.mCc = null;
                    }
                } else if ((this.mTo == null || this.mTo.equals("") && (action == Action.INVITE_ACCEPT || action == Action.INVITE_DECLINE || action == Action.INVITE_TENTATIVE)) && (inv = msg.getInvite()) != null && (appt = inv.getComponent()) != null && (org = appt.getOrganizer()) != null) {
                    this.setTo(org.getEmailAddress().getFullAddressQuoted());
                }
                this.setInReplyTo(msg.getMessageIdHeader());
                this.setReplyType("r");
                break;
            }
            case FORWARD: {
                if (msg == null) break;
                this.setSubject(ZMessageComposeBean.getForwardSubject(msg.getSubject(), pc));
                this.setReplyType("w");
                break;
            }
            case RESEND: {
                if (msg == null) break;
                this.setSubject(msg.getSubject());
                this.setTo(msg.getDisplayTo());
                this.setCc(msg.getDisplayCc());
                this.addAttachments(msg, true);
                break;
            }
            case DRAFT: {
                if (msg == null) break;
                this.setSubject(msg.getSubject());
                this.setTo(msg.getDisplayTo());
                this.setCc(msg.getDisplayCc());
                this.setBcc(msg.getDisplayBcc());
                this.addAttachments(msg, true);
                if (msg.getInReplyTo() != null) {
                    this.setInReplyTo(msg.getInReplyTo());
                }
                if (msg.getReplyType() == null) break;
                this.setReplyType(msg.getReplyType());
                break;
            }
            case APPT_NEW: {
                this.doNewAppt(mailbox, pc, options);
                if (req.getParameter("body") != null) {
                    this.setContent(req.getParameter("body"));
                }
                return;
            }
            case APPT_EDIT: {
                ZMimePartBean body;
                this.doEditAppt(msg, mailbox, pc, options);
                this.addAttachments(msg, true);
                if (msg != null && (body = msg.getBody()) != null) {
                    String bodyContent = body.getContent();
                    int i = bodyContent.lastIndexOf(NOTES_SEPARATOR);
                    if (i > 0) {
                        i += NOTES_SEPARATOR.length();
                        for (int n = 0; n < 4 && i < bodyContent.length() && (bodyContent.charAt(i) == '\r' || bodyContent.charAt(i) == '\n'); ++i, ++n) {
                        }
                        bodyContent = bodyContent.substring(i);
                    }
                    this.setContent(bodyContent);
                }
                return;
            }
            case NEW: {
                this.setSubject(req.getParameter("subject"));
                this.setTo(req.getParameter("to"));
                this.setCc(req.getParameter("cc"));
                this.setBcc(req.getParameter("bcc"));
                break;
            }
        }
        if (action == Action.INVITE_ACCEPT || action == Action.INVITE_DECLINE || action == Action.INVITE_TENTATIVE) {
            switch (action) {
                case INVITE_ACCEPT: {
                    this.setInviteReplyVerb(ZMailbox.ReplyVerb.ACCEPT.name());
                    this.setContent(I18nUtil.getLocalizedMessage(pc, "defaultInviteReplyAcceptMessage"));
                    break;
                }
                case INVITE_DECLINE: {
                    this.setInviteReplyVerb(ZMailbox.ReplyVerb.DECLINE.name());
                    this.setContent(I18nUtil.getLocalizedMessage(pc, "defaultInviteReplyDeclineMessage"));
                    break;
                }
                case INVITE_TENTATIVE: {
                    this.setInviteReplyVerb(ZMailbox.ReplyVerb.TENTATIVE.name());
                    this.setContent(I18nUtil.getLocalizedMessage(pc, "defaultInviteReplyTentativeMessage"));
                }
            }
            this.setInviteReplyInst(this.getParamLong(req.getParameter("inviteReplyInst"), 0L));
            this.setInviteReplyAllDay("1".equals(req.getParameter("inviteReplyAllDay")));
            this.setCompNum(req.getParameter("compNum"));
            this.setInstanceCompNum(req.getParameter("instCompNum"));
        }
        if (identity == null) {
            return;
        }
        if (identity.getReplyToEnabled()) {
            this.setReplyTo(identity.getReplyToEmailAddress().getFullAddress());
        }
        this.setFrom(identity.getFromEmailAddress().getFullAddress());
        if (action == Action.RESEND || action == Action.DRAFT) {
            if (msg != null) {
                ZMimePartBean body = msg.getBody();
                this.setContent(body == null ? "" : body.getContent());
            }
            return;
        }
        ZSignature zsignature = mailbox.getAccountInfo(false).getSignature(identity.getSignatureId());
        String signature = zsignature != null ? zsignature.getValue() : null;
        boolean signatureTop = mailbox.getPrefs().getSignatureStyleTop();
        StringBuilder content = new StringBuilder();
        if (this.getContent() != null) {
            content.append(this.getContent());
        }
        String composeFormat = mailbox.getPrefs().getComposeFormat();
        Boolean isText = composeFormat.equals("text");
        if ((action == Action.REPLY || action == Action.REPLY_ALL || action == Action.INVITE_ACCEPT || action == Action.INVITE_DECLINE || action == Action.INVITE_TENTATIVE || action == Action.FORWARD) && mailbox.getPrefs().getForwardReplyInOriginalFormat() && this.getContentType() != null) {
            isText = this.getContentType().equals("text/plain");
        }
        if (isMobile.booleanValue()) {
            isText = true;
        }
        if (isText.booleanValue() && zsignature != null && zsignature.getType().equals("text/html")) {
            signature = BeanUtils.htmlDecode(signature);
        }
        if (signatureTop && signature != null && signature.length() > 0) {
            content.append("\n\n\n").append(signature);
        }
        if (action == Action.REPLY || action == Action.REPLY_ALL || action == Action.INVITE_ACCEPT || action == Action.INVITE_DECLINE || action == Action.INVITE_TENTATIVE) {
            this.replyInclude(msg, content, mailbox.getPrefs(), pc, isText);
        } else if (action == Action.FORWARD) {
            this.forwardInclude(msg, content, mailbox.getPrefs(), pc, isText);
        } else if (action == Action.NEW && req.getParameter("body") != null) {
            content.append(req.getParameter("body"));
        }
        if (!signatureTop && signature != null && signature.length() > 0) {
            if (content.length() == 0) {
                content.append("\n\n\n");
            }
            content.append("-- \n").append(signature);
        }
        this.setContent(content.toString());
    }

    public long getParamLong(String value, long defaultValue) {
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public ZSimpleRecurrence getSimpleRecurrence() throws ServiceException {
        ZSimpleRecurrence repeat = new ZSimpleRecurrence(null);
        if (this.getRepeatType() == null || this.getRepeatType().length() == 0) {
            return repeat;
        }
        boolean basic = RT_BASIC.equals(this.getRepeatType());
        ZSimpleRecurrence.ZSimpleRecurrenceType type = ZSimpleRecurrence.ZSimpleRecurrenceType.fromString((String)(basic ? this.getRepeatBasicType() : this.getRepeatType()));
        repeat.setType(type);
        if (basic) {
            repeat.setEnd(ZSimpleRecurrence.ZSimpleRecurrenceEnd.NEVER);
            return repeat;
        }
        repeat.setEnd(ZSimpleRecurrence.ZSimpleRecurrenceEnd.fromString((String)this.getRepeatEndType()));
        switch (repeat.getEnd()) {
            case NEVER: {
                break;
            }
            case COUNT: {
                repeat.setCount((long)this.getRepeatEndCount());
                break;
            }
            case UNTIL: {
                repeat.setUntilDate(new ZDateTime(this.getRepeatEndDateTime(), this.mTimeZone));
            }
        }
        switch (type) {
            case COMPLEX: {
                break;
            }
            case NONE: {
                break;
            }
            case DAILY: {
                break;
            }
            case DAILY_INTERVAL: {
                repeat.setDailyInterval(this.getRepeatDailyInterval());
                break;
            }
            case DAILY_WEEKDAY: {
                break;
            }
            case WEEKLY: {
                break;
            }
            case WEEKLY_BY_DAY: {
                repeat.setWeeklyByDay(ZInvite.ZWeekDay.fromOrdinal((int)this.getRepeatWeeklyByDay()));
                break;
            }
            case WEEKLY_CUSTOM: {
                repeat.setWeeklyInterval(this.getRepeatWeeklyInterval());
                ArrayList<ZInvite.ZWeekDay> weeklyDays = new ArrayList<ZInvite.ZWeekDay>();
                if (this.isRepeatWeeklySun()) {
                    weeklyDays.add(ZInvite.ZWeekDay.SU);
                }
                if (this.isRepeatWeeklyMon()) {
                    weeklyDays.add(ZInvite.ZWeekDay.MO);
                }
                if (this.isRepeatWeeklyTue()) {
                    weeklyDays.add(ZInvite.ZWeekDay.TU);
                }
                if (this.isRepeatWeeklyWed()) {
                    weeklyDays.add(ZInvite.ZWeekDay.WE);
                }
                if (this.isRepeatWeeklyThu()) {
                    weeklyDays.add(ZInvite.ZWeekDay.TH);
                }
                if (this.isRepeatWeeklyFri()) {
                    weeklyDays.add(ZInvite.ZWeekDay.FR);
                }
                if (this.isRepeatWeeklySat()) {
                    weeklyDays.add(ZInvite.ZWeekDay.SA);
                }
                repeat.setWeeklyIntervalDays(weeklyDays);
                break;
            }
            case MONTHLY: {
                break;
            }
            case MONTHLY_BY_MONTH_DAY: {
                repeat.setMonthlyInterval(this.getRepeatMonthlyInterval());
                repeat.setMonthlyMonthDay(this.getRepeatMonthlyMonthDay());
                break;
            }
            case MONTHLY_RELATIVE: {
                repeat.setMonthlyInterval(this.getRepeatMonthlyInterval());
                ZInvite.ZByDayWeekDay mday = new ZInvite.ZByDayWeekDay();
                mday.setDay(ZInvite.ZWeekDay.fromOrdinal((int)this.getRepeatWeeklyByDay()));
                mday.setWeekOrd(this.getRepeatMonthlyRelativeOrd());
                repeat.setMonthlyRelativeDay(mday);
                break;
            }
            case YEARLY: {
                break;
            }
            case YEARLY_BY_DATE: {
                repeat.setYearlyByDateMonth(this.getRepeatYearlyMonth());
                repeat.setYearlyByDateMonthDay(this.getRepeatYearlyMonthDay());
                break;
            }
            case YEARLY_RELATIVE: {
                repeat.setYearlyRelativeMonth(this.getRepeatYearlyRelativeMonth());
                ZInvite.ZByDayWeekDay yday = new ZInvite.ZByDayWeekDay();
                yday.setDay(ZInvite.ZWeekDay.fromOrdinal((int)this.getRepeatYearlyRelativeDay()));
                yday.setWeekOrd(this.getRepeatYearlyRelativeOrd());
                repeat.setYearlyRelativeDay(yday);
            }
        }
        return repeat;
    }

    public void initRepeat(ZSimpleRecurrence repeat, Date date, PageContext pc, ZMailbox mailbox) throws ServiceException {
        ZInvite.ZByDayWeekDay day;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.setRepeatDailyInterval(repeat.getDailyInterval() > 0 ? repeat.getDailyInterval() : 1);
        this.setRepeatWeeklyByDay(repeat.getWeeklyByDay() != null ? repeat.getWeeklyByDay().getOrdinal() : cal.get(7) - 1);
        this.setRepeatWeeklyInterval(repeat.getWeeklyInterval() > 0 ? repeat.getWeeklyInterval() : 1);
        if (repeat.getWeeklyIntervalDays() != null) {
            for (ZInvite.ZWeekDay day2 : repeat.getWeeklyIntervalDays()) {
                switch (day2) {
                    case SU: {
                        this.setRepeatWeeklySun(true);
                        break;
                    }
                    case MO: {
                        this.setRepeatWeeklyMon(true);
                        break;
                    }
                    case TU: {
                        this.setRepeatWeeklyTue(true);
                        break;
                    }
                    case WE: {
                        this.setRepeatWeeklyWed(true);
                        break;
                    }
                    case TH: {
                        this.setRepeatWeeklyThu(true);
                        break;
                    }
                    case FR: {
                        this.setRepeatWeeklyFri(true);
                        break;
                    }
                    case SA: {
                        this.setRepeatWeeklySat(true);
                    }
                }
            }
        }
        this.setRepeatMonthlyMonthDay(repeat.getMonthlyMonthDay() > 0 ? repeat.getMonthlyMonthDay() : cal.get(5));
        this.setRepeatMonthlyInterval(repeat.getMonthlyInterval() > 0 ? repeat.getMonthlyInterval() : 1);
        int dom = cal.get(5);
        int dayOrd = (dom - 1) / 7 + 1;
        if (dayOrd > 4) {
            dayOrd = -1;
        }
        this.setRepeatMonthlyRelativeOrd((day = repeat.getMonthlyRelativeDay()) == null ? dayOrd : day.getWeekOrd());
        this.setRepeatMonthlyRelativeDay(day == null ? cal.get(7) - 1 : day.getDay().getOrdinal());
        this.setRepeatMonthlyRelativeInterval(repeat.getMonthlyInterval() > 0 ? repeat.getMonthlyInterval() : 1);
        this.setRepeatYearlyMonth(repeat.getYearlyByDateMonth() != 0 ? repeat.getYearlyByDateMonth() : cal.get(2) + 1);
        this.setRepeatYearlyMonthDay(repeat.getYearlyByDateMonthDay() != 0 ? repeat.getYearlyByDateMonthDay() : cal.get(5));
        ZInvite.ZByDayWeekDay relDay = repeat.getYearlyRelativeDay();
        this.setRepeatYearlyRelativeOrd(relDay == null ? dayOrd : relDay.getWeekOrd());
        this.setRepeatYearlyRelativeDay(relDay == null ? cal.get(7) - 1 : relDay.getDay().getOrdinal());
        this.setRepeatYearlyRelativeMonth(repeat.getYearlyRelativeMonth() > 0 ? repeat.getYearlyRelativeMonth() : cal.get(2) + 1);
        this.setRepeatEndCount((int)(repeat.getCount() > 0L ? repeat.getCount() : 1L));
        Date endDate = repeat.getUntilDate() != null ? repeat.getUntilDate().getDate() : date;
        SimpleDateFormat df = new SimpleDateFormat(I18nUtil.getLocalizedMessage(pc, "CAL_APPT_EDIT_DATE_FORMAT"));
        df.setTimeZone(mailbox.getPrefs().getTimeZone());
        this.setRepeatEndDate(df.format(endDate));
        this.setRepeatEndType(repeat.getEnd().name());
        this.setRepeatType(repeat.getType().name());
        this.setRepeatBasicType(ZSimpleRecurrence.ZSimpleRecurrenceType.DAILY.name());
        if (repeat.getType().isNone()) {
            return;
        }
        ZSimpleRecurrence.ZSimpleRecurrenceType type = repeat.getType();
        if (type.isDaily() && repeat.getEnd() == ZSimpleRecurrence.ZSimpleRecurrenceEnd.NEVER || type.isWeekly() || type.isMonthly() || type.isYearly()) {
            this.setRepeatType(RT_BASIC);
            this.setRepeatBasicType(type.name());
        } else {
            this.setRepeatType(type.name());
        }
    }

    private void doNewAppt(ZMailbox mailbox, PageContext pc, AppointmentOptions options) throws ServiceException {
        HttpServletRequest req = (HttpServletRequest)pc.getRequest();
        this.setSubject(req.getParameter("subject"));
        this.setLocation(req.getParameter("location"));
        this.setAllDay("1".equals(req.getParameter("allDay")));
        this.setAttendees(req.getParameter("attendees"));
        this.setResources(req.getParameter("resources"));
        this.setFreeBusyStatus(this.paramInit(req, "freeBusyStatus", ZInvite.ZFreeBusyStatus.B.name()));
        this.setTimeZone(this.paramInit(req, "timeZone", mailbox.getPrefs().getTimeZoneId()));
        this.setApptFolderId("10");
        if (options.isTask()) {
            this.setApptFolderId("15");
            this.setTaskPercentComplete("0");
            this.setTaskPriority("5");
            this.setTaskStatus(ZInvite.ZStatus.NEED.name());
        }
        Calendar calendar = options.getDate() != null ? options.getDate() : BeanUtils.getCalendar(System.currentTimeMillis(), mailbox.getPrefs().getTimeZone());
        SimpleDateFormat df = new SimpleDateFormat(I18nUtil.getLocalizedMessage(pc, "CAL_APPT_EDIT_DATE_FORMAT"));
        df.setTimeZone(mailbox.getPrefs().getTimeZone());
        String dateStr = df.format(calendar.getTime());
        int hour = calendar.get(11);
        this.setStartDate(this.paramInit(req, "startDate", dateStr));
        this.setStartHour(Long.parseLong(this.paramInit(req, "startHour", Integer.toString(hour))));
        this.setStartMinute(Long.parseLong(this.paramInit(req, "startMinute", "0")));
        calendar.add(11, 1);
        dateStr = df.format(calendar.getTime());
        hour = calendar.get(11);
        this.setEndDate(this.paramInit(req, "endDate", dateStr));
        this.setEndHour(Long.parseLong(this.paramInit(req, "endHour", Integer.toString(hour))));
        this.setEndMinute(Long.parseLong(this.paramInit(req, "endMinute", "0")));
        this.initRepeat(new ZSimpleRecurrence(null), calendar.getTime(), pc, mailbox);
    }

    private void doEditAppt(ZMessageBean msg, ZMailbox mailbox, PageContext pc, AppointmentOptions options) throws ServiceException {
        Date startDate;
        TimeZone apptTz;
        String tz;
        HttpServletRequest req = (HttpServletRequest)pc.getRequest();
        ZInvite.ZComponent appt = msg.getInvite().getComponent();
        this.setUseInstance(options.isUseInstance());
        this.setInviteId(options.getInviteId());
        this.setExceptionInviteId(options.getExceptionInviteId());
        this.setInstanceDuration(options.getInstanceDuration());
        this.setInstanceStartTime(options.getInstanceStartTime());
        this.setApptFolderId(msg.getFolderId());
        this.setSubject(appt.getName());
        this.setLocation(appt.getLocation());
        this.setAllDay(appt.isAllDay());
        if (!appt.getAttendees().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            StringBuilder rs = new StringBuilder();
            for (ZInvite.ZAttendee attendee : appt.getAttendees()) {
                if (attendee.getCalendarUserType().isResource()) {
                    if (rs.length() > 0) {
                        rs.append(", ");
                    }
                    rs.append(attendee.getEmailAddress().getFullAddress());
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(attendee.getEmailAddress().getFullAddress());
            }
            this.setAttendees(sb.toString());
            this.setResources(rs.toString());
        }
        this.setClassProp(appt.getClassProp().name());
        SimpleDateFormat df = new SimpleDateFormat(I18nUtil.getLocalizedMessage(pc, "CAL_APPT_EDIT_DATE_FORMAT"));
        this.setRecurrenceIdZ(appt.getRecurrenceIdZ());
        if (options.isTask()) {
            this.setTaskPercentComplete(appt.getPercentCompleted());
            this.setTaskPriority(appt.getPriority());
            this.setTaskStatus(appt.getStatus().name());
            if (appt.getOrganizer() != null) {
                this.setOrigOrganizer(appt.getOrganizer().getAddress());
            }
            tz = appt.getStart() != null ? appt.getStart().getTimeZoneId() : null;
            this.setTimeZone(tz == null ? mailbox.getPrefs().getTimeZoneId() : TZIDMapper.canonicalize((String)tz));
            apptTz = TimeZone.getTimeZone(TZIDMapper.canonicalize((String)this.getTimeZone()));
            if (apptTz != null) {
                df.setTimeZone(apptTz);
            }
            if (appt.getStart() != null) {
                startDate = appt.getStart().getDate();
                this.setStartDate(this.paramInit(req, "startDate", df.format(startDate)));
            }
            if (appt.getEnd() != null) {
                Date endDate = appt.getEnd().getDate();
                this.setEndDate(this.paramInit(req, "endDate", df.format(endDate)));
            }
        } else {
            this.setFreeBusyStatus(appt.getFreeBusyStatus().name());
            String string = tz = appt.getStart() != null ? appt.getStart().getTimeZoneId() : null;
            this.setTimeZone(appt.isAllDay() ? mailbox.getPrefs().getTimeZoneId() : (tz == null ? tz : TZIDMapper.canonicalize((String)tz)));
            apptTz = TimeZone.getTimeZone(TZIDMapper.canonicalize((String)this.getTimeZone()));
            if (appt.isAllDay()) {
                ZDateTime et;
                ZDateTime st = appt.getStart();
                if (st != null && st.getHasNoTimeZone()) {
                    st.setTimeZoneId(apptTz.getID());
                }
                if ((et = appt.getEnd()) != null && et.getHasNoTimeZone()) {
                    et.setTimeZoneId(apptTz.getID());
                }
            }
            startDate = this.getUseInstance() ? new Date(this.getInstanceStartTime()) : (appt.getStart() == null ? null : appt.getStart().getDate());
            Calendar startCalendar = Calendar.getInstance(apptTz);
            if (startDate != null) {
                startCalendar.setTime(startDate);
            }
            df.setTimeZone(apptTz);
            if (startDate != null) {
                this.setStartDate(this.paramInit(req, "startDate", df.format(startDate)));
            }
            if (appt.isAllDay()) {
                this.setStartHour(0L);
                this.setStartMinute(0L);
            } else if (startDate != null) {
                this.setStartHour(startCalendar.get(11));
                this.setStartMinute(startCalendar.get(12));
            }
            Date endDate = this.getUseInstance() ? new Date(this.getInstanceStartTime() + this.getInstanceDuration()) : appt.getComputedEndDate();
            Calendar endCalendar = Calendar.getInstance(apptTz);
            endCalendar.setTime(endDate);
            if (this.getUseInstance() && appt.isAllDay()) {
                endCalendar.add(5, -1);
                endDate = endCalendar.getTime();
            }
            this.setEndDate(this.paramInit(req, "endDate", df.format(endDate)));
            if (appt.isAllDay()) {
                this.setEndHour(0L);
                this.setEndMinute(0L);
            } else {
                this.setEndHour(endCalendar.get(11));
                this.setEndMinute(endCalendar.get(12));
            }
            this.initRepeat(appt.getSimpleRecurrence(), startDate, pc, mailbox);
            this.initReminders(appt.getAlarms());
        }
        if (appt.getIsNoBlob()) {
            this.setDescription(appt.getDescription());
            this.setDescriptionHtml(appt.getDescriptionHtml());
            this.setDecodedDescHtml(BeanUtils.htmlDecode(appt.getDescriptionHtml()));
        }
    }

    private void initReminders(List<ZAlarm> alarms) {
        for (ZAlarm alarm : alarms) {
            ZAlarm.ZAction action = alarm.getAction();
            ParsedDuration trigger = alarm.getTriggerRelated();
            if (action.equals((Object)ZAlarm.ZAction.EMAIL)) {
                this.mReminderEmail = ((ZInvite.ZAttendee)alarm.getAttendees().get(0)).getAddress();
                this.mSendReminderEmail = true;
            } else if (action.equals((Object)ZAlarm.ZAction.X_YAHOO_CALENDAR_ACTION_IM)) {
                this.mSendReminderYIM = true;
            } else if (action.equals((Object)ZAlarm.ZAction.X_YAHOO_CALENDAR_ACTION_MOBILE)) {
                this.mReminderMobile = ((ZInvite.ZAttendee)alarm.getAttendees().get(0)).getAddress();
                this.mSendReminderMobile = true;
            }
            if (trigger == null) continue;
            String duration = trigger.toString();
            if (this.mReminder1 != null && this.mReminder2 != null) continue;
            if (this.mReminder1 == null) {
                this.mReminder1 = duration;
                continue;
            }
            if (this.mReminder1.equalsIgnoreCase(duration)) continue;
            this.mReminder2 = duration;
        }
    }

    private String getQuotedHeaders(ZMessageBean msg, PageContext pc) {
        String ccHdr;
        String toHdr;
        StringBuilder headers = new StringBuilder();
        String fromHdr = msg.getDisplayFrom();
        if (fromHdr != null) {
            headers.append(I18nUtil.getLocalizedMessage(pc, "ZM_HEADER_FROM")).append(": ").append(fromHdr).append(CRLF);
        }
        if ((toHdr = msg.getDisplayTo()) != null) {
            headers.append(I18nUtil.getLocalizedMessage(pc, "ZM_HEADER_TO")).append(": ").append(toHdr).append(CRLF);
        }
        if ((ccHdr = msg.getDisplayCc()) != null) {
            headers.append(I18nUtil.getLocalizedMessage(pc, "ZM_HEADER_CC")).append(": ").append(ccHdr).append(CRLF);
        }
        headers.append(I18nUtil.getLocalizedMessage(pc, "ZM_HEADER_SENT")).append(": ").append(msg.getDisplaySentDate()).append(CRLF);
        String subjectHdr = msg.getSubject();
        if (subjectHdr != null) {
            headers.append(I18nUtil.getLocalizedMessage(pc, "ZM_HEADER_SUBJECT")).append(": ").append(subjectHdr).append(CRLF);
        }
        return headers.toString();
    }

    private String getQuotedDisplay(ZMessageBean msg) {
        ZEmailAddress addr;
        String org = msg.getDisplayFrom();
        if (org == null && (addr = this.getOrganizerEmailAddress(msg.getInvite())) != null) {
            return addr.getFullAddressQuoted();
        }
        return org;
    }

    private void forwardInclude(ZMessageBean msg, StringBuilder content, ZPrefs prefs, PageContext pc, boolean isText) {
        if (prefs.getForwardIncludeAsAttachment()) {
            this.mMessageAttachments = new ArrayList<MessageAttachment>();
            this.mMessageAttachments.add(new MessageAttachment(msg.getId(), msg.getSubject()));
        } else if (prefs.getForwardIncludeBody()) {
            String bodyContent;
            content.append(CRLF).append(CRLF).append(I18nUtil.getLocalizedMessage(pc, "ZM_forwardedMessage")).append(CRLF);
            String qHdr = this.getQuotedHeaders(msg, pc);
            if (!isText) {
                qHdr = BeanUtils.htmlEncode(qHdr);
            }
            content.append(qHdr).append(CRLF);
            ZMimePartBean body = msg.getBody();
            String string = bodyContent = body == null ? "" : body.getContent();
            if (!isText && body != null && body.getIsTextPlain()) {
                bodyContent = BeanUtils.htmlEncode(bodyContent);
            }
            content.append(bodyContent);
            content.append(CRLF);
            this.addAttachments(msg, true);
        } else if (prefs.getForwardIncludeBodyWithPrefx()) {
            String org = this.getQuotedDisplay(msg);
            if (!isText) {
                org = BeanUtils.htmlEncode(this.getQuotedDisplay(msg));
            }
            content.append(CRLF).append(CRLF).append(I18nUtil.getLocalizedMessage(pc, "ZM_forwardPrefix", new Object[]{org})).append(CRLF);
            ZMimePartBean body = msg.getBody();
            Boolean cookBody = !isText && body != null && body.getIsTextPlain();
            content.append(this.getQuotedBody(msg, prefs, cookBody));
            content.append(CRLF);
            this.addAttachments(msg, true);
        }
    }

    private void replyInclude(ZMessageBean msg, StringBuilder content, ZPrefs prefs, PageContext pc, boolean isText) {
        if (!prefs.getReplyIncludeNone()) {
            if (prefs.getReplyIncludeBody()) {
                String bodyContent;
                content.append(CRLF).append(CRLF).append(I18nUtil.getLocalizedMessage(pc, "ZM_originalMessage")).append(CRLF);
                String qHdr = this.getQuotedHeaders(msg, pc);
                if (!isText) {
                    qHdr = BeanUtils.htmlEncode(qHdr);
                }
                content.append(qHdr).append(CRLF);
                ZMimePartBean body = msg.getBody();
                String string = bodyContent = body == null ? "" : body.getContent();
                if (!isText && body != null && body.getIsTextPlain()) {
                    bodyContent = BeanUtils.htmlEncode(bodyContent);
                }
                content.append(bodyContent);
                content.append(CRLF);
                this.addAttachments(msg, false);
            } else if (prefs.getReplyIncludeBodyWithPrefx()) {
                String org = this.getQuotedDisplay(msg);
                if (!isText) {
                    org = BeanUtils.htmlEncode(this.getQuotedDisplay(msg));
                }
                content.append(CRLF).append(CRLF).append(I18nUtil.getLocalizedMessage(pc, "ZM_replyPrefix", new Object[]{org})).append(CRLF);
                ZMimePartBean body = msg.getBody();
                Boolean cookBody = !isText && body != null && body.getIsTextPlain();
                content.append(this.getQuotedBody(msg, prefs, cookBody));
                content.append(CRLF);
                this.addAttachments(msg, false);
            } else if (!prefs.getReplyIncludeSmart() && prefs.getReplyIncludeAsAttachment()) {
                this.mMessageAttachments = new ArrayList<MessageAttachment>();
                this.mMessageAttachments.add(new MessageAttachment(msg.getId(), msg.getSubject()));
            }
        }
    }

    private void addAttachments(ZMessageBean msg, boolean checked) {
        List<ZMimePartBean> attachments = msg.getAttachments();
        this.setOrignalAttachments(attachments);
        if (checked) {
            for (ZMimePartBean part : attachments) {
                this.setCheckedAttachmentName(part.getPartName(), part.getContentId() == null || part.getContentId().equals("") ? "true" : part.getContentId());
            }
        }
    }

    private String getQuotedBody(ZMessageBean msg, ZPrefs prefs, Boolean cookBody) {
        if (msg == null) {
            return "";
        }
        String prefixChar = prefs.getForwardReplyPrefixChar();
        prefixChar = prefixChar == null ? "> " : prefixChar + " ";
        ZMimePartBean body = msg.getBody();
        return body == null ? "" : BeanUtils.prefixContent(cookBody != false ? BeanUtils.cook(body.getContent()) : body.getContent(), prefixChar);
    }

    private ZIdentity computeIdentity(ZMessageBean msg, List<ZIdentity> identities) {
        if (identities.size() == 1) {
            return identities.get(0);
        }
        if (msg == null) {
            return this.defaultIdentity(identities);
        }
        ArrayList<ZEmailAddress> addressList = new ArrayList<ZEmailAddress>();
        for (ZEmailAddress address : msg.getEmailAddresses()) {
            if (!"t".equals(address.getType()) && !"c".equals(address.getType())) continue;
            addressList.add(address);
        }
        String folderId = msg.getFolderId();
        for (ZIdentity identity : identities) {
            if (!identity.containsFolderId(folderId)) continue;
            return identity;
        }
        return this.defaultIdentity(identities);
    }

    private ZIdentity defaultIdentity(List<ZIdentity> identities) {
        if (identities.size() == 1) {
            return identities.get(0);
        }
        for (ZIdentity identity : identities) {
            if (!identity.getIsDefault()) continue;
            return identity;
        }
        return identities.get(0);
    }

    private static String getReplySubject(String subject, PageContext pc) {
        String REPLY_PREFIX = "Re:";
        if (subject == null) {
            subject = "";
        }
        if (subject.length() > 3 && subject.substring(0, 3).equalsIgnoreCase(REPLY_PREFIX)) {
            return subject;
        }
        return REPLY_PREFIX + " " + subject;
    }

    private static String getForwardSubject(String subject, PageContext pc) {
        String FORWARD_PREFIX = "Fwd:";
        if (subject == null) {
            subject = "";
        }
        if (subject.length() > 3 && subject.substring(0, 3).equalsIgnoreCase(FORWARD_PREFIX)) {
            return subject;
        }
        return FORWARD_PREFIX + " " + subject;
    }

    private static String getToAddress(List<ZEmailAddress> emailAddresses, List<ZEmailAddress> toAddressList, Set<String> toAddresses, Set<String> aliases) {
        for (ZEmailAddress address : emailAddresses) {
            if (!"r".equals(address.getType())) continue;
            if (aliases.contains(address.getAddress().toLowerCase())) {
                return "";
            }
            toAddresses.add(address.getAddress());
            toAddressList.add(address);
            return address.getFullAddress();
        }
        StringBuilder sb = new StringBuilder();
        ZEmailAddress selfAddress = null;
        for (ZEmailAddress address : emailAddresses) {
            if (!"f".equals(address.getType())) continue;
            if (!aliases.contains(address.getAddress().toLowerCase())) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(address.getFullAddress());
                toAddressList.add(address);
                toAddresses.add(address.getAddress());
                continue;
            }
            selfAddress = address;
        }
        if (sb.length() == 0 && selfAddress != null) {
            sb.append(selfAddress.getFullAddress());
            toAddressList.add(selfAddress);
            toAddresses.add(selfAddress.getAddress());
        }
        return sb.toString();
    }

    private static String getCcAddress(List<ZEmailAddress> emailAddresses, Set<String> toAddresses, Set<String> aliases) {
        StringBuilder sb = new StringBuilder();
        for (ZEmailAddress address : emailAddresses) {
            String a;
            if (!"t".equals(address.getType()) && !"c".equals(address.getType()) || toAddresses.contains(a = address.getAddress().toLowerCase()) || aliases.contains(a)) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(address.getFullAddress());
        }
        return sb.toString();
    }

    public List<ZEmailAddress> getAttendeesAddrs() throws ServiceException {
        if (this.mAttendees != null && this.mAttendees.length() > 0) {
            return ZEmailAddress.parseAddresses((String)this.mAttendees, (String)"t");
        }
        return null;
    }

    public List<ZEmailAddress> getResourcesAddrs() throws ServiceException {
        if (this.mResources != null && this.mResources.length() > 0) {
            return ZEmailAddress.parseAddresses((String)this.mResources, (String)"t");
        }
        return null;
    }

    public ZInvite toInvite(ZMailbox mailbox, ZMessageBean message) throws ServiceException {
        ZInvite inv = this.toInviteObject(mailbox, message, null);
        return inv;
    }

    public ZInvite toInviteObject(ZMailbox mailbox, ZMessageBean message, String apptFolderId) throws ServiceException {
        ZInvite.ZComponent ecomp;
        ZInvite.ZAttendee attendee;
        List addrs;
        ZFolderBean calFolderBean;
        ZFolder calFolder;
        ZInvite existingInvite = message != null ? message.getInvite() : null;
        this.setOrigOrganizer(existingInvite != null ? existingInvite.getComponent().getOrganizer().getAddress() : null);
        ZInvite invite = new ZInvite();
        ZInvite.ZComponent comp = new ZInvite.ZComponent();
        if (apptFolderId != null && (calFolder = mailbox.getFolderById(apptFolderId)) != null && (calFolderBean = new ZFolderBean(calFolder)).getIsMountPointWritable()) {
            this.setOrigOrganizer(calFolderBean.getOwnerDisplayName());
        }
        comp.setStatus(ZInvite.ZStatus.CONF);
        comp.setClassProp(this.getClassProp() != null ? ZInvite.ZClass.fromString((String)this.getClassProp()) : ZInvite.ZClass.PUB);
        if (this.getTaskPercentComplete() != null) {
            comp.setPercentCompleted(this.getTaskPercentComplete());
        }
        if (this.getTaskPriority() != null) {
            comp.setPriority(this.getTaskPriority());
        }
        if (this.getTaskStatus() != null) {
            comp.setStatus(ZInvite.ZStatus.fromString((String)this.getTaskStatus()));
        }
        comp.setTransparency(ZInvite.ZTransparency.O);
        if (this.mFreeBusyStatus != null) {
            comp.setFreeBusyStatus(ZInvite.ZFreeBusyStatus.fromString((String)this.mFreeBusyStatus));
        }
        if (this.mTimeZone == null || this.mTimeZone.length() == 0) {
            this.mTimeZone = mailbox.getPrefs().getTimeZoneCanonicalId();
        }
        if (this.getStartDate() != null && this.getStartDate().length() > 0) {
            comp.setStart(new ZDateTime(this.getApptStartTime(), this.mTimeZone));
        }
        if (this.getEndDate() != null && this.getEndDate().length() > 0) {
            comp.setEnd(new ZDateTime(this.getApptEndTime(), this.mTimeZone));
        }
        if (this.mLocation != null && this.mLocation.length() > 0) {
            comp.setLocation(this.mLocation);
        }
        comp.setName(this.mSubject);
        List identities = mailbox.getAccountInfo(false).getIdentities();
        String organizerEmail = null;
        for (ZIdentity i : identities) {
            if (!i.getIsDefault()) continue;
            organizerEmail = i.getFromAddress();
        }
        if (organizerEmail == null) {
            throw ServiceException.FAILURE((String)"Default identity not found", null);
        }
        String origOrganizer = this.getOrigOrganizer();
        if (origOrganizer == null || origOrganizer.length() == 0 || origOrganizer.equalsIgnoreCase(organizerEmail)) {
            comp.setOrganizer(new ZInvite.ZOrganizer(organizerEmail));
        } else {
            ZInvite.ZOrganizer zo = new ZInvite.ZOrganizer(origOrganizer);
            zo.setSentBy(organizerEmail);
            comp.setOrganizer(zo);
        }
        comp.setIsAllDay(this.getAllDay());
        if (this.mAttendees != null && this.mAttendees.length() > 0) {
            addrs = ZEmailAddress.parseAddresses((String)this.mAttendees, (String)"t");
            for (ZEmailAddress addr : addrs) {
                attendee = new ZInvite.ZAttendee();
                attendee.setAddress(addr.getAddress());
                attendee.setRole(ZInvite.ZRole.REQ);
                attendee.setParticipantStatus(ZInvite.ZParticipantStatus.NE);
                attendee.setRSVP(true);
                if (addr.getPersonal() != null) {
                    attendee.setPersonalName(addr.getPersonal());
                }
                comp.getAttendees().add(attendee);
            }
        }
        if (this.mResources != null && this.mResources.length() > 0) {
            addrs = ZEmailAddress.parseAddresses((String)this.mResources, (String)"t");
            for (ZEmailAddress addr : addrs) {
                attendee = new ZInvite.ZAttendee();
                attendee.setAddress(addr.getAddress());
                attendee.setRole(ZInvite.ZRole.NON);
                attendee.setCalendarUserType(ZInvite.ZCalendarUserType.RES);
                attendee.setParticipantStatus(ZInvite.ZParticipantStatus.NE);
                attendee.setRSVP(true);
                if (addr.getPersonal() != null) {
                    attendee.setPersonalName(addr.getPersonal());
                }
                comp.getAttendees().add(attendee);
            }
        }
        invite.getComponents().add(comp);
        ZInvite.ZComponent zComponent = ecomp = existingInvite != null ? existingInvite.getComponent() : null;
        if (!this.getUseInstance()) {
            ZSimpleRecurrence repeat = this.getSimpleRecurrence();
            switch (repeat.getType()) {
                case NONE: {
                    break;
                }
                case COMPLEX: {
                    if (ecomp == null) break;
                    comp.setRecurrence(ecomp.getRecurrence());
                    break;
                }
                default: {
                    comp.setRecurrence(repeat.getRecurrence());
                }
            }
        }
        if (ecomp != null) {
            comp.setSequenceNumber(ecomp.getSequenceNumber());
            comp.setTransparency(ecomp.getTransparency());
            if (this.getTaskStatus() == null) {
                comp.setStatus(ecomp.getStatus());
            }
        }
        if (this.getReminder1() != null && this.getReminder1().length() > 0) {
            this.toAlarm(comp, this.getReminder1());
        }
        if (this.getReminder2() != null && this.getReminder2().length() > 0) {
            this.toAlarm(comp, this.getReminder2());
        }
        return invite;
    }

    private void toAlarm(ZInvite.ZComponent comp, String remDuration) throws ServiceException {
        ZInvite.ZAttendee attendee;
        ZAlarm alarm;
        ParsedDuration dur = ParsedDuration.parse((String)remDuration);
        if (this.isSendReminderEmail()) {
            alarm = new ZAlarm();
            alarm.setTriggerRelative(dur);
            alarm.setSummary(this.getSubject());
            alarm.setDescription(this.getContent());
            alarm.setRepeatCount(0);
            alarm.setAction(ZAlarm.ZAction.EMAIL);
            attendee = new ZInvite.ZAttendee();
            attendee.setAddress(this.getReminderEmail());
            alarm.addAttendee(attendee);
            comp.getAlarms().add(alarm);
        }
        if (this.isSendReminderMobile()) {
            alarm = new ZAlarm();
            alarm.setTriggerRelative(dur);
            alarm.setSummary(this.getSubject());
            alarm.setDescription(this.getContent());
            alarm.setRepeatCount(0);
            alarm.setAction(ZAlarm.ZAction.X_YAHOO_CALENDAR_ACTION_MOBILE);
            attendee = new ZInvite.ZAttendee();
            attendee.setAddress(this.getReminderMobile());
            alarm.addAttendee(attendee);
            comp.getAlarms().add(alarm);
        }
        if (this.isSendReminderYIM()) {
            alarm = new ZAlarm();
            alarm.setTriggerRelative(dur);
            alarm.setSummary(this.getSubject());
            alarm.setDescription(this.getContent());
            alarm.setRepeatCount(0);
            alarm.setAction(ZAlarm.ZAction.X_YAHOO_CALENDAR_ACTION_IM);
            comp.getAlarms().add(alarm);
        }
    }

    public boolean getIsValidStartTime() {
        try {
            this.getApptStartTime();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean getIsValidEndTime() {
        try {
            this.getApptEndTime();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean getIsValidRepeatEndDateTime() {
        try {
            this.getRepeatEndDateTime();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getRepeatEndDateTime() throws ZTagLibException {
        return this.getICalTime(this.mRepeatEndDate, 0L, 0L);
    }

    public String getApptStartTime() throws ZTagLibException {
        return this.getICalTime(this.mStartDate, this.mStartHour, this.mStartMinute);
    }

    public Calendar getApptStartCalendar() {
        try {
            return this.getCalendar(this.mStartDate, this.mStartHour, this.mStartMinute);
        }
        catch (ZTagLibException e) {
            return null;
        }
    }

    public Calendar getApptEndCalendar() {
        try {
            return this.getCalendar(this.mEndDate, this.mEndHour, this.mEndMinute);
        }
        catch (ZTagLibException e) {
            return null;
        }
    }

    public String getApptEndTime() throws ZTagLibException {
        return this.getICalTime(this.mEndDate, this.mEndHour, this.mEndMinute);
    }

    private String getICalTime(String dateStr, long hour, long minute) throws ZTagLibException {
        SimpleDateFormat icalFmt = new SimpleDateFormat(this.getAllDay() ? "yyyyMMdd" : "yyyyMMdd'T'HHmmss");
        return icalFmt.format(this.getCalendar(dateStr, hour, minute).getTime());
    }

    private Calendar getCalendar(String dateStr, long hour, long minute) throws ZTagLibException {
        try {
            if (dateStr == null) {
                throw ZTagLibException.INVALID_APPT_DATE("date field is empty", null);
            }
            SimpleDateFormat df = new SimpleDateFormat(this.mDateFormat);
            df.setLenient(false);
            ParsePosition pos = new ParsePosition(0);
            Date date = ((DateFormat)df).parse(dateStr, pos);
            if (pos.getIndex() != dateStr.length()) {
                throw ZTagLibException.INVALID_APPT_DATE("invalid date: " + dateStr, null);
            }
            if (hour < 0L || hour > 23L) {
                throw ZTagLibException.INVALID_APPT_DATE("invalid hour: " + hour, null);
            }
            if (minute < 0L || minute > 59L) {
                throw ZTagLibException.INVALID_APPT_DATE("invalid minute: " + minute, null);
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, (int)hour);
            cal.set(12, (int)minute);
            cal.set(13, 0);
            cal.set(14, 0);
            int year = cal.get(1);
            if (year < 100) {
                cal.set(1, 2000 + year);
            }
            if (year < 1900) {
                throw ZTagLibException.INVALID_APPT_DATE("invalid year: " + year, null);
            }
            return cal;
        }
        catch (Exception e) {
            throw ZTagLibException.INVALID_APPT_DATE(dateStr, e);
        }
    }

    public void setInviteBlurb(ZMailbox mailbox, PageContext pc, ZInvite newInvite, ZInvite previousInvite, String blurbHeaderKey) throws ServiceException {
        String content = this.getContent();
        if (content == null) {
            content = "";
        }
        String blurb = this.generateInviteBlurb(mailbox, pc, newInvite, previousInvite, blurbHeaderKey, false);
        this.setContent(blurb + content);
        String htmlBlurb = this.generateInviteBlurb(mailbox, pc, newInvite, previousInvite, blurbHeaderKey, true);
        this.setHtmlContent("<html><body>" + htmlBlurb + BeanUtils.textToHtml(content) + "</body></html>");
    }

    private void addLine(StringBuilder sb, String a, String b, String c, boolean html, String tzId) {
        if (html) {
            sb.append("<tr><th valign='top' align='left'>").append(a).append(":</th><td>");
            sb.append(BeanUtils.htmlEncode(b));
            if (tzId != null) {
                sb.append(" <span style='color: #686357'>").append(tzId).append("</span>");
            }
            if (c != null) {
                sb.append(' ').append(c);
            }
            sb.append("</td></tr>");
        } else {
            sb.append(a).append(": ").append(b);
            if (tzId != null) {
                sb.append(" ").append(tzId);
            }
            if (c != null) {
                sb.append(' ').append(c);
            }
        }
    }

    private static String msg(PageContext pc, String key) {
        return I18nUtil.getLocalizedMessage(pc, key);
    }

    private String generateInviteBlurb(ZMailbox mailbox, PageContext pc, ZInvite newInvite, ZInvite previousInvite, String blurbHeaderKey, boolean html) throws ServiceException {
        List attendees;
        boolean diffRepeat;
        String oldLoc;
        ZInvite.ZComponent oldAppt;
        String mod = ZMessageComposeBean.msg(pc, "apptModifiedStamp");
        TimeZone tz = mailbox.getPrefs().getTimeZone();
        String tzId = mailbox.getPrefs().getTimeZoneCanonicalId();
        StringBuilder sb = new StringBuilder();
        ZInvite.ZComponent appt = newInvite.getComponent();
        ZInvite.ZComponent zComponent = oldAppt = previousInvite == null ? null : previousInvite.getComponent();
        if (html) {
            sb.append("<h3>");
        }
        sb.append(I18nUtil.getLocalizedMessage(pc, blurbHeaderKey));
        if (html) {
            sb.append("</h3>");
        }
        sb.append("\n\n");
        if (html) {
            sb.append("<p>\n<table border='0'>\n");
        }
        String name = appt.getName();
        String oldName = oldAppt == null ? null : oldAppt.getName();
        this.addLine(sb, ZMessageComposeBean.msg(pc, "subject"), name, oldAppt != null && !name.equals(oldName) ? mod : null, html, null);
        sb.append("\n");
        ZInvite.ZOrganizer org = appt.getOrganizer();
        if (org != null) {
            String orgEmail = org.getEmailAddress().getFullAddress();
            String oldOrgEmail = oldAppt == null || oldAppt.getOrganizer() == null ? null : oldAppt.getOrganizer().getEmailAddress().getFullAddress();
            this.addLine(sb, ZMessageComposeBean.msg(pc, "organizer"), orgEmail, oldAppt != null && !orgEmail.equals(oldOrgEmail) ? mod : null, html, null);
            sb.append("\n");
        }
        if (html) {
            sb.append("</table>\n");
        }
        sb.append("\n");
        if (html) {
            sb.append("<p>\n<table border='0'>\n");
        }
        String loc = appt.getLocation();
        String string = oldLoc = oldAppt == null ? null : oldAppt.getLocation();
        if (loc != null) {
            this.addLine(sb, ZMessageComposeBean.msg(pc, "location"), loc, oldAppt != null && !loc.equals(oldLoc) ? mod : null, html, null);
            sb.append("\n");
        }
        String timeBlurb = BeanUtils.getApptDateBlurb(pc, tz, html ? appt.getStart().getDate().getTime() : this.getApptStartCalendar().getTimeInMillis(), html ? appt.getEnd().getDate().getTime() : this.getApptEndCalendar().getTimeInMillis(), this.getAllDay());
        String oldTimeBlurb = oldAppt == null ? null : BeanUtils.getApptDateBlurb(pc, tz, oldAppt.getStart().getDate().getTime(), oldAppt.getComputedEndDate().getTime(), oldAppt.isAllDay());
        boolean diffTime = oldAppt != null && !timeBlurb.equals(oldTimeBlurb);
        this.addLine(sb, ZMessageComposeBean.msg(pc, "time"), timeBlurb, oldAppt != null && diffTime ? mod : null, html, tzId);
        sb.append("\n");
        ZSimpleRecurrence repeat = appt.getSimpleRecurrence();
        ZSimpleRecurrence oldRepeat = oldAppt == null ? null : oldAppt.getSimpleRecurrence();
        String repeatStr = BeanUtils.getRepeatBlurb(repeat, pc, tz, appt.getStart().getDate());
        String oldRepeatStr = oldAppt == null ? "" : BeanUtils.getRepeatBlurb(oldRepeat, pc, tz, oldAppt.getStart().getDate());
        boolean bl = diffRepeat = oldAppt != null && !repeatStr.equals(oldRepeatStr);
        if (repeat.getType() != ZSimpleRecurrence.ZSimpleRecurrenceType.NONE || diffRepeat) {
            this.addLine(sb, ZMessageComposeBean.msg(pc, "recurrence"), repeatStr, diffRepeat ? mod : null, html, null);
            sb.append("\n");
        }
        if (html) {
            sb.append("</table>\n");
        }
        if ((attendees = appt.getAttendees()) != null && attendees.size() > 0) {
            if (html) {
                sb.append("<p>\n<table border='0'>\n");
            }
            sb.append("\n");
            String alist = this.getAttendeeList(attendees);
            String oldAlist = oldAppt == null ? null : this.getAttendeeList(oldAppt.getAttendees());
            this.addLine(sb, ZMessageComposeBean.msg(pc, "invitees"), alist, oldAppt != null && !alist.equals(oldAlist) ? mod : null, html, null);
            if (html) {
                sb.append("</table>\n");
            }
        }
        sb.append(html ? "<div>" : "\n\n");
        sb.append(NOTES_SEPARATOR);
        sb.append(html ? "</div><br>" : "\n\n");
        return sb.toString();
    }

    private String getAttendeeList(List<ZInvite.ZAttendee> attendees) {
        if (attendees == null || attendees.size() == 0) {
            return "";
        }
        StringBuilder a = new StringBuilder();
        int n = 0;
        for (ZInvite.ZAttendee attendee : attendees) {
            if (a.length() > 0) {
                a.append("; ");
            }
            a.append(attendee.getEmailAddress().getFullAddress());
            if (n++ <= 10) continue;
            break;
        }
        if (attendees.size() > 10) {
            a.append("; ...");
        }
        return a.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public ZMailbox.ZOutgoingMessage toOutgoingMessage(ZMailbox mailbox) throws ServiceException {
        void var6_21;
        ZMailbox.ZOutgoingMessage.MessagePart related;
        ZMailbox.ZOutgoingMessage.MessagePart html;
        boolean hasText;
        ArrayList addrs = new ArrayList();
        if (this.mTo != null && this.mTo.length() > 0) {
            addrs.addAll(ZEmailAddress.parseAddresses((String)this.mTo, (String)"t"));
        }
        if (this.mReplyTo != null && this.mReplyTo.length() > 0) {
            addrs.addAll(ZEmailAddress.parseAddresses((String)this.mReplyTo, (String)"r"));
        }
        if (this.mCc != null && this.mCc.length() > 0) {
            addrs.addAll(ZEmailAddress.parseAddresses((String)this.mCc, (String)"c"));
        }
        if (this.mFrom != null && this.mFrom.length() > 0) {
            addrs.addAll(ZEmailAddress.parseAddresses((String)this.mFrom, (String)"f"));
        }
        if (this.mBcc != null && this.mBcc.length() > 0) {
            addrs.addAll(ZEmailAddress.parseAddresses((String)this.mBcc, (String)"b"));
        }
        if (this.mAttendees != null && this.mAttendees.length() > 0) {
            addrs.addAll(ZEmailAddress.parseAddresses((String)this.mAttendees, (String)"t"));
        }
        if (this.mResources != null && this.mResources.length() > 0) {
            addrs.addAll(ZEmailAddress.parseAddresses((String)this.mResources, (String)"t"));
        }
        ZMailbox.ZOutgoingMessage m = new ZMailbox.ZOutgoingMessage();
        if (this.mMessageAttachments != null && this.mMessageAttachments.size() > 0) {
            ArrayList<String> messages = new ArrayList<String>();
            for (MessageAttachment messageAttachment : this.mMessageAttachments) {
                messages.add(messageAttachment.getId());
            }
            m.setMessageIdsToAttach(messages);
        }
        if (this.mDocumentAttachments != null && this.mDocumentAttachments.size() > 0) {
            ArrayList<String> docs = new ArrayList<String>();
            for (DocumentAttachment documentAttachment : this.mDocumentAttachments) {
                docs.add(documentAttachment.getId());
            }
            m.setDocIdsToAttach(docs);
        }
        if (this.mCheckedAttachmentNames != null && this.mCheckedAttachmentNames.size() > 0) {
            ArrayList<ZMailbox.ZOutgoingMessage.AttachedMessagePart> attachments = new ArrayList<ZMailbox.ZOutgoingMessage.AttachedMessagePart>();
            for (Map.Entry entry : this.mCheckedAttachmentNames.entrySet()) {
                String mid = this.mDraftId != null && this.mDraftId.length() > 0 ? this.mDraftId : this.mMessageId;
                if (mid == null || mid.length() <= 0) continue;
                attachments.add(new ZMailbox.ZOutgoingMessage.AttachedMessagePart(mid, (String)entry.getKey(), entry.getValue() != null && !((String)entry.getValue()).equals("true") ? (String)entry.getValue() : null));
            }
            m.setMessagePartsToAttach(attachments);
        }
        m.setAddresses(addrs);
        m.setSubject(this.mSubject);
        m.setPriority(this.mPriority);
        if (this.mInReplyTo != null && this.mInReplyTo.length() > 0) {
            m.setInReplyTo(this.mInReplyTo);
        }
        if (this.mMessageId != null && this.mMessageId.length() > 0 && this.mReplyType != null && this.mReplyType.length() > 0) {
            m.setOriginalMessageId(this.mMessageId);
        }
        if (this.mDraftId != null && this.mDraftId.length() > 0) {
            m.setMessageId(this.mDraftId);
            m.setDraftMessageId(this.mDraftId);
        }
        if (this.mReplyType != null && this.mReplyType.length() > 0) {
            m.setReplyType(this.mReplyType);
        }
        boolean hasHtml = this.mHtmlContent != null && this.mHtmlContent.length() > 0;
        boolean bl = hasText = this.mContent != null;
        if (hasHtml && hasText) {
            List list = m.getInlineMessagePartsToAttach();
            if (list != null && list.size() > 0) {
                html = new ZMailbox.ZOutgoingMessage.MessagePart("text/html", this.mHtmlContent, list);
                related = new ZMailbox.ZOutgoingMessage.MessagePart("multipart/related", new ZMailbox.ZOutgoingMessage.MessagePart[]{html});
                m.setMessagePart(new ZMailbox.ZOutgoingMessage.MessagePart("multipart/alternative", new ZMailbox.ZOutgoingMessage.MessagePart[]{new ZMailbox.ZOutgoingMessage.MessagePart("text/plain", this.mContent), related}));
            } else {
                m.setMessagePart(new ZMailbox.ZOutgoingMessage.MessagePart("multipart/alternative", new ZMailbox.ZOutgoingMessage.MessagePart[]{new ZMailbox.ZOutgoingMessage.MessagePart("text/plain", this.mContent), new ZMailbox.ZOutgoingMessage.MessagePart("text/html", this.mHtmlContent)}));
            }
        } else if (hasHtml) {
            List list = m.getInlineMessagePartsToAttach();
            if (list != null && list.size() > 0) {
                html = new ZMailbox.ZOutgoingMessage.MessagePart("text/html", this.mHtmlContent != null ? this.mHtmlContent : "", list);
                related = new ZMailbox.ZOutgoingMessage.MessagePart("multipart/related", new ZMailbox.ZOutgoingMessage.MessagePart[]{html});
                m.setMessagePart(new ZMailbox.ZOutgoingMessage.MessagePart("multipart/alternative", new ZMailbox.ZOutgoingMessage.MessagePart[]{related}));
            } else {
                m.setMessagePart(new ZMailbox.ZOutgoingMessage.MessagePart("text/html", this.mHtmlContent != null ? this.mHtmlContent : ""));
            }
        } else {
            m.setMessagePart(new ZMailbox.ZOutgoingMessage.MessagePart(this.mContentType, this.mContent != null ? this.mContent : ""));
        }
        Object var6_16 = null;
        if (this.getHasFileItems()) {
            int num = 0;
            for (FileItem item : this.mFileItems) {
                if (item.getSize() <= 0L) continue;
                ++num;
            }
            Part[] parts = new Part[num * 3];
            int i = 0;
            int j = 0;
            for (FileItem item : this.mFileItems) {
                if (item.getSize() <= 0L) continue;
                String name = item.getName();
                try {
                    name = new String(item.getName().getBytes("UTF-8"), "UTF-8");
                }
                catch (Exception e) {
                    System.out.println("Failed to get UTF8 name for " + name);
                    e.printStackTrace();
                    name = item.getName();
                }
                parts[i++] = new StringPart("_charset_", "UTF-8", "UTF-8");
                parts[i++] = new StringPart("filename" + j++, name, "UTF-8");
                parts[i++] = new FilePart(item.getFieldName(), (PartSource)new UploadPartSource(item), item.getContentType(), "UTF-8");
            }
            try {
                if (parts.length > 0) {
                    String string = mailbox.uploadAttachments(parts, 60000);
                }
            }
            finally {
                for (FileItem item : this.mFileItems) {
                    try {
                        item.delete();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (this.mUploadedAttachmentId != null) {
            void var6_18;
            if (var6_18 != null) {
                String string = (String)var6_18 + "," + this.mUploadedAttachmentId;
            } else {
                String string = this.mUploadedAttachmentId;
            }
        }
        m.setAttachmentUploadId((String)var6_21);
        return m;
    }

    public static class UploadPartSource
    implements PartSource {
        private FileItem mItem;

        public UploadPartSource(FileItem item) {
            this.mItem = item;
        }

        public long getLength() {
            return this.mItem.getSize();
        }

        public String getFileName() {
            return this.mItem.getName();
        }

        public InputStream createInputStream() throws IOException {
            return this.mItem.getInputStream();
        }
    }

    public static class AppointmentOptions {
        private Calendar mDate;
        private String mInviteId;
        private String mExceptionInviteId;
        private boolean mUseInstance;
        private boolean mIsTask;
        private long mInstanceStartTime;
        private long mInstanceDuration;

        public Calendar getDate() {
            return this.mDate;
        }

        public void setDate(Calendar date) {
            this.mDate = date;
        }

        public String getInviteId() {
            return this.mInviteId;
        }

        public void setInviteId(String inviteId) {
            this.mInviteId = inviteId;
        }

        public String getExceptionInviteId() {
            return this.mExceptionInviteId;
        }

        public void setExceptionInviteId(String exceptionInviteId) {
            this.mExceptionInviteId = exceptionInviteId;
        }

        public boolean isUseInstance() {
            return this.mUseInstance;
        }

        public void setUseInstance(boolean useInstance) {
            this.mUseInstance = useInstance;
        }

        public boolean isTask() {
            return this.mIsTask;
        }

        public void setIsTask(boolean isTask) {
            this.mIsTask = isTask;
        }

        public long getInstanceStartTime() {
            return this.mInstanceStartTime;
        }

        public void setInstanceStartTime(long instanceStartTime) {
            this.mInstanceStartTime = instanceStartTime;
        }

        public long getInstanceDuration() {
            return this.mInstanceDuration;
        }

        public void setInstanceDuration(long instanceDuration) {
            this.mInstanceDuration = instanceDuration;
        }
    }

    public static enum Action {
        NEW,
        REPLY,
        REPLY_ALL,
        FORWARD,
        RESEND,
        DRAFT,
        APPT_NEW,
        APPT_EDIT,
        APPT_CANCEL,
        INVITE_ACCEPT,
        INVITE_DECLINE,
        INVITE_TENTATIVE;

    }

    public static class DocumentAttachment {
        private String Id;
        private String mSubject;

        public DocumentAttachment(String id, String subject) {
            this.Id = id;
            this.mSubject = subject;
        }

        public String getId() {
            return this.Id;
        }

        public String getSubject() {
            return this.mSubject;
        }
    }

    public static class MessageAttachment {
        private String mId;
        private String mSubject;

        public MessageAttachment(String id, String subject) {
            this.mId = id;
            this.mSubject = subject;
        }

        public String getId() {
            return this.mId;
        }

        public String getSubject() {
            return this.mSubject;
        }
    }
}

