/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.client.ZEmailAddress;
import com.zimbra.client.ZInvite;
import com.zimbra.client.ZMessage;
import com.zimbra.client.ZShare;
import com.zimbra.common.util.DateUtil;
import com.zimbra.cs.taglib.bean.BeanUtils;
import com.zimbra.cs.taglib.bean.ZMimePartBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZMessageBean {
    private ZMessage mMsg;
    private Set<String> mUsedParts = new HashSet<String>();
    private int mExternalImages = 0;
    private ZShare mShare = null;
    private List<ZMimePartBean> mAttachments;
    private static Pattern sIMG = Pattern.compile("(<IMG[^>]+)dfsrc=\"([^\"]+)\"", 2);

    public ZMessageBean(ZMessage msg) {
        this.mMsg = msg;
    }

    public String getId() {
        return this.mMsg.getId();
    }

    public int getExternalImageCount() {
        return this.mExternalImages;
    }

    public ZInvite getInvite() {
        return this.mMsg.getInvite();
    }

    public synchronized ZShare getShare() {
        return this.mMsg.getShare();
    }

    public String getTagIds() {
        return this.mMsg.getTagIds();
    }

    public String getPartName() {
        return this.mMsg.getPartName();
    }

    public String getFlags() {
        return this.mMsg.getFlags();
    }

    public boolean getHasFlags() {
        return this.mMsg.hasFlags();
    }

    public boolean getHasTags() {
        return this.mMsg.hasTags();
    }

    public boolean getIsUnread() {
        return this.mMsg.isUnread();
    }

    public boolean getIsFlagged() {
        return this.mMsg.isFlagged();
    }

    public boolean getIsHighPriority() {
        return this.mMsg.isHighPriority();
    }

    public boolean getIsLowPriority() {
        return this.mMsg.isLowPriority();
    }

    public boolean getHasAttachment() {
        return this.mMsg.hasAttachment();
    }

    public boolean getIsRepliedTo() {
        return this.mMsg.isRepliedTo();
    }

    public boolean getIsSentByMe() {
        return this.mMsg.isSentByMe();
    }

    public boolean getIsForwarded() {
        return this.mMsg.isForwarded();
    }

    public boolean getIsDraft() {
        return this.mMsg.isDraft();
    }

    public boolean getIsDeleted() {
        return this.mMsg.isDeleted();
    }

    public boolean getIsNotificationSent() {
        return this.mMsg.isNotificationSent();
    }

    public String getSubject() {
        return this.mMsg.getSubject();
    }

    public String getFragment() {
        return this.mMsg.getFragment();
    }

    public String getFolderId() {
        return this.mMsg.getFolderId();
    }

    public String getConversationId() {
        return this.mMsg.getConversationId();
    }

    public String getReplyType() {
        return this.mMsg.getReplyType();
    }

    public String getInReplyTo() {
        return this.mMsg.getInReplyTo();
    }

    public Date getReceivedDate() {
        return new Date(this.mMsg.getReceivedDate());
    }

    public Date getSentDate() {
        return new Date(this.mMsg.getSentDate());
    }

    public String getDisplaySentDate() {
        return DateUtil.toRFC822Date((Date)this.getSentDate());
    }

    public String getMessageIdHeader() {
        return this.mMsg.getMessageIdHeader();
    }

    public Map<String, String> getRequestHeader() {
        return this.mMsg.getRequestHeader();
    }

    public List<ZEmailAddress> getEmailAddresses() {
        return this.mMsg.getEmailAddresses();
    }

    public ZMessage.ZMimePart getMimeStructure() {
        return this.mMsg.getMimeStructure();
    }

    public long getSize() {
        return this.mMsg.getSize();
    }

    public String getContent() {
        return this.mMsg.getContent();
    }

    public String getContentURL() {
        return this.mMsg.getContentURL();
    }

    private ZMessage.ZMimePart getBody(ZMessage.ZMimePart mp) {
        if (mp == null) {
            return null;
        }
        if (mp.isBody()) {
            return mp;
        }
        for (ZMessage.ZMimePart child : mp.getChildren()) {
            ZMessage.ZMimePart cmp = this.getBody(child);
            if (cmp == null) continue;
            return cmp;
        }
        return null;
    }

    public ZMimePartBean getBody() {
        ZMessage.ZMimePart body = this.getBody(this.mMsg.getMimeStructure());
        return body == null ? null : new ZMimePartBean(body);
    }

    private void addAttachments(List<ZMimePartBean> list, ZMessage.ZMimePart part) {
        String ct;
        if (this.mUsedParts.contains(part.getPartName())) {
            return;
        }
        boolean rfc822 = "message/rfc822".equalsIgnoreCase(part.getContentType());
        String string = ct = part.getContentType() != null ? part.getContentType().toLowerCase() : "";
        if ((rfc822 || part.getContentLocation() != null || "attachment".equalsIgnoreCase(part.getContentDisposition()) || part.getContentId() != null || part.getFileName() != null) && !ZMimePartBean.isIgnoredPArt(part)) {
            list.add(new ZMimePartBean(part));
        }
        if (rfc822) {
            return;
        }
        for (ZMessage.ZMimePart child : part.getChildren()) {
            this.addAttachments(list, child);
        }
    }

    public String getAttachmentIds() {
        StringBuilder sb = new StringBuilder();
        for (ZMimePartBean part : this.getAttachments()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(part.getPartName());
        }
        return sb.toString();
    }

    public boolean isIgnored(ZMessage.ZMimePart top) {
        String type = top.getContentType();
        return type.equalsIgnoreCase("multipart/alternative") || type.equalsIgnoreCase("multipart/mixed") || type.equalsIgnoreCase("multipart/related") || type.equalsIgnoreCase("application/applefile") || type.equalsIgnoreCase("application/ms-tnef") || type.equalsIgnoreCase("application/vnd.ms-tnef");
    }

    public boolean isRenderable(ZMessage.ZMimePart top) {
        String type = top.getContentType();
        return type.equalsIgnoreCase("text/html") || type.equalsIgnoreCase("text/plain") || type.equalsIgnoreCase("image/gif") || type.equalsIgnoreCase("image/jpeg") || type.equalsIgnoreCase("image/png");
    }

    public synchronized List<ZMimePartBean> getAttachments() {
        if (this.mAttachments == null) {
            this.mAttachments = new ArrayList<ZMimePartBean>();
            ZMessage.ZMimePart top = this.mMsg.getMimeStructure();
            if (top != null) {
                ZMimePartBean bb;
                for (ZMessage.ZMimePart child : top.getChildren()) {
                    this.addAttachments(this.mAttachments, child);
                }
                if (!(!this.mAttachments.isEmpty() || this.isIgnored(top) || this.isRenderable(top) && top.isBody() || !(bb = new ZMimePartBean(top)).getIsVideo() && !bb.getIsImage() && !bb.getIsAudio() && !bb.getIsApp() && bb.isBody())) {
                    this.mAttachments.add(bb);
                }
            }
        }
        return this.mAttachments;
    }

    public int getNumberOfAttachments() {
        return this.getAttachments().size();
    }

    public String getDisplayTo() {
        return BeanUtils.getHeaderAddrs(this.getEmailAddresses(), "t");
    }

    public String getDisplayFrom() {
        return BeanUtils.getHeaderAddrs(this.getEmailAddresses(), "f");
    }

    public String getDisplayCc() {
        return BeanUtils.getHeaderAddrs(this.getEmailAddresses(), "c");
    }

    public String getDisplayBcc() {
        return BeanUtils.getHeaderAddrs(this.getEmailAddresses(), "b");
    }

    public String getDisplaySender() {
        return BeanUtils.getHeaderAddrs(this.getEmailAddresses(), "s");
    }

    public String getDisplayReplyTo() {
        return BeanUtils.getHeaderAddrs(this.getEmailAddresses(), "r");
    }

    private static String escapeDollarSign(String value) {
        if (value == null || value.length() == 0 || value.indexOf(36) == -1) {
            return value;
        }
        return value.replace("$", "\\$");
    }

    String getBodyHtmlContent(ZMimePartBean part) {
        ZMessage.ZMimePart parent;
        if (part == null) {
            return null;
        }
        boolean isRelated = false;
        for (parent = part.getMimePart().getParent(); parent != null && !(isRelated = parent.getContentType().equals("multipart/related")); parent = parent.getParent()) {
        }
        Matcher m = sIMG.matcher(part.getContent());
        if (isRelated) {
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String src = m.group(2);
                if (src != null && src.startsWith("cid:")) {
                    src = this.resolveContentId(src.substring(4), parent);
                } else if (src != null && src.indexOf(58) == -1) {
                    src = this.resolveContentLocation(src, parent);
                }
                if (src != null) {
                    m.appendReplacement(sb, ZMessageBean.escapeDollarSign(m.group(1) + "src=\"" + src + "\""));
                    continue;
                }
                m.appendReplacement(sb, ZMessageBean.escapeDollarSign(m.group(0)));
            }
            m.appendTail(sb);
            return sb.toString();
        }
        while (m.find()) {
            ++this.mExternalImages;
        }
        return part.getContent();
    }

    public String toString() {
        return this.mMsg.toString();
    }

    private String resolveContentId(String origcid, ZMessage.ZMimePart parent) {
        String cid = "<" + origcid + ">";
        for (ZMessage.ZMimePart part : parent.getChildren()) {
            String partCid = part.getContentId();
            if (!cid.equals(partCid)) continue;
            this.mUsedParts.add(part.getPartName());
            return "/home/~/?id=" + this.mMsg.getId() + "&part=" + part.getPartName() + "&auth=co";
        }
        return null;
    }

    private String resolveContentLocation(String src, ZMessage.ZMimePart parent) {
        for (ZMessage.ZMimePart part : parent.getChildren()) {
            String partCL = part.getContentLocation();
            if (!src.equals(partCL)) continue;
            this.mUsedParts.add(part.getPartName());
            return "/home/~/?id=" + this.mMsg.getId() + "&part=" + part.getPartName() + "&auth=co";
        }
        return null;
    }

    public static String getHtmlContent(ZMimePartBean part, ZMessageBean message) {
        if (part.getIsTextHtml()) {
            return message.getBodyHtmlContent(part);
        }
        if (part.getIsTextPlain()) {
            return BeanUtils.textToHtml(part.getContent());
        }
        return "";
    }

    public static List<ZMimePartBean> getAdditionalBodies(ZMimePartBean body, ZMessageBean message) {
        ArrayList<ZMimePartBean> result = new ArrayList<ZMimePartBean>();
        if (body != null) {
            ZMessage.ZMimePart top = message.getMimeStructure();
            for (ZMessage.ZMimePart child : top.getChildren()) {
                ZMessageBean.addBody(result, body.getMimePart(), child);
            }
        }
        return result;
    }

    private static void addBody(List<ZMimePartBean> result, ZMessage.ZMimePart body, ZMessage.ZMimePart child) {
        ZMimePartBean mpb;
        if (body != child && child.isBody() && child.getContent() != null && ((mpb = new ZMimePartBean(child)).getIsTextHtml() || mpb.getIsTextPlain())) {
            result.add(mpb);
        }
        for (ZMessage.ZMimePart c : child.getChildren()) {
            ZMessageBean.addBody(result, body, c);
        }
    }

    public static ZMimePartBean getPart(ZMessageBean message, String partName) {
        ArrayList result = new ArrayList();
        ZMessage.ZMimePart top = message.getMimeStructure();
        for (ZMessage.ZMimePart child : top.getChildren()) {
            ZMimePartBean mpb = ZMessageBean.getPartInternal(child, partName);
            if (mpb == null) continue;
            return mpb;
        }
        return null;
    }

    private static ZMimePartBean getPartInternal(ZMessage.ZMimePart child, String partName) {
        if (child.getPartName().equals(partName)) {
            return new ZMimePartBean(child);
        }
        for (ZMessage.ZMimePart c : child.getChildren()) {
            ZMimePartBean b = ZMessageBean.getPartInternal(c, partName);
            if (b == null) continue;
            return b;
        }
        return null;
    }
}

