/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.client.ZContact;
import com.zimbra.client.ZFeatures;
import com.zimbra.client.ZFilterRule;
import com.zimbra.client.ZFolder;
import com.zimbra.client.ZGetInfoResult;
import com.zimbra.client.ZIdentity;
import com.zimbra.client.ZLicenses;
import com.zimbra.client.ZMailbox;
import com.zimbra.client.ZPrefs;
import com.zimbra.client.ZSignature;
import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZContactBean;
import com.zimbra.cs.taglib.bean.ZFolderBean;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class ZMailboxBean {
    private ZMailbox mMbox;

    public ZMailboxBean(ZMailbox mbox) {
        this.mMbox = mbox;
    }

    public String getName() throws ServiceException {
        return this.mMbox.getName();
    }

    public long getSize() throws ServiceException {
        return this.mMbox.getSize();
    }

    private ZFolderBean getFolderBeanById(String id) throws ServiceException {
        ZFolder folder = this.mMbox.getFolderById(id);
        return folder == null ? null : new ZFolderBean(folder);
    }

    public ZMailbox getMailbox() {
        return this.mMbox;
    }

    public String getNoOp() throws ServiceException {
        this.mMbox.noOp();
        return "";
    }

    public ZFolderBean getInbox() throws ServiceException {
        return this.getFolderBeanById("2");
    }

    public ZFolderBean getChats() throws ServiceException {
        return this.getFolderBeanById("14");
    }

    public ZFolderBean getTrash() throws ServiceException {
        return this.getFolderBeanById("3");
    }

    public ZFolderBean getSpam() throws ServiceException {
        return this.getFolderBeanById("4");
    }

    public ZFolderBean getSent() throws ServiceException {
        return this.getFolderBeanById("5");
    }

    public ZFolderBean getDrafts() throws ServiceException {
        return this.getFolderBeanById("6");
    }

    public ZFolderBean getCalendar() throws ServiceException {
        return this.getFolderBeanById("10");
    }

    public ZFolderBean getTasks() throws ServiceException {
        return this.getFolderBeanById("15");
    }

    public ZFolderBean getBriefcase() throws ServiceException {
        return this.getFolderBeanById("16");
    }

    public ZFolderBean getContacts() throws ServiceException {
        return this.getFolderBeanById("7");
    }

    public ZFolderBean getAutoContacts() throws ServiceException {
        return this.getFolderBeanById("13");
    }

    public double getBase64ToNormalRatio() throws ServiceException {
        return 1.34;
    }

    public Map<String, List<String>> getAttrs() throws ServiceException {
        return this.mMbox.getAccountInfo(false).getAttrs();
    }

    public ZGetInfoResult getAccountInfo() throws ServiceException {
        return this.mMbox.getAccountInfo(false);
    }

    public ZGetInfoResult getAccountInfoReload() throws ServiceException {
        return this.mMbox.getAccountInfo(true);
    }

    public List<ZSignature> getSignatures() throws ServiceException {
        return this.mMbox.getAccountInfo(false).getSignatures();
    }

    public ZPrefs getPrefs() throws ServiceException {
        return this.mMbox.getPrefs();
    }

    public ZFeatures getFeatures() throws ServiceException {
        return this.mMbox.getFeatures();
    }

    public ZLicenses getLicenses() throws ServiceException {
        return this.mMbox.getLicenses();
    }

    public Boolean getAdminDelegated() throws ServiceException {
        return this.mMbox.getAccountInfo(false).getAdminDelegated();
    }

    public boolean getHasTags() throws ServiceException {
        return this.mMbox.hasTags();
    }

    public List<String> getAvailableSkins() throws ServiceException {
        return this.mMbox.getAvailableSkins();
    }

    public List<String> getAvailableLocales() throws ServiceException {
        return this.mMbox.getAvailableLocales();
    }

    public List<ZIdentity> getIdentities() throws ServiceException {
        return this.mMbox.getIdentities();
    }

    public List<ZFilterRule> getFilterRules() throws ServiceException {
        return this.mMbox.getIncomingFilterRules().getRules();
    }

    public List<ZFilterRule> getFilterRulesReload() throws ServiceException {
        return this.mMbox.getIncomingFilterRules(true).getRules();
    }

    public URI getRestURI(String relativePath) throws ServiceException {
        return this.mMbox.getRestURI(relativePath);
    }

    public ZIdentity getDefaultIdentity() throws ServiceException {
        for (ZIdentity identity : this.mMbox.getAccountInfo(false).getIdentities()) {
            if (!identity.getIsDefault()) continue;
            return identity;
        }
        return null;
    }

    public ZContactBean getMyCard() throws ServiceException {
        ZContact myCard = this.mMbox.getMyCard();
        return myCard == null ? null : new ZContactBean(myCard);
    }

    public String getCsrfToken() throws ServiceException {
        return this.mMbox.getCsrfToken();
    }

    public ZAuthToken getAuthToken() throws ServiceException {
        return this.mMbox.getAuthToken();
    }
}

