/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.client.ZFolder;
import com.zimbra.client.ZGrant;
import com.zimbra.client.ZMountpoint;
import com.zimbra.client.ZSearchFolder;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import java.util.List;

public class ZFolderBean {
    private ZFolder mFolder;
    private Boolean hasPublicShare;
    private Boolean hasPrivateShare;
    private int mDepth = -1;

    public ZFolderBean(ZFolder folder) {
        this.mFolder = folder;
    }

    public ZFolder folderObject() {
        return this.mFolder;
    }

    public ZFolderBean getParent() {
        return this.mFolder.getParent() == null ? null : new ZFolderBean(this.mFolder.getParent());
    }

    public String getId() {
        return this.mFolder.getId();
    }

    public String getName() {
        return this.mFolder.getName();
    }

    public String getPath() {
        return this.mFolder.getPath();
    }

    public String getPathURLEncoded() {
        return this.mFolder.getPathURLEncoded();
    }

    public String getRootRelativePath() {
        return this.mFolder.getRootRelativePath();
    }

    public String getRootRelativePathURLEncoded() {
        return this.mFolder.getRootRelativePathURLEncoded();
    }

    public String getParentId() {
        return this.mFolder.getParentId();
    }

    public int getUnreadCount() {
        return this.getIsDrafts() ? this.getMessageCount() : this.mFolder.getUnreadCount();
    }

    public boolean getHasUnread() {
        return this.getUnreadCount() > 0;
    }

    public int getMessageCount() {
        return this.mFolder.getMessageCount();
    }

    public long getSize() {
        return this.mFolder.getSize();
    }

    public String getDefaultView() {
        return this.mFolder.getDefaultView().name();
    }

    public String getFlags() {
        return this.mFolder.getFlags();
    }

    public boolean getHasFlags() {
        return this.mFolder.hasFlags();
    }

    public boolean getIsCheckedInUI() {
        return this.mFolder.isCheckedInUI();
    }

    public boolean getIsExcludedFromFreeBusy() {
        return this.mFolder.isExcludedFromFreeBusy();
    }

    public boolean getIsIMAPSubscribed() {
        return this.mFolder.isIMAPSubscribed();
    }

    public String getColor() {
        ZFolder.Color color = this.mFolder.getColor();
        if (color == ZFolder.Color.DEFAULTCOLOR) {
            color = this.getIsContactView() || this.getIsTaskView() ? ZFolder.Color.GRAY : ZFolder.Color.ORANGE;
        }
        return color.getName();
    }

    public String getRgb() {
        return this.mFolder.getRgb();
    }

    public String getRemoteURL() {
        return StringUtil.isNullOrEmpty((String)this.mFolder.getRemoteURL()) ? null : this.mFolder.getRemoteURL();
    }

    public String getEffectivePerm() {
        return this.mFolder.getEffectivePerms();
    }

    public List<ZGrant> getGrants() {
        return this.mFolder.getGrants();
    }

    public List<ZFolder> getSubFolders() {
        return this.mFolder.getSubFolders();
    }

    public int getSubFolderCount() {
        return this.mFolder.getSubFolders().size();
    }

    public boolean getHasChildren() {
        return !this.mFolder.getSubFolders().isEmpty();
    }

    public boolean getIsSearchFolder() {
        return this.mFolder instanceof ZSearchFolder;
    }

    public String getQuery() {
        return this.getIsSearchFolder() ? ((ZSearchFolder)this.mFolder).getQuery() : "";
    }

    public boolean getIsInbox() {
        return this.mFolder.getId().equals("2");
    }

    public boolean getIsChats() {
        return this.mFolder.getId().equals("14");
    }

    public boolean getIsTrash() {
        return this.mFolder.getId().equals("3");
    }

    public boolean getIsSpam() {
        return this.mFolder.getId().equals("4");
    }

    public boolean getIsSent() {
        return this.mFolder.getId().equals("5");
    }

    public boolean getIsDrafts() {
        return this.mFolder.getId().equals("6");
    }

    public boolean getIsContacts() {
        return this.mFolder.getId().equals("7");
    }

    public boolean getIsCalendar() {
        return this.mFolder.getId().equals("10");
    }

    public boolean getIsNotebook() {
        return this.mFolder.getId().equals("12");
    }

    public boolean getIsDocument() {
        return this.mFolder.getId().equals("16");
    }

    public boolean getIsAutoContacts() {
        return this.mFolder.getId().equals("13");
    }

    public boolean getIsVoiceMailInbox() {
        return this.getIsVoiceView() && "Voicemail Inbox".equals(this.mFolder.getName());
    }

    public boolean getIsMissedCalls() {
        return this.getIsVoiceView() && "Missed Calls".equals(this.mFolder.getName());
    }

    public boolean getIsAnsweredCalls() {
        return this.getIsVoiceView() && "Answered Calls".equals(this.mFolder.getName());
    }

    public boolean getIsPlacedCalls() {
        return this.getIsVoiceView() && "Placed Calls".equals(this.mFolder.getName());
    }

    public boolean getIsVoiceMailTrash() {
        return this.getIsVoiceView() && "Trash".equals(this.mFolder.getName());
    }

    public boolean getIsMailView() {
        ZFolder.View view = this.mFolder.getDefaultView();
        return view == null || view == ZFolder.View.message || view == ZFolder.View.conversation;
    }

    public boolean getIsNullView() {
        return this.mFolder.getDefaultView() == null;
    }

    public boolean getIsUnknownView() {
        return this.mFolder.getDefaultView() == ZFolder.View.unknown;
    }

    public boolean getIsMessageView() {
        return this.mFolder.getDefaultView() == ZFolder.View.message;
    }

    public boolean getIsContactView() {
        return this.mFolder.getDefaultView() == ZFolder.View.contact;
    }

    public boolean getIsConversationView() {
        return this.mFolder.getDefaultView() == ZFolder.View.conversation;
    }

    public boolean getIsAppointmentView() {
        return this.mFolder.getDefaultView() == ZFolder.View.appointment;
    }

    public boolean getIsWikiView() {
        return this.mFolder.getDefaultView() == ZFolder.View.wiki;
    }

    public boolean getIsTaskView() {
        return this.mFolder.getDefaultView() == ZFolder.View.task;
    }

    public boolean getIsVoiceView() {
        return this.mFolder.getDefaultView() == ZFolder.View.voice;
    }

    public boolean getIsDocumentView() {
        return this.mFolder.getDefaultView() == ZFolder.View.document;
    }

    public boolean getIsSystemFolder() {
        return this.mFolder.isSystemFolder();
    }

    public boolean getIsMountPoint() {
        return this.mFolder instanceof ZMountpoint;
    }

    public boolean getIsInTrash() {
        if (this.getId().equals("3")) {
            return true;
        }
        for (ZFolder parent = this.mFolder.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getId().equals("3")) continue;
            return true;
        }
        return false;
    }

    public String getOwnerDisplayName() {
        return this.mFolder instanceof ZMountpoint ? ((ZMountpoint)this.mFolder).getOwnerDisplayName() : null;
    }

    public String getOwnerId() {
        return this.mFolder instanceof ZMountpoint ? ((ZMountpoint)this.mFolder).getOwnerId() : null;
    }

    public String getRemoteId() {
        return this.mFolder instanceof ZMountpoint ? ((ZMountpoint)this.mFolder).getRemoteId() : null;
    }

    public String getCanonicalRemoteId() {
        return this.mFolder instanceof ZMountpoint ? ((ZMountpoint)this.mFolder).getCanonicalRemoteId() : null;
    }

    public boolean getIsFeed() {
        return !StringUtil.isNullOrEmpty((String)this.mFolder.getRemoteURL());
    }

    public String getCanonicalId() {
        return this.mFolder instanceof ZMountpoint ? ((ZMountpoint)this.mFolder).getCanonicalRemoteId() : this.mFolder.getId();
    }

    public synchronized int getDepth() {
        if (this.mDepth != -1) {
            return this.mDepth;
        }
        int depth = 0;
        String path = this.getPath();
        for (int i = 1; i < path.length(); ++i) {
            if (path.charAt(i) != '/') continue;
            ++depth;
        }
        return depth;
    }

    public boolean getIsMountPointWritable() {
        String positivePerm;
        String perm;
        if (this.getIsMountPoint() && (perm = this.getEffectivePerm()) != null && (positivePerm = perm.replace("/-./g", "")) != null) {
            return positivePerm.indexOf("w") != -1;
        }
        return false;
    }

    public boolean getIsMessageMoveTarget() {
        return this.getIsConversationMoveTarget();
    }

    public boolean getIsConversationMoveTarget() {
        boolean isSpamEnabled = true;
        try {
            isSpamEnabled = this.folderObject().getMailbox().getFeatures().getSpam();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return !(!this.getIsMessageView() && !this.getIsConversationView() && !this.getIsNullView() && !this.getIsUnknownView() || this.getIsMountPoint() && !this.getIsMountPointWritable() || this.getIsDrafts() || this.getIsSearchFolder() || !StringUtil.isNullOrEmpty((String)this.getRemoteURL()) || this.getId().equals("14") || this.getId().equals("4") && !isSpamEnabled);
    }

    public boolean getIsMessageFolderMarkReadTarget() {
        return (this.getIsMessageView() || this.getIsConversationView() || this.getIsNullView()) && !this.getIsDrafts() && !this.getIsMountPoint() && !this.getIsSearchFolder();
    }

    public boolean getIsMessageFolderRenameTarget() {
        return (this.getIsMessageView() || this.getIsConversationView() || this.getIsNullView()) && !this.getIsSystemFolder() && !this.getIsSearchFolder();
    }

    public boolean getIsMessageFolderMoveSource() {
        return (this.getIsMessageView() || this.getIsConversationView() || this.getIsNullView()) && !this.getIsSystemFolder();
    }

    public boolean getIsMessageFolderDeleteTarget() {
        return (this.getIsMessageView() || this.getIsConversationView() || this.getIsNullView()) && !this.getIsSystemFolder() && !this.getIsSearchFolder();
    }

    public boolean getIsContactMoveTarget() {
        return !(!this.getIsContactView() && !this.getIsTrash() || this.getRemoteURL() != null || this.getIsDrafts() || this.getIsSearchFolder() || this.getIsMountPoint() && !this.getIsMountPointWritable());
    }

    public boolean getIsAppointmentMoveTarget() {
        return this.getIsAppointmentView() && this.getRemoteURL() == null && (!this.getIsMountPoint() || this.getIsMountPointWritable());
    }

    public boolean getIsTaskMoveTarget() {
        return this.getIsTaskView() && this.getRemoteURL() == null && (!this.getIsMountPoint() || this.getIsMountPointWritable());
    }

    public boolean getIsDocumentMoveTarget() {
        return this.getIsDocumentView() && !this.getIsMountPoint() && this.getRemoteURL() == null;
    }

    public boolean getIsWikiMoveTarget() {
        return this.getIsWikiView() && !this.getIsMountPoint() && this.getRemoteURL() == null;
    }

    public boolean getIsContactCreateTarget() {
        return this.getIsContactView() && this.getRemoteURL() == null && !this.getIsDrafts() && !this.getIsSearchFolder() && (!this.getIsMountPoint() || this.getIsMountPointWritable());
    }

    public String getStyleColor() {
        return ZFolderBean.getStyleColor(this.mFolder.getColor(), this.mFolder.getDefaultView());
    }

    public static String getStyleColor(ZFolder.Color color, ZFolder.View view) {
        String colorName = color.getName();
        if (!StringUtil.equal((String)colorName, (String)"rgbColor") && !StringUtil.equal((String)colorName, (String)ZFolder.Color.DEFAULTCOLOR.getName())) {
            return colorName.substring(0, 1).toUpperCase() + colorName.substring(1);
        }
        colorName = view == ZFolder.View.contact || view == ZFolder.View.task ? ZFolder.Color.GRAY.getName() : ZFolder.Color.ORANGE.getName();
        return colorName.substring(0, 1).toUpperCase() + colorName.substring(1);
    }

    public String getRgbColor() {
        return ZFolderBean.getRgbColor(this.mFolder.getColor(), this.mFolder.getDefaultView());
    }

    public int getRgbColorIndex() {
        if (this.getRgb() != null) {
            return 0;
        }
        return ZFolderBean.getRgbColorIndex(this.mFolder.getColor(), this.mFolder.getDefaultView());
    }

    public String getRgbColorMsg() {
        return ZFolder.RGB_COLORS_MSG[this.getRgbColorIndex()];
    }

    public static String getRgbColorMsg(ZFolder.Color color, ZFolder.View view) {
        return ZFolder.RGB_COLORS_MSG[ZFolderBean.getRgbColorIndex(color, view)];
    }

    public static String getRgbColor(ZFolder.Color color, ZFolder.View view) {
        int colorIndex = (int)color.getValue();
        if (color == ZFolder.Color.DEFAULTCOLOR) {
            colorIndex = view == ZFolder.View.contact || view == ZFolder.View.task ? (int)ZFolder.Color.GRAY.getValue() : (int)ZFolder.Color.ORANGE.getValue();
        }
        return ZFolder.RGB_COLORS[colorIndex];
    }

    public static int getRgbColorIndex(ZFolder.Color color, ZFolder.View view) {
        if (color == ZFolder.Color.DEFAULTCOLOR) {
            if (view == ZFolder.View.contact || view == ZFolder.View.task) {
                return (int)ZFolder.Color.GRAY.getValue();
            }
            return (int)ZFolder.Color.ORANGE.getValue();
        }
        return (int)color.getValue();
    }

    public String getImage() {
        if (this.getIsSearchFolder()) {
            return "startup/ImgSearchFolder.png";
        }
        if (this.getIsAppointmentView() || this.getParentId().equals("10") && this.getIsUnknownView()) {
            if (this.getIsMountPoint()) {
                return "calendar/ImgSharedCalendarFolder.png";
            }
            return "calendar/ImgCalendarFolder.png";
        }
        if (this.getIsContactView() || this.getParentId().equals("7") && this.getIsUnknownView()) {
            if (this.getIsMountPoint()) {
                return "contacts/ImgSharedContactsFolder.png";
            }
            if (this.getIsAutoContacts()) {
                return "contacts/ImgEmailedContacts.png";
            }
            return "contacts/ImgContactsFolder.png";
        }
        if (this.getIsTaskView() || this.getParentId().equals("15") && this.getIsUnknownView()) {
            if (this.getIsMountPoint()) {
                return "tasks/ImgSharedTaskList.png";
            }
            return "startup/ImgTaskList.png";
        }
        if (this.getIsSystemFolder()) {
            if (this.getIsInbox()) {
                return "startup/ImgInbox.png";
            }
            if (this.getIsTrash()) {
                return "startup/ImgTrash.png";
            }
            if (this.getIsSpam()) {
                return "startup/ImgSpamFolder.png";
            }
            if (this.getIsSent()) {
                return "startup/ImgSentFolder.png";
            }
            if (this.getIsDrafts()) {
                return "startup/ImgDraftFolder.png";
            }
            return "startup/ImgFolder.png";
        }
        if (this.getIsMailView() && this.getIsFeed()) {
            return "startup/ImgRSS.png";
        }
        if (this.getIsMountPoint()) {
            return "startup/ImgSharedMailFolder.png";
        }
        if (this.getIsVoiceView()) {
            String name = this.getName();
            if ("Placed Calls".equals(name)) {
                return "voicemail/ImgPlacedCalls.png";
            }
            if ("Answered Calls".equals(name)) {
                return "voicemail/ImgAnsweredCalls.png";
            }
            if ("Missed Calls".equals(name)) {
                return "voicemail/ImgMissedCalls.png";
            }
            if ("Voicemail Inbox".equals(name)) {
                return "voicemail/ImgVoicemail.png";
            }
            if ("Trash".equals(name)) {
                return "startup/ImgTrash.png";
            }
            return null;
        }
        return "startup/ImgFolder.png";
    }

    public String getTypes() {
        return this.getIsSearchFolder() ? ((ZSearchFolder)this.mFolder).getTypes() : null;
    }

    public String getType() {
        if (this.getIsSearchFolder()) {
            return "SearchFolder";
        }
        if (this.getIsAppointmentView()) {
            if (this.getIsMountPoint()) {
                return "SharedCalendarFolder";
            }
            return "CalendarFolder";
        }
        if (this.getIsContactView()) {
            if (this.getIsMountPoint()) {
                return "SharedContactsFolder";
            }
            if (this.getIsAutoContacts()) {
                return "EmailedContacts";
            }
            return "ContactsFolder";
        }
        if (this.getIsTaskView()) {
            if (this.getIsMountPoint()) {
                return "SharedTaskList";
            }
            return "TaskList";
        }
        if (this.getIsSystemFolder()) {
            if (this.getIsInbox()) {
                return "Inbox";
            }
            if (this.getIsTrash()) {
                return "Trash";
            }
            if (this.getIsSpam()) {
                return "SpamFolder";
            }
            if (this.getIsSent()) {
                return "SentFolder";
            }
            if (this.getIsDrafts()) {
                return "DraftFolder";
            }
            return "Folder";
        }
        if (this.getIsMailView() && this.getIsFeed()) {
            return "RSS";
        }
        if (this.getIsMountPoint()) {
            return "SharedMailFolder";
        }
        if (this.getIsVoiceView()) {
            String name = this.getName();
            if ("Placed Calls".equals(name)) {
                return "PlacedCalls";
            }
            if ("Answered Calls".equals(name)) {
                return "AnsweredCalls";
            }
            if ("Missed Calls".equals(name)) {
                return "MissedCalls";
            }
            if ("Voicemail Inbox".equals(name)) {
                return "Voicemail";
            }
            if ("Trash".equals(name)) {
                return "Trash";
            }
            return null;
        }
        return "Folder";
    }

    public Boolean getHasPublicShare() {
        if (this.hasPublicShare == null) {
            this.initShareFlags();
        }
        return this.hasPublicShare;
    }

    public Boolean getHasPrivateShare() {
        if (this.hasPrivateShare == null) {
            this.initShareFlags();
        }
        return this.hasPrivateShare;
    }

    private void initShareFlags() {
        List<ZGrant> grants = this.getGrants();
        for (ZGrant grant : grants) {
            if (grant.getGranteeType().equals((Object)ZGrant.GranteeType.pub)) {
                this.hasPublicShare = true;
            }
            if (grant.getGranteeType().equals((Object)ZGrant.GranteeType.usr)) {
                this.hasPrivateShare = true;
            }
            if (this.hasPublicShare == null || this.hasPrivateShare == null) continue;
            break;
        }
        if (this.hasPublicShare == null) {
            this.hasPublicShare = false;
        }
        if (this.hasPrivateShare == null) {
            this.hasPrivateShare = false;
        }
    }
}

