/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.taglib.bean.ZTagLibException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;

public class ZFileUploaderBean {
    private static final long DEFAULT_MAX_SIZE = 0x6400000L;
    private boolean mIsUpload;
    private List<FileItem> mFiles;
    private Map<String, List<String>> mParamValues;
    private Map<String, String> mParams;

    public ZFileUploaderBean(PageContext pageContext, ZMailbox mailbox) throws JspTagException, ServiceException {
        HttpServletRequest req = (HttpServletRequest)pageContext.getRequest();
        ServletFileUpload upload = ZFileUploaderBean.getUploader();
        try {
            this.mIsUpload = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
            if (this.mIsUpload) {
                this.mParamValues = new HashMap<String, List<String>>();
                this.mParams = new HashMap<String, String>();
                this.mFiles = new ArrayList<FileItem>();
                this.init(pageContext, upload.parseRequest(req));
            }
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            throw new JspTagException((Throwable)((Object)ZTagLibException.UPLOAD_SIZE_LIMIT_EXCEEDED("size limit exceeded", e)));
        }
        catch (FileUploadBase.InvalidContentTypeException e) {
            throw new JspTagException((Throwable)((Object)ZTagLibException.UPLOAD_FAILED(e.getMessage(), e)));
        }
        catch (FileUploadException e) {
            throw new JspTagException((Throwable)((Object)ZTagLibException.UPLOAD_FAILED(e.getMessage(), e)));
        }
    }

    private void init(PageContext pageContext, List<FileItem> items) throws ServiceException {
        for (FileItem item : items) {
            List<String> values;
            String value;
            String name = item.getFieldName();
            if (!item.isFormField()) {
                if (item.getName() == null || item.getName().length() <= 0) continue;
                this.mFiles.add(item);
                List<String> values2 = this.mParamValues.get(name);
                if (values2 == null) {
                    values2 = new ArrayList<String>();
                    this.mParamValues.put(name, values2);
                    this.mParams.put(name, item.getName());
                }
                values2.add(item.getName());
                continue;
            }
            try {
                value = item.getString("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                value = item.getString();
            }
            if (name.startsWith("action") && name.endsWith(".x")) {
                name = name.substring(0, name.length() - 2);
            }
            if ((values = this.mParamValues.get(name)) == null) {
                values = new ArrayList<String>();
                this.mParamValues.put(name, values);
                this.mParams.put(name, value);
            }
            values.add(value);
        }
    }

    public List<FileItem> getFiles() {
        return this.mFiles;
    }

    public boolean hasParam(String name) {
        return this.mParamValues.get(name) != null;
    }

    public long getParamLong(String name, long defaultValue) {
        String v = this.getParam(name);
        if (v != null) {
            try {
                return Long.parseLong(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public int getParamInt(String name, int defaultValue) {
        String v = this.getParam(name);
        if (v != null) {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public String getParam(String name) {
        List<String> values = this.mParamValues.get(name);
        return values == null ? null : values.get(0);
    }

    public List<String> getParamValueList(String name) {
        return this.mParamValues.get(name);
    }

    public Map<String, List<String>> getParamValues() {
        return this.mParamValues;
    }

    public Map<String, String> getParams() {
        return this.mParams;
    }

    public boolean getIsUpload() {
        return this.mIsUpload;
    }

    private static ServletFileUpload getUploader() {
        DiskFileItemFactory dfif = new DiskFileItemFactory();
        dfif.setSizeThreshold(32768);
        dfif.setRepository(new File(ZFileUploaderBean.getTempDirectory()));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)dfif);
        upload.setSizeMax(0x6400000L);
        return upload;
    }

    private static String getTempDirectory() {
        return System.getProperty("java.io.tmpdir", "/tmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUploadId(ZMailbox mailbox) throws ServiceException {
        if (!this.mFiles.isEmpty()) {
            Part[] parts = new Part[this.mFiles.size()];
            int i = 0;
            for (FileItem item : this.mFiles) {
                parts[i++] = new FilePart(item.getFieldName(), (PartSource)new UploadPartSource(item), item.getContentType(), "utf-8");
            }
            try {
                String string = mailbox.uploadAttachments(parts, 60000);
                return string;
            }
            finally {
                for (FileItem item : this.mFiles) {
                    try {
                        item.delete();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return null;
    }

    public static class UploadPartSource
    implements PartSource {
        private FileItem mItem;

        public UploadPartSource(FileItem item) {
            this.mItem = item;
        }

        public long getLength() {
            return this.mItem.getSize();
        }

        public String getFileName() {
            return this.mItem.getName();
        }

        public InputStream createInputStream() throws IOException {
            return this.mItem.getInputStream();
        }
    }
}

