/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.ZimbraNamespace;
import com.zimbra.common.util.ExceptionToString;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.taglib.bean.ZTagLibException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.SkipPageException;

public class ZExceptionBean {
    private ServiceException exception;

    public ZExceptionBean(Throwable e) {
        if (e instanceof JspException) {
            while (e instanceof JspException && ((JspException)e).getRootCause() != null) {
                e = ((JspException)e).getRootCause();
            }
        }
        if (!(e instanceof ServiceException) && e.getCause() instanceof ServiceException) {
            e = e.getCause();
        }
        if (e instanceof SoapFaultException) {
            String code = ((SoapFaultException)e).getCode();
            if (code != null && (code.equals("service.AUTH_EXPIRED") || code.equals("service.AUTH_REQUIRED") || code.equals("account.AUTH_FAILED"))) {
                ZimbraLog.webclient.debug((Object)e.getMessage(), e);
            } else {
                ZimbraLog.webclient.warn((Object)e.getMessage(), e);
            }
        } else if (!(e instanceof SkipPageException)) {
            ZimbraLog.webclient.warn((Object)e.getMessage(), e);
        }
        this.exception = e instanceof ServiceException ? (ServiceException)e : ZTagLibException.TAG_EXCEPTION(e.getMessage(), e);
    }

    public Exception getException() {
        return this.exception;
    }

    public String getCode() {
        return this.exception.getCode();
    }

    public String getId() {
        return this.exception.getId();
    }

    public String getStackStrace() {
        return ExceptionToString.ToString((Throwable)this.exception);
    }

    public List<Argument> getArguments() {
        ArrayList<Argument> args = new ArrayList<Argument>();
        try {
            SoapFaultException sfe;
            Element d;
            if (this.exception instanceof SoapFaultException && (d = (sfe = (SoapFaultException)this.exception).getDetail()) != null) {
                List list = d.getPathElementList(new String[]{ZimbraNamespace.E_ERROR.getName(), ZimbraNamespace.E_ARGUMENT.getName()});
                for (Element el : list) {
                    args.add(new Argument(el.getAttribute("n", ""), el.getAttribute("t", ""), el.getText()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return args;
    }

    public static class Argument {
        private String name;
        private String type;
        private String val;

        Argument(String name, String type, String val) {
            this.type = type;
            this.name = name;
            this.val = val;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getVal() {
            return this.val;
        }
    }
}

